/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.pki;

import com.sun.javacard.impl.NativeMethods;
import com.sun.midp.pki.Utils;
import com.sun.spot.security.GeneralSecurityException;
import com.sun.spot.security.MessageDigest;
import com.sun.spot.security.Signature;
import com.sun.spot.security.implementation.ECPublicKeyImpl;
import com.sun.spot.security.implementation.RSAPublicKey;
import com.sun.spotx.crypto.Cipher;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;
import javacard.security.Key;
import javacard.security.PublicKey;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javax.microedition.pki.Certificate;
import javax.microedition.pki.CertificateException;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class X509Certificate
implements Certificate {
    public static final byte NO_ERROR = 0;
    public static final int MISSING_PATH_LENGTH_CONSTRAINT = -1;
    public static final int UNLIMITED_CERT_CHAIN_LENGTH = 65535;
    private static final int MAX_NAME_LENGTH = 300;
    private static final byte ANY_STRING_TYPE = 0;
    private static final byte INTEGER_TYPE = 2;
    private static final byte BITSTRING_TYPE = 3;
    private static final byte OCTETSTR_TYPE = 4;
    private static final byte OID_TYPE = 6;
    private static final byte UTF8STR_TYPE = 12;
    private static final byte UNIVSTR_TYPE = 18;
    private static final byte PRINTSTR_TYPE = 19;
    private static final byte TELETEXSTR_TYPE = 20;
    private static final byte IA5STR_TYPE = 22;
    private static final byte SEQUENCE_TYPE = 48;
    private static final byte SET_TYPE = 49;
    public static final byte TYPE_EMAIL_ADDRESS = 1;
    public static final byte TYPE_DNS_NAME = 2;
    public static final byte TYPE_URI = 6;
    public static final int DIGITAL_SIG_KEY_USAGE = 1;
    public static final int NON_REPUDIATION_KEY_USAGE = 2;
    public static final int KEY_ENCIPHER_KEY_USAGE = 4;
    public static final int DATA_ENCIPHER_KEY_USAGE = 8;
    public static final int KEY_AGREEMENT_KEY_USAGE = 16;
    public static final int CERT_SIGN_KEY_USAGE = 32;
    public static final int CRL_SIGN_KEY_USAGE = 64;
    public static final int ENCIPHER_ONLY_KEY_USAGE = 128;
    public static final int DECIPHER_ONLY_KEY_USAGE = 256;
    public static final int SERVER_AUTH_EXT_KEY_USAGE = 2;
    public static final int CLIENT_AUTH_EXT_KEY_USAGE = 4;
    public static final int CODE_SIGN_EXT_KEY_USAGE = 8;
    public static final int EMAIL_EXT_KEY_USAGE = 16;
    public static final int IPSEC_END_SYS_EXT_KEY_USAGE = 32;
    public static final int IPSEC_TUNNEL_EXT_KEY_USAGE = 64;
    public static final int IPSEC_USER_EXT_KEY_USAGE = 128;
    public static final int TIME_STAMP_EXT_KEY_USAGE = 256;
    private static final int UTC_LENGTH = 13;
    private static final char[][] nameAttr = new char[][]{{'\u0000'}, {'\u0000'}, {'\u0000'}, {'C', 'N'}, {'S', 'N'}, {'\u0000'}, {'C'}, {'L'}, {'S', 'T'}, {'S', 'T', 'R', 'E', 'E', 'T'}, {'O'}, {'O', 'U'}};
    private static final char[] EMAIL_ATTR_LABEL = new char[]{'E', 'm', 'a', 'i', 'l', 'A', 'd', 'd', 'r', 'e', 's', 's'};
    private static final byte[] EMAIL_ATTR_OID = new byte[]{42, -122, 72, -122, -9, 13, 1, 9, 1};
    private static final byte[] PKCS1Seq = new byte[]{48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1};
    private static final byte[] ECDSAwithSHA1Seq = new byte[]{48, 9, 6, 7, 42, -122, 72, -50, 61, 4, 1};
    private static final byte[] PKCS1OID = new byte[]{42, -122, 72, -122, -9, 13, 1, 1};
    private static final byte[] ECDSAwithSHA1OID = new byte[]{42, -122, 72, -50, 61, 4, 1};
    private static final byte[] ECpublicKeyOID = new byte[]{42, -122, 72, -50, 61, 2, 1};
    private static final byte[] SECGOID = new byte[]{43, -127, 4, 0};
    private static final byte[] ANSIX962GFpOID = new byte[]{42, -122, 72, -50, 61, 3, 1};
    private static final byte NONE = -1;
    private static final byte RSA_ENCRYPTION = 1;
    private static final byte MD2_RSA = 2;
    private static final byte MD4_RSA = 3;
    private static final byte MD5_RSA = 4;
    private static final byte SHA1_RSA = 5;
    private static final byte EC_PUBLIC_KEY = 16;
    private static final byte ECDSA_WITH_SHA1 = 17;
    private static final byte[] PREFIX_MD2 = new byte[]{48, 32, 48, 12, 6, 8, 42, -122, 72, -122, -9, 13, 2, 2, 5, 0, 4, 16};
    private static final byte[] PREFIX_MD5 = new byte[]{48, 32, 48, 12, 6, 8, 42, -122, 72, -122, -9, 13, 2, 5, 5, 0, 4, 16};
    private static final byte[] PREFIX_SHA1 = new byte[]{48, 33, 48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0, 4, 20};
    private static final byte[] NullSeq = new byte[]{5, 0};
    private static final byte[] ValiditySeq = new byte[]{48, 30};
    private static final byte[] UTCSeq = new byte[]{23, 13};
    private static final byte[] ID_KP = new byte[]{43, 6, 1, 5, 5, 7, 3};
    private boolean selfSigned = false;
    private byte version = 1;
    private byte[] fp = null;
    private String serialNumber;
    private String subject;
    private String issuer;
    private long from = 0L;
    private long until = 0L;
    private PublicKey pubKey = null;
    private int issuerStart;
    private int issuerEnd;
    private int subjectStart;
    private int subjectEnd;
    private int idx = 0;
    private byte[] enc = null;
    private int TBSStart = 0;
    private int TBSLen = 0;
    private byte sigAlg = (byte)-1;
    private byte[] signature = null;
    private byte[] TBSCertHash = null;
    private byte[] TBSCertBytes = null;
    private boolean badExt = false;
    private byte subAltNameType;
    private Object subAltName;
    private boolean hasBC = false;
    private boolean isCA = false;
    private int pLenConstr = -1;
    private int keyUsage = -1;
    private int extKeyUsage = -1;
    private static final String[] KEY_USAGE;

    private X509Certificate() {
    }

    public X509Certificate(byte ver, byte[] rawSerialNumber, String sub, String iss, long notBefore, long notAfter, byte[] mod, byte[] exp, byte[] chash, int pLen) throws Exception {
        RSAPublicKey pKey = new RSAPublicKey(mod, exp);
        new X509Certificate(ver, rawSerialNumber, sub, iss, notBefore, notAfter, (PublicKey)pKey, chash, pLen);
    }

    public X509Certificate(byte ver, byte[] rawSerialNumber, String sub, String iss, long notBefore, long notAfter, PublicKey publicKey, byte[] chash, int pLen) {
        this.version = ver;
        this.serialNumber = Utils.hexEncode(rawSerialNumber, 0, rawSerialNumber.length);
        if (chash != null) {
            this.fp = new byte[chash.length];
            System.arraycopy(chash, 0, this.fp, 0, chash.length);
        }
        this.subject = new String(sub);
        this.issuer = new String(iss);
        this.from = notBefore;
        this.until = notAfter;
        this.sigAlg = (byte)-1;
        if (this.subject.compareTo(this.issuer) == 0) {
            this.selfSigned = true;
        }
        this.pubKey = publicKey;
        if (ver == 3 && pLen != -1) {
            this.isCA = true;
            this.hasBC = true;
            this.pLenConstr = pLen;
        }
    }

    private void match(byte[] buf) throws Exception {
        if (this.idx + buf.length < this.enc.length) {
            for (byte element : buf) {
                if (this.enc[this.idx++] == element) continue;
                throw new Exception("match() error 1");
            }
        } else {
            throw new Exception("match() error 2");
        }
    }

    private int getLen(byte type) throws IOException {
        if (this.enc[this.idx] == type || type == 0 && (this.enc[this.idx] == 19 || this.enc[this.idx] == 20 || this.enc[this.idx] == 12 || this.enc[this.idx] == 22 || this.enc[this.idx] == 18)) {
            int size;
            ++this.idx;
            if ((size = this.enc[this.idx++] & 0xFF) >= 128) {
                int tmp = size - 128;
                if (tmp > 2 || this.idx + tmp > this.enc.length) {
                    throw new IOException("getLen() err 1");
                }
                size = 0;
                while (tmp > 0) {
                    size = (size << 8) + (this.enc[this.idx++] & 0xFF);
                    --tmp;
                }
            }
            return size;
        }
        throw new IOException("getLen() err 2");
    }

    private byte getSigAlg() throws IOException {
        int len = 0;
        byte val = -1;
        try {
            len = this.getLen((byte)48);
            len = this.getLen((byte)6);
            int idxSaved = this.idx;
            if (len == ECDSAwithSHA1OID.length) {
                this.match(ECDSAwithSHA1OID);
                return 17;
            }
            this.idx = idxSaved;
            if (len == PKCS1OID.length + 1) {
                this.match(PKCS1OID);
                val = this.enc[this.idx++];
                this.match(NullSeq);
                return val;
            }
        }
        catch (Exception e) {
            throw new IOException("Algorithm Id parsing failed");
        }
        return -1;
    }

    private String getName(int end) throws IOException {
        byte[] name = new byte[300];
        int nameLen = 0;
        int len = 0;
        char[] label = null;
        while (this.idx < end) {
            int aidx;
            if (nameLen != 0) {
                name[nameLen++] = 59;
            }
            this.getLen((byte)49);
            this.getLen((byte)48);
            int clen = this.getLen((byte)6);
            int cidx = this.idx;
            this.idx += clen;
            label = clen == 3 && this.enc[cidx] == 85 && this.enc[cidx + 1] == 4 ? ((aidx = this.enc[cidx + 2] & 0xFF) < nameAttr.length && nameAttr[aidx][0] != '\u0000' ? nameAttr[aidx] : Utils.hexEncodeToChars(this.enc, cidx, clen)) : (Utils.byteMatch(this.enc, cidx, EMAIL_ATTR_OID, 0, EMAIL_ATTR_OID.length) ? EMAIL_ATTR_LABEL : Utils.hexEncodeToChars(this.enc, cidx, clen));
            for (char element : label) {
                name[nameLen++] = (byte)element;
            }
            name[nameLen++] = 61;
            len = this.getLen((byte)0);
            if (len <= 0) continue;
            for (int i = 0; i < len; ++i) {
                name[nameLen++] = this.enc[this.idx++];
            }
        }
        return new String(name, 0, nameLen);
    }

    private static long getUTCTime(byte[] buf, int off) throws IOException {
        int[] period = new int[6];
        if (buf[off + 13 - 1] != 90) {
            throw new IOException("getUTCTime() err 1");
        }
        for (int i = 0; i < 6; ++i) {
            period[i] = 0;
            if (buf[2 * i + off] < 48 || buf[2 * i + off] > 57) {
                throw new IOException("getUTCTime() err 2");
            }
            period[i] = buf[2 * i + off] - 48;
            if (buf[2 * i + off + 1] < 48 || buf[2 * i + off + 1] > 57) {
                throw new IOException("getUTCTime() err 3");
            }
            period[i] = period[i] * 10 + buf[2 * i + off + 1] - 48;
        }
        period[0] = period[0] < 50 ? period[0] + 2000 : period[0] + 1900;
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.set(1, period[0]);
        cal.set(2, period[1] - 1);
        cal.set(5, period[2]);
        cal.set(11, period[3]);
        cal.set(12, period[4]);
        cal.set(13, period[5]);
        cal.set(14, 0);
        return cal.getTime().getTime();
    }

    private void parseExtensions(int end) throws IOException {
        String extId = null;
        int extIdIdx = 0;
        int extIdLen = 0;
        int extValIdx = 0;
        int extValLen = 0;
        this.getLen((byte)-93);
        this.getLen((byte)48);
        while (this.idx < end) {
            extId = null;
            this.getLen((byte)48);
            extIdLen = this.getLen((byte)6);
            extIdIdx = this.idx;
            this.idx += extIdLen;
            boolean crit = false;
            if (this.enc[this.idx] == 1 && this.enc[this.idx + 1] == 1) {
                this.idx += 2;
                crit = this.enc[this.idx++] == -1;
            }
            extValLen = this.getLen((byte)4);
            extValIdx = this.idx;
            if (this.enc[extIdIdx] == 85 && this.enc[extIdIdx + 1] == 29) {
                block0 : switch (this.enc[extIdIdx + 2] & 0xFF) {
                    case 15: {
                        extId = "KU";
                        if (this.keyUsage == -1) {
                            this.keyUsage = 0;
                        }
                        int tmp = this.getLen((byte)3) - 1;
                        byte unused = this.enc[this.idx++];
                        int b = 0;
                        for (int i = 0; i < (tmp << 3) - unused; ++i) {
                            if (i % 8 == 0) {
                                b = this.enc[this.idx++];
                            }
                            if (b < 0) {
                                this.keyUsage |= 1 << i;
                            }
                            b = (byte)(b << 1);
                        }
                        break;
                    }
                    case 17: {
                        int i;
                        StringBuffer temp = new StringBuffer();
                        int start = this.idx + 4;
                        int length = extValLen - 4;
                        extId = "SAN";
                        this.subAltNameType = (byte)(this.enc[this.idx + 2] - 128);
                        switch (this.subAltNameType) {
                            case 1: 
                            case 2: 
                            case 6: {
                                for (i = 0; i < length; ++i) {
                                    temp.append((char)this.enc[start + i]);
                                }
                                this.subAltName = temp.toString();
                                break block0;
                            }
                        }
                        this.subAltName = new byte[length];
                        for (i = 0; i < length; ++i) {
                            ((byte[])this.subAltName)[i] = this.enc[start + i];
                        }
                        break;
                    }
                    case 19: {
                        int i;
                        this.hasBC = true;
                        extId = "BC";
                        int tmp = this.getLen((byte)48);
                        if (tmp == 0) break;
                        if (this.enc[this.idx] == 1 && this.enc[this.idx + 1] == 1 && this.enc[this.idx + 2] == -1) {
                            this.isCA = true;
                            this.idx += 3;
                        }
                        if (this.enc[this.idx] == 2 && this.enc[this.idx + 1] != 0) {
                            tmp = this.getLen((byte)2);
                            this.pLenConstr = 0;
                            for (i = 0; i < tmp; ++i) {
                                this.pLenConstr = (this.pLenConstr << 16) + this.enc[this.idx + i];
                            }
                            this.idx += tmp;
                            break;
                        }
                        if (!this.isCA) break;
                        this.pLenConstr = 65535;
                        break;
                    }
                    case 37: {
                        extId = "EKU";
                        if (this.extKeyUsage == -1) {
                            this.extKeyUsage = 0;
                        }
                        this.getLen((byte)48);
                        while (this.idx < extValIdx + extValLen) {
                            int kuOidLen = this.getLen((byte)6);
                            if (kuOidLen == ID_KP.length + 1 && Utils.byteMatch(this.enc, this.idx, ID_KP, 0, ID_KP.length) && this.enc[this.idx + ID_KP.length] > 0 && this.enc[this.idx + ID_KP.length] < 9) {
                                this.extKeyUsage |= 1 << this.enc[this.idx + ID_KP.length];
                            } else if (crit) {
                                this.badExt = true;
                            }
                            this.idx += kuOidLen;
                        }
                        if (crit) break;
                        this.extKeyUsage = -1;
                    }
                }
            }
            if (extId == null && crit) {
                this.badExt = true;
            }
            this.idx = extValIdx + extValLen;
        }
        if (this.idx != end) {
            throw new IOException("Extension parsing problem");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PublicKey parsePublicKey() throws Exception {
        int id;
        int curveType = -1;
        int size = this.getLen((byte)48);
        size = this.getLen((byte)6);
        if (size == PKCS1OID.length + 1) {
            this.match(PKCS1OID);
            id = this.enc[this.idx++];
            this.match(NullSeq);
        } else {
            this.match(ECpublicKeyOID);
            id = 16;
            size = this.getLen((byte)6);
            if (size == SECGOID.length + 1) {
                this.match(SECGOID);
                if (this.enc[this.idx++] != 8) throw new IOException("Unsupported SECG curve");
                curveType = 0;
            } else if (size == ANSIX962GFpOID.length + 1) {
                this.match(ANSIX962GFpOID);
                throw new IOException("Unsupported ANSI X9.62 GFp curve");
            }
        }
        switch (id) {
            case 1: {
                this.getLen((byte)3);
                if (this.enc[this.idx++] != 0) {
                    throw new IOException("Bitstring error while parsing public key information");
                }
                this.getLen((byte)48);
                size = this.getLen((byte)2);
                if (this.enc[this.idx] == 0) {
                    --size;
                    ++this.idx;
                }
                int modulusPos = this.idx;
                int modulusLen = size;
                this.idx += size;
                size = this.getLen((byte)2);
                if (this.enc[this.idx] == 0) {
                    --size;
                    ++this.idx;
                }
                int exponentPos = this.idx;
                int exponentLen = size;
                this.pubKey = new RSAPublicKey(this.enc, modulusPos, modulusLen, this.enc, exponentPos, exponentLen);
                this.idx += size;
                return this.pubKey;
            }
            case 16: {
                size = this.getLen((byte)3);
                if (this.enc[this.idx] == 0) {
                    --size;
                    ++this.idx;
                }
                this.pubKey = new ECPublicKeyImpl(curveType);
                ((ECPublicKeyImpl)this.pubKey).setW(this.enc, this.idx, size);
                this.idx += size;
                return this.pubKey;
            }
            default: {
                this.pubKey = null;
            }
        }
        return this.pubKey;
    }

    public static X509Certificate generateCertificate(byte[] buf, int off, int len) throws IOException {
        int test = buf[off] + buf[len - 1] + buf[off + len - 1];
        try {
            int start = 0;
            int size = 0;
            byte[] hash = new byte[16];
            X509Certificate res = null;
            MessageDigest md = MessageDigest.getInstance((String)"MD5");
            md.update(buf, off, len);
            md.digest(hash, 0, hash.length);
            res = new X509Certificate();
            res.idx = 0;
            res.enc = new byte[len];
            System.arraycopy(buf, off, res.enc, 0, len);
            res.fp = new byte[hash.length];
            System.arraycopy(hash, 0, res.fp, 0, hash.length);
            res.getLen((byte)48);
            res.TBSStart = res.idx;
            size = res.getLen((byte)48);
            int sigAlgIdx = res.idx + size;
            res.TBSLen = sigAlgIdx - res.TBSStart;
            res.TBSCertBytes = new byte[res.TBSLen];
            System.arraycopy(buf, off + res.TBSStart, res.TBSCertBytes, 0, res.TBSLen);
            if ((res.enc[res.idx] & 0xF0) == 160) {
                ++res.idx;
                if (res.idx + (size = res.enc[res.idx++] & 0xFF) > res.enc.length) {
                    throw new IOException("Version info too long");
                }
                res.version = (byte)(res.enc[res.idx + size - 1] + 1);
                res.idx += size;
            } else {
                res.version = 1;
            }
            size = res.getLen((byte)2);
            res.serialNumber = Utils.hexEncode(res.enc, res.idx, size);
            res.idx += size;
            byte id = res.getSigAlg();
            start = res.idx;
            res.issuerStart = res.idx;
            size = res.getLen((byte)48);
            int end = res.idx + size;
            try {
                res.issuerEnd = end;
                res.issuer = res.getName(end);
            }
            catch (Exception e) {
                throw new IOException("Could not parse issuer name");
            }
            try {
                res.match(ValiditySeq);
                res.match(UTCSeq);
                res.from = X509Certificate.getUTCTime(res.enc, res.idx);
                res.idx += 13;
                res.match(UTCSeq);
                res.until = X509Certificate.getUTCTime(res.enc, res.idx);
                res.idx += 13;
            }
            catch (Exception e) {
                throw new IOException("Could not parse validity informationcaught " + e);
            }
            start = res.idx;
            res.subjectStart = res.idx;
            size = res.getLen((byte)48);
            end = res.idx + size;
            if (size != 0) {
                try {
                    res.subjectEnd = end;
                    res.subject = res.getName(end);
                }
                catch (Exception e) {
                    throw new IOException("Could not parse subject name");
                }
            }
            int publicKeyLen = res.getLen((byte)48);
            int publicKeyPos = res.idx;
            try {
                res.pubKey = res.parsePublicKey();
            }
            catch (Exception e) {
                throw new IOException("PublicKey parsing error " + e);
            }
            res.idx = publicKeyPos + publicKeyLen;
            if (res.idx != sigAlgIdx) {
                if (res.version < 3) {
                    throw new IOException("Unexpected extensions in old version cert");
                }
                res.parseExtensions(sigAlgIdx);
            }
            res.sigAlg = res.getSigAlg();
            md = null;
            if (res.sigAlg != 2) {
                if (res.sigAlg == 4) {
                    md = MessageDigest.getInstance((String)"MD5");
                } else if (res.sigAlg == 5 || res.sigAlg == 17) {
                    md = MessageDigest.getInstance((String)"SHA");
                }
            }
            if (md != null) {
                res.TBSCertHash = new byte[md.getDigestLength()];
                md.update(buf, off + res.TBSStart, res.TBSLen);
                md.digest(res.TBSCertHash, 0, res.TBSCertHash.length);
            }
            size = res.getLen((byte)3);
            if (res.enc[res.idx++] != 0) {
                throw new IOException("Bitstring error in signature parsing");
            }
            int sigLen = size - 1 + 7 >>> 3 << 3;
            if (res.sigAlg == 17) {
                sigLen = size - 1;
            }
            res.signature = new byte[sigLen];
            System.arraycopy(res.enc, res.idx, res.signature, sigLen - (size - 1), size - 1);
            return res;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IOException("Bad length detected in cert DER");
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e.toString());
        }
    }

    public static void verifyChain(Vector<X509Certificate> certs, int keyUsage, int extKeyUsage, X509Certificate[] caCerts) throws CertificateException {
        Vector<X509Certificate> trustedCerts = null;
        int maxPathLen = -1;
        Vector<String> subjectNames = new Vector<String>();
        X509Certificate cert = certs.elementAt(0);
        X509Certificate.checkKeyUsageAndValidity(cert, keyUsage, extKeyUsage);
        int i = 1;
        while (true) {
            if (caCerts != null && (trustedCerts = X509Certificate.getCertificates(cert.getIssuer(), caCerts)) != null) {
                if (trustedCerts.elementAt(0).getSubject() == cert.getSubject()) break;
                subjectNames.addElement(trustedCerts.elementAt(0).getSubject());
                break;
            }
            if (i >= certs.size()) {
                if (caCerts != null) {
                    throw new CertificateException(cert, 8);
                }
                return;
            }
            subjectNames.addElement(cert.getSubject());
            X509Certificate prevCert = cert;
            cert = certs.elementAt(i);
            X509Certificate.checkKeyUsageAndValidity(cert, 32, extKeyUsage);
            if (prevCert.getIssuer().compareTo(cert.getSubject()) != 0) {
                throw new CertificateException(prevCert, 11);
            }
            int prevMaxPathLen = maxPathLen;
            maxPathLen = cert.getBasicConstraints();
            if (maxPathLen != 65535 && maxPathLen <= prevMaxPathLen) {
                if (cert.getSubject().equals(cert.getIssuer())) {
                    throw new CertificateException(prevCert, 8);
                }
                if (maxPathLen == -1) {
                    throw new CertificateException(cert, 4);
                }
                throw new CertificateException(cert, 2);
            }
            prevCert.verify(cert.getPublicKey());
            ++i;
        }
        for (X509Certificate element : trustedCerts) {
            try {
                cert.verify(element.getPublicKey());
            }
            catch (CertificateException ce) {
                continue;
            }
            try {
                element.checkValidity();
            }
            catch (CertificateException ce) {
                if (ce.getReason() == 3) {
                    throw new CertificateException(element, 12);
                }
                throw ce;
            }
            return;
        }
        throw new CertificateException(cert, 14);
    }

    private static Vector<X509Certificate> getCertificates(String subjectName, X509Certificate[] caCerts) {
        Vector<X509Certificate> v = new Vector<X509Certificate>();
        for (int i = 0; i < caCerts.length; ++i) {
            if (!subjectName.equals(caCerts[i].getSubject())) continue;
            v.addElement(caCerts[i]);
        }
        if (v.size() == 0) {
            return null;
        }
        return v;
    }

    public static void checkKeyUsageAndValidity(X509Certificate cert, int keyUsage, int extKeyUsage) throws CertificateException {
        cert.checkExtensions();
        int certKeyUsage = cert.getKeyUsage();
        if (keyUsage != -1 && certKeyUsage != -1 && (certKeyUsage & keyUsage) != keyUsage) {
            throw new CertificateException(cert, 10);
        }
        certKeyUsage = cert.getExtKeyUsage();
        if (extKeyUsage != -1 && certKeyUsage != -1 && (certKeyUsage & extKeyUsage) != extKeyUsage) {
            throw new CertificateException(cert, 10);
        }
        cert.checkValidity();
    }

    public byte[] getFingerprint() {
        byte[] res = new byte[16];
        if (this.fp != null) {
            System.arraycopy(this.fp, 0, res, 0, res.length);
        }
        return res;
    }

    @Override
    public String getIssuer() {
        return this.issuer;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public long getNotBefore() {
        return this.from;
    }

    @Override
    public long getNotAfter() {
        return this.until;
    }

    public void checkExtensions() throws CertificateException {
        if (this.badExt) {
            throw new CertificateException(this, 1);
        }
    }

    public void checkValidity() throws CertificateException {
        this.checkValidity(System.currentTimeMillis());
    }

    public void checkValidity(long time) throws CertificateException {
        if (time < this.from) {
            throw new CertificateException(this, 6);
        }
        if (time > this.until) {
            throw new CertificateException(this, 3);
        }
    }

    @Override
    public String getType() {
        return "X.509";
    }

    public PublicKey getPublicKey() throws CertificateException {
        if (this.pubKey == null) {
            throw new CertificateException(this, 13);
        }
        return this.pubKey;
    }

    @Override
    public String getVersion() {
        return Integer.toString(this.version);
    }

    public int getBasicConstraints() {
        if (this.isCA) {
            return this.pLenConstr;
        }
        return -1;
    }

    public int getKeyUsage() {
        return this.keyUsage;
    }

    public int getExtKeyUsage() {
        return this.extKeyUsage;
    }

    public int getSubjectAltNameType() {
        return this.subAltNameType;
    }

    public Object getSubjectAltName() {
        return this.subAltName;
    }

    @Override
    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void verify(PublicKey k) throws CertificateException {
        if (k instanceof RSAPublicKey) {
            this.verifyRSA((RSAPublicKey)k);
        } else if (k instanceof ECPublicKeyImpl) {
            if (this.sigAlg != 17) {
                throw new CertificateException("Issuer uses unsupportedsignature algorithm", this, 14);
            }
            boolean validated = false;
            try {
                Signature sig = Signature.getInstance((String)"SHA1WITHECDSA");
                sig.initVerify(k);
                sig.update(this.TBSCertBytes, 0, this.TBSCertBytes.length);
                validated = sig.verify(this.signature, 0, this.signature.length);
            }
            catch (Exception ex) {
                System.out.println("Caught " + ex + " in verify.");
            }
            if (!validated) {
                throw new CertificateException("Signature verification failed", this, 14);
            }
        } else {
            throw new CertificateException("Issuer uses unsupported key type", this, 14);
        }
    }

    private void verifyRSA(RSAPublicKey pk) throws CertificateException {
        int val;
        if (this.selfSigned) {
            if (this.pubKey.equals(pk)) {
                return;
            }
            throw new CertificateException("Bad self signed cert", this, 14);
        }
        if (this.signature == null) {
            throw new CertificateException(this, 5);
        }
        if (this.TBSCertHash == null) {
            throw new CertificateException(this, 9);
        }
        int modLen = pk.getModulusLen();
        byte[] result = new byte[modLen];
        try {
            Cipher rsa = Cipher.getInstance((String)"RSA");
            rsa.init(2, (Key)pk);
            val = rsa.doFinal(this.signature, 0, this.signature.length, result, 0);
        }
        catch (Exception e) {
            throw new CertificateException(this, 14);
        }
        if (this.sigAlg == 2 && val == PREFIX_MD2.length + this.TBSCertHash.length && Utils.byteMatch(result, 0, PREFIX_MD2, 0, PREFIX_MD2.length) && Utils.byteMatch(result, PREFIX_MD2.length, this.TBSCertHash, 0, this.TBSCertHash.length)) {
            return;
        }
        if (this.sigAlg == 4 && val == PREFIX_MD5.length + this.TBSCertHash.length && Utils.byteMatch(result, 0, PREFIX_MD5, 0, PREFIX_MD5.length) && Utils.byteMatch(result, PREFIX_MD5.length, this.TBSCertHash, 0, this.TBSCertHash.length)) {
            return;
        }
        if (this.sigAlg == 5 && val == PREFIX_SHA1.length + this.TBSCertHash.length && Utils.byteMatch(result, 0, PREFIX_SHA1, 0, PREFIX_SHA1.length) && Utils.byteMatch(result, PREFIX_SHA1.length, this.TBSCertHash, 0, this.TBSCertHash.length)) {
            return;
        }
        throw new CertificateException(this, 14);
    }

    @Override
    public String getSigAlgName() {
        if (this.sigAlg == 4) {
            return "MD5withRSA";
        }
        if (this.sigAlg == 2) {
            return "MD2withRSA";
        }
        if (this.sigAlg == 5) {
            return "SHA1withRSA";
        }
        if (this.sigAlg == -1) {
            return "None";
        }
        if (this.sigAlg == 3) {
            return "MD4withRSA";
        }
        if (this.sigAlg == 17) {
            return "ECDSAwithSHA1";
        }
        return "Unknown (" + this.sigAlg + ")";
    }

    private static String date2str(Date date) {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        c.setTime(date);
        String d = c.get(2) + 1 + "/" + c.get(5) + "/" + c.get(1) + " " + c.get(11) + ":" + c.get(12) + ":" + c.get(13);
        return d;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer();
        tmp.append("[Type: ");
        tmp.append(this.getType());
        tmp.append("v");
        tmp.append(this.version);
        tmp.append("\n");
        tmp.append("Serial number: ");
        tmp.append(this.serialNumber);
        tmp.append("\n");
        tmp.append("Issuer: ");
        tmp.append(this.issuer);
        tmp.append("\n");
        tmp.append("Subject: ");
        tmp.append(this.subject);
        tmp.append("\n");
        tmp.append("Valid from ");
        tmp.append(X509Certificate.date2str(new Date(this.getNotBefore())));
        tmp.append(" GMT until ");
        tmp.append(X509Certificate.date2str(new Date(this.getNotAfter())));
        tmp.append(" GMT");
        tmp.append("\n");
        tmp.append(this.pubKey.toString());
        tmp.append("\n");
        tmp.append("Signature Algorithm: ");
        tmp.append(this.getSigAlgName());
        if (this.subAltName != null) {
            tmp.append("\n");
            tmp.append("SubjectAltName: ");
            if (this.subAltName instanceof String) {
                tmp.append(this.subAltName);
            } else if (this.subAltName instanceof byte[]) {
                tmp.append(" " + Utils.hexEncode((byte[])this.subAltName) + " ");
                tmp.append(" " + new String((byte[])this.subAltName) + " ");
            }
            tmp.append(" (type ");
            tmp.append(this.subAltNameType);
            tmp.append(")");
        }
        if (this.keyUsage != -1) {
            tmp.append("\n");
            tmp.append("KeyUsage:");
            int t = this.keyUsage;
            for (String element : KEY_USAGE) {
                if ((t & 1) == 1) {
                    tmp.append(" ");
                    tmp.append(element);
                }
                t >>>= 1;
            }
        }
        if (this.hasBC) {
            tmp.append("\n");
            tmp.append("BasicConstraints: ");
            tmp.append(this.isCA ? "is a CA" : "not a CA");
            tmp.append(" (pathLengthConstraint ");
            if (this.pLenConstr == -1 || this.pLenConstr == 65535) {
                tmp.append("absent");
            } else {
                tmp.append(this.pLenConstr);
            }
            tmp.append(")");
        }
        if (this.signature != null) {
            tmp.append("\n");
            tmp.append("Signature: ");
            tmp.append(Utils.hexEncode(this.signature));
        }
        tmp.append("\n");
        tmp.append("]");
        return tmp.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.issuer == null ? 0 : this.issuer.hashCode());
        result = 31 * result + (this.serialNumber == null ? 0 : this.serialNumber.hashCode());
        result = 31 * result + (this.subject == null ? 0 : this.subject.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof X509Certificate)) {
            return false;
        }
        X509Certificate other = (X509Certificate)obj;
        if (this.issuer == null ? other.issuer != null : !this.issuer.equals(other.issuer)) {
            return false;
        }
        if (this.serialNumber == null ? other.serialNumber != null : !this.serialNumber.equals(other.serialNumber)) {
            return false;
        }
        return !(this.subject == null ? other.subject != null : !this.subject.equals(other.subject));
    }

    public byte[] getEncoding() {
        return this.enc;
    }

    public byte[] getIssuerAsASN() {
        int len = this.issuerEnd - this.issuerStart;
        byte[] issuerAsASN = new byte[len];
        for (int i = 0; i < len; ++i) {
            issuerAsASN[i] = this.enc[this.issuerStart + i];
        }
        return issuerAsASN;
    }

    public int getSubjectLength() {
        return this.subjectEnd - this.subjectStart;
    }

    public byte[] getSubjectAsASN() {
        int len = this.subjectEnd - this.subjectStart;
        byte[] subjectAsASN = new byte[len];
        for (int i = 0; i < len; ++i) {
            subjectAsASN[i] = this.enc[this.subjectStart + i];
        }
        return subjectAsASN;
    }

    static {
        NativeMethods.setGloballyAccessible(ECDSAwithSHA1OID);
        NativeMethods.setGloballyAccessible(ID_KP);
        NativeMethods.setGloballyAccessible(UTCSeq);
        NativeMethods.setGloballyAccessible(ValiditySeq);
        NativeMethods.setGloballyAccessible(NullSeq);
        NativeMethods.setGloballyAccessible(PREFIX_SHA1);
        NativeMethods.setGloballyAccessible(PREFIX_MD5);
        NativeMethods.setGloballyAccessible(nameAttr);
        for (int i = 0; i < nameAttr.length; ++i) {
            NativeMethods.setGloballyAccessible(nameAttr[i]);
        }
        NativeMethods.setGloballyAccessible(EMAIL_ATTR_LABEL);
        NativeMethods.setGloballyAccessible(EMAIL_ATTR_OID);
        NativeMethods.setGloballyAccessible(PKCS1Seq);
        NativeMethods.setGloballyAccessible(ECDSAwithSHA1Seq);
        NativeMethods.setGloballyAccessible(PKCS1OID);
        NativeMethods.setGloballyAccessible(ECpublicKeyOID);
        NativeMethods.setGloballyAccessible(SECGOID);
        NativeMethods.setGloballyAccessible(ANSIX962GFpOID);
        NativeMethods.setGloballyAccessible(PREFIX_MD2);
        KEY_USAGE = new String[]{"digitalSignature", "nonRepudiation", "keyEncipherment", "dataEncipherment", "keyAgreement", "keyCertSign", "cRLSign", "encipherOnly", "decipherOnly", "9", "10", "11", "12", "13", "14", "15", "16", "serverAuth", "clientAuth", "codeSigning", "emailProtection", "ipsecEndSystem", "ipsecTunnel", "ipsecUser", "timeStamping"};
    }
}

