/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.sun.javacard.impl.NativeMethods;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
public class PrintStream
extends OutputStream {
    private boolean trouble = false;
    private OutputStreamWriter charOut;
    private OutputStream byteOut;
    private boolean closing = false;

    public PrintStream(OutputStream out) {
        if (out == null) {
            throw new NullPointerException("Null output stream");
        }
        this.byteOut = out;
        this.charOut = new OutputStreamWriter(out);
    }

    private void ensureOpen() throws IOException {
        if (this.charOut == null) {
            throw new IOException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        PrintStream printStream = this;
        synchronized (printStream) {
            try {
                this.ensureOpen();
                this.charOut.flush();
            }
            catch (IOException x) {
                this.trouble = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        PrintStream printStream = this;
        synchronized (printStream) {
            if (!this.closing) {
                this.closing = true;
                try {
                    this.charOut.close();
                }
                catch (IOException x) {
                    this.trouble = true;
                }
                this.charOut = null;
                this.byteOut = null;
            }
        }
    }

    public boolean checkError() {
        if (this.charOut != null) {
            this.flush();
        }
        return this.trouble;
    }

    protected void setError() {
        this.trouble = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) {
        try {
            PrintStream printStream = this;
            synchronized (printStream) {
                this.ensureOpen();
                this.byteOut.write(b);
            }
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] buf, int off, int len) {
        if (buf != null) {
            NativeMethods.checkPreviousContextAccess(buf);
        }
        try {
            PrintStream printStream = this;
            synchronized (printStream) {
                this.ensureOpen();
                this.byteOut.write(buf, off, len);
            }
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(char[] buf) {
        try {
            PrintStream printStream = this;
            synchronized (printStream) {
                this.ensureOpen();
                this.charOut.write(buf);
            }
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(String s) {
        try {
            PrintStream printStream = this;
            synchronized (printStream) {
                this.ensureOpen();
                this.charOut.write(s);
            }
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newLine() {
        try {
            PrintStream printStream = this;
            synchronized (printStream) {
                this.ensureOpen();
                this.charOut.write(10);
            }
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    public void print(boolean b) {
        this.write(b ? "true" : "false");
    }

    public void print(char c) {
        this.write(String.valueOf(c));
    }

    public void print(int i) {
        this.write(String.valueOf(i));
    }

    public void print(long l) {
        this.write(String.valueOf(l));
    }

    public void print(char[] s) {
        if (s != null) {
            NativeMethods.checkPreviousContextAccess(s);
        }
        this.write(s);
    }

    public void print(String s) {
        if (s != null) {
            NativeMethods.checkPreviousContextAccess(s);
        }
        if (s == null) {
            s = "null";
        }
        this.write(s);
    }

    public void print(Object obj) {
        if (obj != null) {
            NativeMethods.checkPreviousContextAccess(obj);
        }
        this.write(String.valueOf(obj));
    }

    public void println() {
        this.newLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(boolean x) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char x) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(int x) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(long x) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char[] x) {
        if (x != null) {
            NativeMethods.checkPreviousContextAccess(x);
        }
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String x) {
        if (x != null) {
            NativeMethods.checkPreviousContextAccess(x);
        }
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object x) {
        if (x != null) {
            NativeMethods.checkPreviousContextAccess(x);
        }
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(x);
            this.newLine();
        }
    }
}

