/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.util.JCSystemAccessor;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Vector;
import javacardx.framework.JCSystem;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public abstract class ResourceBundle {
    protected ResourceBundle parent = null;
    private Locale locale = null;

    public final String getString(String key) {
        return (String)this.getObject(key);
    }

    public final String[] getStringArray(String key) {
        return (String[])this.getObject(key);
    }

    public final Object getObject(String key) {
        Object obj = this.handleGetObject(key);
        if (obj == null) {
            if (this.parent != null) {
                obj = this.parent.getObject(key);
            }
            if (obj == null) {
                throw new MissingResourceException("Can't find resource for bundle " + this.getClass().getName() + ", key " + key, this.getClass().getName(), key);
            }
        }
        return obj;
    }

    public Locale getLocale() {
        return this.locale;
    }

    protected void setParent(ResourceBundle parent) {
        this.parent = parent;
    }

    public static final ResourceBundle getBundle(String baseName) {
        return ResourceBundle.getBundle(baseName, Locale.getDefault());
    }

    public static ResourceBundle getBundle(String baseName, Locale locale) {
        if (baseName == null) {
            throw new NullPointerException("baseName is null");
        }
        if (locale == null) {
            throw new NullPointerException("locale is null");
        }
        StringBuffer sb = new StringBuffer();
        ResourceBundle result = null;
        for (Locale l : new Locale[]{locale, Locale.getDefault()}) {
            if (l == null) continue;
            String language = l.getLanguage();
            String country = l.getCountry();
            if (language != null && language.length() > 0) {
                if (country != null && country.length() > 0) {
                    try {
                        sb.setLength(0);
                        sb.append(baseName).append('_').append(language).append('_').append(country);
                        result = (ResourceBundle)ResourceBundle.forName(sb.toString()).newInstance();
                        result.locale = new Locale(language, country);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                try {
                    sb.setLength(0);
                    sb.append(baseName).append('_').append(language);
                    ResourceBundle bundle = (ResourceBundle)ResourceBundle.forName(sb.toString()).newInstance();
                    bundle.locale = new Locale(language);
                    if (result != null) {
                        result.setParent(bundle);
                    } else {
                        result = bundle;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (result != null) break;
        }
        try {
            ResourceBundle bundle = (ResourceBundle)ResourceBundle.forName(baseName).newInstance();
            if (result != null) {
                if (result.parent != null) {
                    result.parent.setParent(bundle);
                } else {
                    result.setParent(bundle);
                }
            } else {
                result = bundle;
            }
            bundle.locale = new Locale("");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (result == null) {
            throw new MissingResourceException("Can't find bundle for base name " + baseName + ", locale " + locale, baseName + "_" + locale, "");
        }
        return result;
    }

    protected abstract Object handleGetObject(String var1);

    public abstract Enumeration<String> getKeys();

    private static Class<?> forName(String className) throws ClassNotFoundException, SecurityException {
        Class<?> clazz = ResourceBundle.forName0(className, false);
        if (clazz == null) {
            if (NativeMethods.getCurrentContext() != 0) {
                String appURI = JCSystem.getURI();
                Vector<String> v = JCSystemAccessor.getJCSystemAccessor().getDynamicallyLoadedClassList(appURI);
                if (v == null || !v.contains(className)) {
                    throw new SecurityException("Class name " + className + " is not listed in dynamically-loaded-classes");
                }
            }
            clazz = ResourceBundle.forName0(className, true);
        }
        return clazz;
    }

    private static native Class<?> forName0(String var0, boolean var1) throws ClassNotFoundException, SecurityException;
}

