/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class StringTokenizer
implements Enumeration<Object> {
    private int currentPosition = 0;
    private int newPosition = -1;
    private int maxPosition;
    private String str;
    private String delimiters;
    private boolean retDelims;
    private boolean delimsChanged = false;

    public StringTokenizer(String str, String delim, boolean returnDelims) {
        this.str = str;
        this.maxPosition = str.length();
        this.delimiters = delim;
        this.retDelims = returnDelims;
    }

    public StringTokenizer(String str, String delim) {
        this(str, delim, false);
    }

    public StringTokenizer(String str) {
        this(str, " \t\n\r\f", false);
    }

    private int skipDelimiters(int startPos) {
        char c;
        int position;
        if (this.delimiters == null) {
            throw new NullPointerException();
        }
        for (position = startPos; !this.retDelims && position < this.maxPosition && this.delimiters.indexOf(c = this.str.charAt(position)) >= 0; ++position) {
        }
        return position;
    }

    private int scanToken(int startPos) {
        char c;
        int position;
        for (position = startPos; position < this.maxPosition && this.delimiters.indexOf(c = this.str.charAt(position)) < 0; ++position) {
        }
        if (this.retDelims && startPos == position && this.delimiters.indexOf(c = this.str.charAt(position)) >= 0) {
            ++position;
        }
        return position;
    }

    public boolean hasMoreTokens() {
        this.newPosition = this.skipDelimiters(this.currentPosition);
        return this.newPosition < this.maxPosition;
    }

    public String nextToken() {
        this.currentPosition = this.newPosition >= 0 && !this.delimsChanged ? this.newPosition : this.skipDelimiters(this.currentPosition);
        this.delimsChanged = false;
        this.newPosition = -1;
        if (this.currentPosition >= this.maxPosition) {
            throw new NoSuchElementException();
        }
        int start = this.currentPosition;
        this.currentPosition = this.scanToken(this.currentPosition);
        return this.str.substring(start, this.currentPosition);
    }

    public String nextToken(String delim) {
        this.delimiters = delim;
        this.delimsChanged = true;
        return this.nextToken();
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    @Override
    public Object nextElement() {
        return this.nextToken();
    }

    public int countTokens() {
        int count = 0;
        int currpos = this.currentPosition;
        while (currpos < this.maxPosition && (currpos = this.skipDelimiters(currpos)) < this.maxPosition) {
            currpos = this.scanToken(currpos);
            ++count;
        }
        return count;
    }
}

