/*
 * Decompiled with CFR 0.152.
 */
package javacard.security;

import com.sun.javacard.crypto.Cipher;
import com.sun.javacard.impl.JCCryptoAccessor;
import javacard.security.CryptoException;
import javacard.security.Key;
import javacard.security.MessageDigest;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public abstract class Signature {
    public static final String SERVICE_NAME = "signature";
    public static final byte ALG_DES_MAC4_NOPAD = 1;
    public static final byte ALG_DES_MAC8_NOPAD = 2;
    public static final byte ALG_DES_MAC4_ISO9797_M1 = 3;
    public static final byte ALG_DES_MAC8_ISO9797_M1 = 4;
    public static final byte ALG_DES_MAC4_ISO9797_M2 = 5;
    public static final byte ALG_DES_MAC8_ISO9797_M2 = 6;
    public static final byte ALG_DES_MAC4_PKCS5 = 7;
    public static final byte ALG_DES_MAC8_PKCS5 = 8;
    public static final byte ALG_RSA_SHA_ISO9796 = 9;
    public static final byte ALG_RSA_SHA_PKCS1 = 10;
    public static final byte ALG_RSA_MD5_PKCS1 = 11;
    public static final byte ALG_RSA_RIPEMD160_ISO9796 = 12;
    public static final byte ALG_RSA_RIPEMD160_PKCS1 = 13;
    public static final byte ALG_DSA_SHA = 14;
    public static final byte ALG_RSA_SHA_RFC2409 = 15;
    public static final byte ALG_RSA_MD5_RFC2409 = 16;
    public static final byte ALG_ECDSA_SHA = 17;
    public static final byte ALG_AES_MAC_128_NOPAD = 18;
    public static final byte ALG_DES_MAC4_ISO9797_1_M2_ALG3 = 19;
    public static final byte ALG_DES_MAC8_ISO9797_1_M2_ALG3 = 20;
    public static final byte ALG_RSA_SHA_PKCS1_PSS = 21;
    public static final byte ALG_RSA_MD5_PKCS1_PSS = 22;
    public static final byte ALG_RSA_RIPEMD160_PKCS1_PSS = 23;
    public static final byte ALG_HMAC_SHA1 = 24;
    public static final byte ALG_HMAC_SHA_256 = 25;
    public static final byte ALG_HMAC_SHA_384 = 26;
    public static final byte ALG_HMAC_SHA_512 = 27;
    public static final byte ALG_HMAC_MD5 = 28;
    public static final byte ALG_HMAC_RIPEMD160 = 29;
    public static final byte ALG_RSA_SHA_ISO9796_MR = 30;
    public static final byte ALG_RSA_RIPEMD160_ISO9796_MR = 31;
    public static final byte ALG_KOREAN_SEED_MAC_NOPAD = 32;
    public static final byte ALG_ECDSA_SHA_256 = 33;
    public static final byte ALG_ECDSA_SHA_384 = 34;
    public static final byte ALG_AES_MAC_192_NOPAD = 35;
    public static final byte ALG_AES_MAC_256_NOPAD = 36;
    public static final byte ALG_ECDSA_SHA_224 = 37;
    public static final byte ALG_ECDSA_SHA_512 = 38;
    public static final byte ALG_RSA_SHA_224_PKCS1 = 39;
    public static final byte ALG_RSA_SHA_256_PKCS1 = 40;
    public static final byte ALG_RSA_SHA_384_PKCS1 = 41;
    public static final byte ALG_RSA_SHA_512_PKCS1 = 42;
    public static final byte ALG_RSA_SHA_224_PKCS1_PSS = 43;
    public static final byte ALG_RSA_SHA_256_PKCS1_PSS = 44;
    public static final byte ALG_RSA_SHA_384_PKCS1_PSS = 45;
    public static final byte ALG_RSA_SHA_512_PKCS1_PSS = 46;
    public static final byte ALG_DES_MAC4_ISO9797_1_M1_ALG3 = 47;
    public static final byte ALG_DES_MAC8_ISO9797_1_M1_ALG3 = 48;
    public static final byte SIG_CIPHER_DES_MAC4 = 1;
    public static final byte SIG_CIPHER_DES_MAC8 = 2;
    public static final byte SIG_CIPHER_RSA = 3;
    public static final byte SIG_CIPHER_DSA = 4;
    public static final byte SIG_CIPHER_ECDSA = 5;
    public static final byte SIG_CIPHER_AES_MAC128 = 6;
    public static final byte SIG_CIPHER_HMAC = 7;
    public static final byte SIG_CIPHER_KOREAN_SEED_MAC = 8;
    public static final byte MODE_SIGN = 1;
    public static final byte MODE_VERIFY = 2;
    private static JCCryptoAccessor cryptoAccessorInstance = JCCryptoAccessor.getInstance();

    protected Signature() {
    }

    public static final Signature getInstance(byte algorithm, boolean externalAccess) throws CryptoException {
        Signature instance = null;
        switch (algorithm) {
            case 1: {
                instance = Signature.getInstance("DES_MAC4_NOPAD", externalAccess);
                break;
            }
            case 2: {
                instance = Signature.getInstance("DES_MAC8_NOPAD", externalAccess);
                break;
            }
            case 3: {
                instance = Signature.getInstance("DES_MAC4_ISO9797_M1", externalAccess);
                break;
            }
            case 4: {
                instance = Signature.getInstance("DES_MAC8_ISO9797_M1", externalAccess);
                break;
            }
            case 5: {
                instance = Signature.getInstance("DES_MAC4_ISO9797_M2", externalAccess);
                break;
            }
            case 6: {
                instance = Signature.getInstance("DES_MAC8_ISO9797_M2", externalAccess);
                break;
            }
            case 7: {
                instance = Signature.getInstance("DES_MAC4_PKCS5", externalAccess);
                break;
            }
            case 8: {
                instance = Signature.getInstance("DES_MAC8_PKCS5", externalAccess);
                break;
            }
            case 9: {
                instance = Signature.getInstance("RSA_SHA_ISO9796", externalAccess);
                break;
            }
            case 10: {
                instance = Signature.getInstance("RSA_SHA_PKCS1", externalAccess);
                break;
            }
            case 11: {
                instance = Signature.getInstance("RSA_MD5_PKCS1", externalAccess);
                break;
            }
            case 12: {
                instance = Signature.getInstance("RSA_RIPEMD160_ISO9796", externalAccess);
                break;
            }
            case 13: {
                instance = Signature.getInstance("RSA_RIPEMD160_PKCS1", externalAccess);
                break;
            }
            case 14: {
                instance = Signature.getInstance("DSA_SHA", externalAccess);
                break;
            }
            case 15: {
                instance = Signature.getInstance("RSA_SHA_RFC2409", externalAccess);
                break;
            }
            case 16: {
                instance = Signature.getInstance("RSA_MD5_RFC2409", externalAccess);
                break;
            }
            case 17: {
                instance = Signature.getInstance("ECDSA_SHA", externalAccess);
                break;
            }
            case 18: {
                instance = Signature.getInstance("AES_MAC_128_NOPAD", externalAccess);
                break;
            }
            case 19: {
                instance = Signature.getInstance("DES_MAC4_ISO9797_1_M2_ALG3", externalAccess);
                break;
            }
            case 20: {
                instance = Signature.getInstance("DES_MAC8_ISO9797_1_M2_ALG3", externalAccess);
                break;
            }
            case 21: {
                instance = Signature.getInstance("RSA_SHA_PKCS1_PSS", externalAccess);
                break;
            }
            case 22: {
                instance = Signature.getInstance("RSA_MD5_PKCS1_PSS", externalAccess);
                break;
            }
            case 23: {
                instance = Signature.getInstance("RSA_RIPEMD160_PKCS1_PSS", externalAccess);
                break;
            }
            case 24: {
                instance = Signature.getInstance("HMAC_SHA1", externalAccess);
                break;
            }
            case 25: {
                instance = Signature.getInstance("HMAC_SHA_256", externalAccess);
                break;
            }
            case 26: {
                instance = Signature.getInstance("HMAC_SHA_384", externalAccess);
                break;
            }
            case 27: {
                instance = Signature.getInstance("HMAC_SHA_512", externalAccess);
                break;
            }
            case 28: {
                instance = Signature.getInstance("HMAC_MD5", externalAccess);
                break;
            }
            case 29: {
                instance = Signature.getInstance("HMAC_RIPEMD160", externalAccess);
                break;
            }
            case 30: {
                instance = Signature.getInstance("RSA_SHA_ISO9796_MR", externalAccess);
                break;
            }
            case 31: {
                instance = Signature.getInstance("RSA_RIPEMD160_ISO9796_MR", externalAccess);
                break;
            }
            case 32: {
                instance = Signature.getInstance("KOREAN_SEED_MAC_NOPAD", externalAccess);
                break;
            }
            case 33: {
                instance = Signature.getInstance("ECDSA_SHA_256", externalAccess);
                break;
            }
            case 34: {
                instance = Signature.getInstance("ECDSA_SHA_384", externalAccess);
                break;
            }
            case 35: {
                instance = Signature.getInstance("AES_MAC_192_NOPAD", externalAccess);
                break;
            }
            case 36: {
                instance = Signature.getInstance("AES_MAC_256_NOPAD", externalAccess);
                break;
            }
            default: {
                CryptoException.throwIt((short)3);
            }
        }
        return instance;
    }

    public static final Signature getInstance(byte messageDigestAlgorithm, byte cipherAlgorithm, byte paddingAlgorithm, boolean externalAccess) throws CryptoException {
        String algName = Signature.convertCipherByteToString(cipherAlgorithm) + MessageDigest.convertAlgorithmByteToString(messageDigestAlgorithm, true) + Cipher.convertPaddingByteToStringSuffix((byte)paddingAlgorithm);
        return Signature.getInstance(algName, externalAccess);
    }

    public static final Signature getInstance(String algorithm, boolean externalAccess) throws CryptoException {
        if (algorithm == null) {
            throw new NullPointerException();
        }
        StringBuilder sb = new StringBuilder(SERVICE_NAME);
        sb.append(".");
        sb.append(algorithm);
        Object o = cryptoAccessorInstance.getAlgorithmImpl(sb.toString(), externalAccess);
        if (o == null) {
            CryptoException.throwIt((short)3);
        }
        return (Signature)o;
    }

    public static final Signature getInstance(String algorithm, String provider, boolean externalAccess) throws CryptoException {
        if (algorithm == null || provider == null) {
            throw new NullPointerException();
        }
        StringBuilder sb = new StringBuilder(SERVICE_NAME);
        sb.append(".");
        sb.append(algorithm);
        Object o = cryptoAccessorInstance.getAlgorithmImpl(sb.toString(), provider, externalAccess);
        if (o == null) {
            CryptoException.throwIt((short)3);
        }
        return (Signature)o;
    }

    public abstract void init(Key var1, byte var2) throws CryptoException;

    public abstract void init(Key var1, byte var2, byte[] var3, short var4, short var5) throws CryptoException;

    public abstract void setInitialDigest(byte[] var1, short var2, short var3, byte[] var4, short var5, short var6) throws CryptoException;

    public abstract byte getAlgorithm();

    public abstract String getAlgorithmName();

    public abstract short getLength() throws CryptoException;

    public abstract void update(byte[] var1, short var2, short var3) throws CryptoException;

    public abstract short sign(byte[] var1, short var2, short var3, byte[] var4, short var5) throws CryptoException;

    public abstract short signPreComputedHash(byte[] var1, short var2, short var3, byte[] var4, short var5) throws CryptoException;

    public abstract boolean verify(byte[] var1, short var2, short var3, byte[] var4, short var5, short var6) throws CryptoException;

    static String convertCipherByteToString(byte cipherAlgorithm) {
        switch (cipherAlgorithm) {
            case 1: {
                return "DES_MAC4";
            }
            case 2: {
                return "DES_MAC8";
            }
            case 4: {
                return "DSA";
            }
            case 5: {
                return "ECDSA";
            }
            case 6: {
                return "AES_MAC_128";
            }
            case 3: {
                return "RSA";
            }
        }
        return null;
    }
}

