/*
 * Decompiled with CFR 0.152.
 */
package javacardx.spi.security;

import java.security.AccessController;
import java.util.Hashtable;
import java.util.Vector;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javacardx.security.CryptoServicePermission;

@TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
public abstract class CryptoProvider {
    private static final Hashtable<String, CryptoProvider> PROVIDERS = new Hashtable();
    private static final Vector<String> PROVIDER_NAMES = new Vector();
    private static Vector<String> availableAlgorithms = null;
    private String name;
    private String[] algorithmNames;

    public static final String[] getProviders() {
        int size = PROVIDER_NAMES.size();
        if (size == 0) {
            return null;
        }
        String[] names = new String[size];
        CryptoProvider.copyStringVectorContentsIntoArray(PROVIDER_NAMES, names);
        return names;
    }

    public static final String[] getAlgorithms() {
        if (availableAlgorithms == null) {
            availableAlgorithms = new Vector();
            for (String p : PROVIDER_NAMES) {
                CryptoProvider provider = PROVIDERS.get(p);
                for (int i = 0; i < provider.algorithmNames.length; ++i) {
                    if (availableAlgorithms.contains(provider.algorithmNames[i])) continue;
                    availableAlgorithms.addElement(provider.algorithmNames[i]);
                }
            }
        }
        if (availableAlgorithms.size() == 0) {
            return null;
        }
        String[] s = new String[availableAlgorithms.size()];
        CryptoProvider.copyStringVectorContentsIntoArray(availableAlgorithms, s);
        return s;
    }

    public static final String[] getProviders(String filter) {
        Vector<String> v = new Vector<String>();
        block0: for (String p : PROVIDER_NAMES) {
            CryptoProvider provider = PROVIDERS.get(p);
            for (int i = 0; i < provider.algorithmNames.length; ++i) {
                if (!CryptoProvider.providerSatisfiesFilter(provider.algorithmNames[i], filter)) continue;
                v.addElement(provider.name);
                continue block0;
            }
        }
        if (v.size() == 0) {
            return null;
        }
        String[] s = new String[v.size()];
        CryptoProvider.copyStringVectorContentsIntoArray(v, s);
        return s;
    }

    public static final Object getAlgorithmImpl(String algorithm, boolean param) {
        return CryptoProvider.getAlgorithmImpl(algorithm, null, param);
    }

    public static final Object getAlgorithmImpl(String algorithm) {
        return CryptoProvider.getAlgorithmImpl(algorithm, null, false);
    }

    public static final Object getAlgorithmImpl(String algorithm, String provider, boolean param) {
        AccessController.checkPermission(new CryptoServicePermission(algorithm));
        if (algorithm == null) {
            throw new NullPointerException();
        }
        if (provider != null) {
            CryptoProvider instance = PROVIDERS.get(provider);
            if (instance != null) {
                return instance.createAlgorithmImpl(algorithm, param);
            }
        } else {
            for (String p : PROVIDER_NAMES) {
                CryptoProvider instance = PROVIDERS.get(p);
                Object algoImpl = instance.createAlgorithmImpl(algorithm, param);
                if (algoImpl == null) continue;
                return algoImpl;
            }
        }
        return null;
    }

    public static final Object getAlgorithmImpl(String algorithm, String provider) {
        return CryptoProvider.getAlgorithmImpl(algorithm, provider, false);
    }

    public CryptoProvider(String name, String[] algorithmNames) {
        if (name == null) {
            throw new NullPointerException("Argument name can't be null.");
        }
        if (algorithmNames == null) {
            throw new NullPointerException("Argument algorithmNames can't be null.");
        }
        this.name = name;
        this.algorithmNames = new String[algorithmNames.length];
        System.arraycopy(algorithmNames, 0, this.algorithmNames, 0, algorithmNames.length);
        if (PROVIDERS.containsKey(name)) {
            throw new IllegalArgumentException("Provider with same name already registered.");
        }
        PROVIDERS.put(name, this);
        PROVIDER_NAMES.addElement(name);
        availableAlgorithms = null;
    }

    protected abstract Object createAlgorithmImpl(String var1, boolean var2);

    public String[] getAlgorithmNames() {
        return this.algorithmNames;
    }

    public String getName() {
        return this.name;
    }

    private static void copyStringVectorContentsIntoArray(Vector<String> v, String[] arr) {
        if (v == null) {
            return;
        }
        for (int i = 0; i < v.size(); ++i) {
            arr[i] = new String(v.elementAt(i));
        }
    }

    private static boolean providerSatisfiesFilter(String name, String filter) {
        int lastDot;
        if (filter == null) {
            return true;
        }
        if (name.equalsIgnoreCase(filter)) {
            return true;
        }
        int firstDot = filter.indexOf(46);
        if (firstDot != (lastDot = filter.lastIndexOf(46))) {
            StringBuilder sb = new StringBuilder(name);
            sb.append(".");
            if (sb.toString().startsWith(filter)) {
                return true;
            }
        }
        return false;
    }
}

