/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.io;

import com.sun.javacard.impl.NativeMethods;
import java.util.Hashtable;
import java.util.Vector;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import org.mortbay.io.Buffer;
import org.mortbay.io.ByteArrayBuffer;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class BufferCache {
    private Hashtable<Buffer, CachedBuffer> bufferMap = new Hashtable();
    private Hashtable<String, CachedBuffer> stringMap = new Hashtable();
    private Vector<CachedBuffer> cache = new Vector();

    public CachedBuffer add(String value, int ordinal) {
        CachedBuffer buffer = new CachedBuffer(value, ordinal);
        NativeMethods.setJCREentry(buffer, false);
        this.bufferMap.put(buffer, buffer);
        this.stringMap.put(value, buffer);
        while (ordinal - this.cache.size() > 0) {
            this.cache.addElement(null);
        }
        this.cache.insertElementAt(buffer, ordinal);
        return buffer;
    }

    public CachedBuffer get(int ordinal) {
        if (ordinal < 0 || ordinal >= this.cache.size()) {
            return null;
        }
        return this.cache.elementAt(ordinal);
    }

    public CachedBuffer get(Buffer buffer) {
        return this.bufferMap.get(buffer);
    }

    public CachedBuffer get(String value) {
        return this.stringMap.get(value);
    }

    public Buffer lookup(Buffer buffer) {
        CachedBuffer b = this.get(buffer);
        if (b == null) {
            return buffer;
        }
        return b;
    }

    public CachedBuffer getBest(byte[] value, int offset, int maxLength) {
        return this.stringMap.get(new String(value, offset, maxLength));
    }

    public Buffer lookup(String value) {
        CachedBuffer b = this.get(value);
        if (b == null) {
            CachedBuffer cb = new CachedBuffer(value, -1);
            NativeMethods.setJCREentry(cb, false);
            return cb;
        }
        return b;
    }

    public String toString(Buffer buffer) {
        return this.lookup(buffer).toString();
    }

    public int getOrdinal(Buffer buffer) {
        if (buffer instanceof CachedBuffer) {
            return ((CachedBuffer)buffer).getOrdinal();
        }
        if ((buffer = this.lookup(buffer)) != null && buffer instanceof CachedBuffer) {
            return ((CachedBuffer)buffer).getOrdinal();
        }
        return -1;
    }

    public String toString() {
        return "CACHE[bufferMap=" + this.bufferMap + ",stringMap=" + this.stringMap + ",index=" + this.cache + "]";
    }

    public static class CachedBuffer
    extends ByteArrayBuffer.CaseInsensitive {
        private int ordinal;
        private Hashtable<Object, CachedBuffer> associateMap = null;

        public CachedBuffer(String value, int ordinal) {
            super(value);
            this.ordinal = ordinal;
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        public CachedBuffer getAssociate(Object key) {
            if (this.associateMap == null) {
                return null;
            }
            return this.associateMap.get(key);
        }

        public void setAssociate(Object key, CachedBuffer associate) {
            if (this.associateMap == null) {
                this.associateMap = new Hashtable();
            }
            this.associateMap.put(key, associate);
        }
    }
}

