/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.io.bio;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import org.mortbay.io.bio.StreamEndPoint;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class StringEndPoint
extends StreamEndPoint {
    String encoding = "ISO8859_1";
    ByteArrayInputStream bis = new ByteArrayInputStream(new byte[0]);
    ByteArrayOutputStream bos = new ByteArrayOutputStream();

    public StringEndPoint() {
        super(null, null);
        this.inputStream = this.bis;
        this.outputStream = this.bos;
    }

    public StringEndPoint(String encoding) {
        this();
        if (encoding != null) {
            this.encoding = encoding;
        }
    }

    public void setInput(String s) {
        try {
            byte[] bytes = s.getBytes(this.encoding);
            this.bis = new ByteArrayInputStream(bytes);
            this.inputStream = this.bis;
            this.bos = new ByteArrayOutputStream();
            this.outputStream = this.bos;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.toString());
        }
    }

    public String getOutput() {
        try {
            String s = new String(this.bos.toByteArray(), this.encoding);
            this.bos.reset();
            return s;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(this.encoding + ": " + e.toString());
        }
    }

    public boolean hasMore() {
        return this.bis.available() > 0;
    }
}

