/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import com.sun.javacard.Logger;
import com.sun.javacard.security.Principal;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.HttpFields;
import org.mortbay.jetty.HttpHeaders;
import org.mortbay.jetty.HttpURI;
import org.mortbay.jetty.SessionManager;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.security.Authenticator;
import org.mortbay.jetty.security.SecurityHandler;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.util.Attributes;
import org.mortbay.util.AttributesMap;
import org.mortbay.util.LazyList;
import org.mortbay.util.MultiMap;
import org.mortbay.util.QuotedStringTokenizer;
import org.mortbay.util.StringUtil;
import org.mortbay.util.URIUtil;
import org.mortbay.util.UrlEncoded;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class Request
implements HttpServletRequest {
    private static final int NONE = 0;
    private static final int STREAM = 1;
    private static final int READER = 2;
    private static final Cookie[] NO_COOKIES = null;
    private boolean handled = false;
    private HttpConnection connection;
    private HttpURI uri;
    private Principal userPrincipal;
    private MultiMap<String> parameters;
    private MultiMap<String> baseParameters;
    private BufferedReader reader;
    private Attributes attributes;
    private ContextHandler.Context context;
    private HttpSession session;
    private SessionManager sessionManager;
    private Cookie[] cookies;
    private LazyList<ServletRequestAttributeListener> requestAttributeListeners;
    private Hashtable<Object, HttpSession> savedNewSessions;
    private UserRealm userRealm;
    private String authType;
    private String characterEncoding;
    private String serverName;
    private String method;
    private String pathInfo;
    private int port;
    private String protocol = "HTTP/1.1";
    private String queryString;
    private String requestedSessionId;
    private boolean requestedSessionIdFromCookie = false;
    private String requestURI;
    private String contextPath;
    private String servletPath;
    private String servletName;
    private boolean paramsExtracted;
    private int inputState = 0;
    private boolean dns = false;
    private boolean cookiesExtracted = false;
    private String[] lastCookies;
    private long timeStamp;
    private String timeStampStr;
    private Vector<String> authorizedRoles;

    public Request() {
    }

    Request(HttpConnection connection) {
        this.connection = connection;
        this.dns = this.connection.getResolveNames();
    }

    void recycle() {
        this.handled = false;
        if (this.context != null) {
            throw new IllegalStateException("Request in context!");
        }
        if (this.attributes != null) {
            this.attributes.clearAttributes();
        }
        this.authType = null;
        this.characterEncoding = null;
        this.context = null;
        this.serverName = null;
        this.method = null;
        this.pathInfo = null;
        this.port = 0;
        this.protocol = "HTTP/1.1";
        this.queryString = null;
        this.requestedSessionId = null;
        this.requestedSessionIdFromCookie = false;
        this.requestURI = null;
        this.servletPath = null;
        this.uri = null;
        this.userPrincipal = null;
        if (this.baseParameters != null) {
            this.baseParameters.clear();
        }
        this.parameters = null;
        this.paramsExtracted = false;
        this.inputState = 0;
        this.reader = null;
        this.cookiesExtracted = false;
        if (this.savedNewSessions != null) {
            this.savedNewSessions.clear();
        }
        this.savedNewSessions = null;
        this.authorizedRoles = null;
    }

    public String getTimeStampStr() {
        if (this.timeStampStr == null && this.timeStamp > 0L) {
            this.timeStampStr = HttpFields.DATE_CACHE.format(this.timeStamp);
        }
        return this.timeStampStr;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long ts) {
        this.timeStamp = ts;
    }

    public boolean isHandled() {
        return this.handled;
    }

    public void setHandled(boolean h) {
        this.handled = h;
    }

    @Override
    public Object getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.getAttribute(name);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        if (this.attributes == null) {
            return new Vector().elements();
        }
        return this.attributes.getAttributeNames();
    }

    @Override
    public String getAuthType() {
        this.getUserPrincipal();
        return this.authType;
    }

    @Override
    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    @Override
    public int getContentLength() {
        return (int)this.connection.getRequestFields().getLongField(HttpHeaders.CONTENT_LENGTH_BUFFER);
    }

    @Override
    public String getContentType() {
        return this.connection.getRequestFields().getStringField(HttpHeaders.CONTENT_TYPE_BUFFER);
    }

    @Override
    public String getContextPath() {
        return this.contextPath;
    }

    @Override
    public Cookie[] getCookies() {
        if (this.cookiesExtracted) {
            return this.cookies;
        }
        try {
            int i;
            if (!this.connection.getRequestFields().containsKey(HttpHeaders.COOKIE_BUFFER)) {
                this.cookies = NO_COOKIES;
                this.cookiesExtracted = true;
                this.lastCookies = null;
                return this.cookies;
            }
            if (this.lastCookies != null) {
                int last = 0;
                Enumeration<String> enm = this.connection.getRequestFields().getValues(HttpHeaders.COOKIE_BUFFER);
                while (enm.hasMoreElements()) {
                    String c = enm.nextElement();
                    if (last >= this.lastCookies.length || !c.equals(this.lastCookies[last])) {
                        this.lastCookies = null;
                        break;
                    }
                    ++last;
                }
                if (this.lastCookies != null) {
                    this.cookiesExtracted = true;
                    return this.cookies;
                }
            }
            LazyList<Cookie> cookies = null;
            LazyList<String> lastCookies = null;
            int version = 0;
            Cookie cookie = null;
            Enumeration<String> enm = this.connection.getRequestFields().getValues(HttpHeaders.COOKIE_BUFFER);
            while (enm.hasMoreElements()) {
                String hdr = enm.nextElement();
                lastCookies = LazyList.add(lastCookies, hdr);
                QuotedStringTokenizer tok = new QuotedStringTokenizer(hdr, ",;", false, false);
                while (tok.hasMoreElements()) {
                    String c = (String)tok.nextElement();
                    if (c == null) continue;
                    c = c.trim();
                    try {
                        String v;
                        String n;
                        int e = c.indexOf(61);
                        if (e > 0) {
                            n = c.substring(0, e);
                            v = c.substring(e + 1);
                        } else {
                            n = c;
                            v = "";
                        }
                        if (version > 0) {
                            v = StringUtil.unquote(v);
                        }
                        if (n.startsWith("$")) {
                            if ("$version".equalsIgnoreCase(n)) {
                                version = Integer.parseInt(StringUtil.unquote(v));
                                continue;
                            }
                            if ("$path".equalsIgnoreCase(n) && cookie != null) {
                                cookie.setPath(v);
                                continue;
                            }
                            if (!"$domain".equalsIgnoreCase(n) || cookie == null) continue;
                            cookie.setDomain(v);
                            continue;
                        }
                        v = URIUtil.decodePath(v);
                        cookie = new Cookie(n, v);
                        if (version > 0) {
                            cookie.setVersion(version);
                        }
                        cookies = LazyList.add(cookies, cookie);
                    }
                    catch (Exception ex) {
                        Logger.debug(ex);
                    }
                }
            }
            int l = LazyList.size(cookies);
            if (this.cookies == null || this.cookies.length != l) {
                this.cookies = new Cookie[l];
            }
            for (i = 0; i < l; ++i) {
                this.cookies[i] = (Cookie)LazyList.get(cookies, i);
            }
            this.cookiesExtracted = true;
            l = LazyList.size(lastCookies);
            this.lastCookies = new String[l];
            for (i = 0; i < l; ++i) {
                this.lastCookies[i] = LazyList.get(lastCookies, i);
            }
        }
        catch (Exception e) {
            Logger.debug(e);
        }
        return this.cookies;
    }

    @Override
    public long getDateHeader(String name) {
        return this.connection.getRequestFields().getDateField(name);
    }

    @Override
    public String getHeader(String name) {
        return this.connection.getRequestFields().getStringField(name);
    }

    public void clearHeader(String name) {
        this.connection.getRequestFields().remove(name);
    }

    @Override
    public Enumeration<String> getHeaderNames() {
        return this.connection.getRequestFields().getFieldNames();
    }

    @Override
    public Enumeration<String> getHeaders(String name) {
        Enumeration<String> e = this.connection.getRequestFields().getValues(name, ",");
        if (e == null) {
            return new Vector().elements();
        }
        return e;
    }

    @Override
    public ServletInputStream getInputStream() {
        if (this.inputState != 0 && this.inputState != 1) {
            throw new IllegalStateException("READER");
        }
        this.inputState = 1;
        return this.connection.getInputStream();
    }

    @Override
    public int getIntHeader(String name) {
        return (int)this.connection.getRequestFields().getLongField(name);
    }

    @Override
    public String getLocalAddr() {
        return this.connection.getLocalAddr();
    }

    @Override
    public Locale getLocale() {
        Enumeration<String> enm = this.connection.getRequestFields().getValues("Accept-Language", ", \t");
        if (enm == null || !enm.hasMoreElements()) {
            return Locale.getDefault();
        }
        Vector<String> acceptLanguage = this.connection.getRequestFields().qualityList(enm);
        if (acceptLanguage.size() == 0) {
            return Locale.getDefault();
        }
        int i = 0;
        int size = acceptLanguage.size();
        if (i < size) {
            String language = acceptLanguage.elementAt(i);
            language = HttpFields.valueParameters(language, null);
            String country = "";
            int dash = language.indexOf(45);
            if (dash > -1) {
                country = language.substring(dash + 1).trim();
                language = language.substring(0, dash).trim();
            }
            return new Locale(language, country);
        }
        return Locale.getDefault();
    }

    private Enumeration<Locale> getDefaultLocalesList() {
        Vector<Locale> defaultLocaleList = new Vector<Locale>(){
            {
                this.addElement(Locale.getDefault());
            }
        };
        return defaultLocaleList.elements();
    }

    @Override
    public Enumeration<Locale> getLocales() {
        Enumeration<String> enm = this.connection.getRequestFields().getValues("Accept-Language", ", \t");
        if (enm == null || !enm.hasMoreElements()) {
            return this.getDefaultLocalesList();
        }
        Vector<String> acceptLanguage = this.connection.getRequestFields().qualityList(enm);
        if (acceptLanguage.size() == 0) {
            return this.getDefaultLocalesList();
        }
        LazyList<Object> langs = null;
        int size = acceptLanguage.size();
        for (int i = 0; i < size; ++i) {
            String language = acceptLanguage.elementAt(i);
            language = HttpFields.valueParameters(language, null);
            String country = "";
            int dash = language.indexOf(45);
            if (dash > -1) {
                country = language.substring(dash + 1).trim();
                language = language.substring(0, dash).trim();
            }
            langs = LazyList.ensureSize(langs, size);
            langs = LazyList.add(langs, new Locale(language, country));
        }
        if (LazyList.size(langs) == 0) {
            return this.getDefaultLocalesList();
        }
        return LazyList.getList(langs).elements();
    }

    @Override
    public String getLocalName() {
        if (this.dns) {
            return this.connection.getLocalName();
        }
        return this.connection.getLocalAddr();
    }

    @Override
    public int getLocalPort() {
        int portValue = this.connection.getLocalPort();
        return portValue;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public String getParameter(String name) {
        if (!this.paramsExtracted) {
            this.extractParameters();
        }
        return this.parameters.getValue(name, 0);
    }

    @Override
    public Enumeration<String> getParameterNames() {
        if (!this.paramsExtracted) {
            this.extractParameters();
        }
        return this.parameters.keys();
    }

    @Override
    public String[] getParameterValues(String name) {
        Vector<String> vals;
        if (!this.paramsExtracted) {
            this.extractParameters();
        }
        if ((vals = this.parameters.getValues(name)) == null) {
            return null;
        }
        Object[] array = new String[vals.size()];
        vals.copyInto(array);
        return array;
    }

    @Override
    public String getPathInfo() {
        return this.pathInfo;
    }

    @Override
    public String getPathTranslated() {
        if (this.pathInfo == null || this.context == null) {
            return null;
        }
        return this.context.getRealPath(this.pathInfo);
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public BufferedReader getReader() throws IOException {
        if (this.inputState != 0 && this.inputState != 2) {
            throw new IllegalStateException("STREAMED");
        }
        if (this.reader == null) {
            String encoding = this.getCharacterEncoding();
            if (encoding == null) {
                encoding = StringUtil.ISO_8859_1;
            }
            this.reader = new BufferedReader(new InputStreamReader(this.getInputStream(), encoding));
        }
        this.inputState = 2;
        return this.reader;
    }

    public String getRealPath(String path) {
        if (this.context == null) {
            return null;
        }
        return this.context.getRealPath(path);
    }

    @Override
    public String getRemoteAddr() {
        return this.connection.getRemoteAddr();
    }

    @Override
    public String getRemoteHost() {
        if (this.dns) {
            this.connection.getRemoteHost();
        }
        return this.connection.getRemoteAddr();
    }

    @Override
    public int getRemotePort() {
        int remotePortValue = this.connection.getRemotePort();
        return remotePortValue;
    }

    @Override
    public String getRemoteUser() {
        Principal p = this.getUserPrincipal();
        if (p == null) {
            return null;
        }
        return ((Object)p).toString();
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String path) {
        if (path == null || this.context == null) {
            return null;
        }
        if (!path.startsWith("/")) {
            String relTo = URIUtil.addPaths(this.servletPath, this.pathInfo);
            int slash = relTo.lastIndexOf(47);
            relTo = slash > 1 ? relTo.substring(0, slash + 1) : "/";
            path = URIUtil.addPaths(relTo, path);
        }
        return this.context.getRequestDispatcher(path);
    }

    @Override
    public String getRequestedSessionId() {
        return this.requestedSessionId;
    }

    @Override
    public String getRequestURI() {
        if (this.requestURI == null && this.uri != null) {
            this.requestURI = this.uri.getPathAndParam();
        }
        return this.requestURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringBuffer getRequestURL() {
        StringBuffer url;
        StringBuffer stringBuffer = url = new StringBuffer(48);
        synchronized (stringBuffer) {
            String scheme = this.getScheme();
            int port = this.getServerPort();
            url.append(scheme);
            url.append("://");
            url.append(this.getServerName());
            if (this.port > 0 && (scheme.equalsIgnoreCase("http") && port != 80 || scheme.equalsIgnoreCase("https") && port != 443)) {
                url.append(':');
                url.append(this.port);
            }
            url.append(this.getRequestURI());
            return url;
        }
    }

    @Override
    public String getScheme() {
        return this.isSecure() ? this.connection.connector.getConfidentialScheme() : "http";
    }

    @Override
    public String getServerName() {
        if (this.serverName != null) {
            return this.serverName;
        }
        this.serverName = this.connection.getRequestFields().getServerName(this.uri, this.connection);
        return this.serverName;
    }

    @Override
    public int getServerPort() {
        if (this.port <= 0) {
            this.port = this.connection.getRequestFields().getServerPort(this.uri, this.connection, this.getScheme());
        }
        return this.port;
    }

    @Override
    public String getServletPath() {
        if (this.servletPath == null) {
            this.servletPath = "";
        }
        return this.servletPath;
    }

    public String getServletName() {
        return this.servletName;
    }

    @Override
    public HttpSession getSession() {
        return this.getSession(true);
    }

    @Override
    public HttpSession getSession(boolean create) {
        if (this.session != null && this.session.getId() != null && this.sessionManager != null && this.sessionManager.isValid(this.session)) {
            Logger.debug("Request:session->" + this.session);
            Logger.debug("Request:sessionId->" + this.session.getId());
            return this.session;
        }
        this.session = null;
        String id = this.getRequestedSessionId();
        if (id != null && this.sessionManager != null) {
            this.session = this.sessionManager.getHttpSession(id);
            if (this.session == null && !create) {
                return null;
            }
        }
        if (this.sessionManager != null && create && (this.session == null || !this.sessionManager.isValid(this.session))) {
            Logger.debug("Request: session not valid but create is true");
            this.session = this.sessionManager.newHttpSession(this);
            Cookie cookie = this.sessionManager.getSessionCookie(this.session, this.getContextPath(), this.isSecure());
            if (cookie != null) {
                this.connection.getResponse().addCookie(cookie);
            }
        }
        return this.session;
    }

    public Principal getUserPrincipal() {
        if (this.userPrincipal != null && this.userPrincipal instanceof SecurityHandler.NotChecked) {
            String pathInContext;
            SecurityHandler.NotChecked not_checked = (SecurityHandler.NotChecked)this.userPrincipal;
            this.userPrincipal = SecurityHandler.__NO_USER;
            Authenticator auth = not_checked.getSecurityHandler().getAuthenticator();
            UserRealm realm = not_checked.getSecurityHandler().getUserRealm();
            String string = pathInContext = this.getPathInfo() == null ? this.getServletPath() : this.getServletPath() + this.getPathInfo();
            if (realm != null && auth != null) {
                try {
                    auth.authenticate(realm, pathInContext, this, null);
                }
                catch (Exception e) {
                    Logger.debug(e);
                }
            }
        }
        if (this.userPrincipal == SecurityHandler.__NO_USER) {
            return null;
        }
        return this.userPrincipal;
    }

    @Override
    public String getQueryString() {
        if (this.queryString == null && this.uri != null) {
            this.queryString = this.uri.getQuery();
        }
        return this.queryString;
    }

    @Override
    public boolean isRequestedSessionIdFromCookie() {
        return this.requestedSessionId != null && this.requestedSessionIdFromCookie;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.requestedSessionId != null && !this.requestedSessionIdFromCookie;
    }

    @Override
    public boolean isRequestedSessionIdFromURL() {
        return this.requestedSessionId != null && !this.requestedSessionIdFromCookie;
    }

    @Override
    public boolean isRequestedSessionIdValid() {
        HttpSession session = null;
        return this.requestedSessionId != null && (session = this.getSession(false)) != null && this.requestedSessionId.equals(session.getId());
    }

    @Override
    public boolean isSecure() {
        return this.connection.isConfidential(this);
    }

    @Override
    public boolean isUserInRole(String role) {
        this.getUserPrincipal();
        if (this.userRealm != null && this.userPrincipal != null) {
            return this.userRealm.isUserInRole(this.userPrincipal, role, this);
        }
        return false;
    }

    @Override
    public void removeAttribute(String name) {
        Object old_value;
        Object object = old_value = this.attributes == null ? null : this.attributes.getAttribute(name);
        if (this.attributes != null) {
            this.attributes.removeAttribute(name);
        }
        if (old_value != null && this.requestAttributeListeners != null) {
            ServletRequestAttributeEvent event = new ServletRequestAttributeEvent(this.context, this, name, old_value);
            for (int i = 0; i < LazyList.size(this.requestAttributeListeners); ++i) {
                LazyList.get(this.requestAttributeListeners, i).attributeRemoved(event);
            }
        }
    }

    @Override
    public void setAttribute(String name, Object value) {
        Object old_value;
        Object object = old_value = this.attributes == null ? null : this.attributes.getAttribute(name);
        if (this.attributes == null) {
            this.attributes = new AttributesMap();
        }
        this.attributes.setAttribute(name, value);
        if (this.requestAttributeListeners != null) {
            ServletRequestAttributeEvent event = new ServletRequestAttributeEvent(this.context, this, name, old_value == null ? value : old_value);
            for (int i = 0; i < LazyList.size(this.requestAttributeListeners); ++i) {
                ServletRequestAttributeListener l = LazyList.get(this.requestAttributeListeners, i);
                if (old_value == null) {
                    l.attributeAdded(event);
                    continue;
                }
                if (value == null) {
                    l.attributeRemoved(event);
                    continue;
                }
                l.attributeReplaced(event);
            }
        }
    }

    @Override
    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        if (this.inputState != 0) {
            return;
        }
        new String(new byte[0], encoding);
        this.characterEncoding = encoding;
    }

    public void _setCharacterEncoding(String encoding) {
        this.characterEncoding = encoding;
    }

    public void extractParameters() {
        int content_length;
        String content_type;
        if (this.baseParameters == null) {
            this.baseParameters = new MultiMap(16);
        }
        if (this.paramsExtracted) {
            if (this.parameters == null) {
                this.parameters = this.baseParameters;
            }
            return;
        }
        this.paramsExtracted = true;
        String encoding = this.getCharacterEncoding();
        if (this.uri != null && this.uri.getQuery() != null) {
            try {
                this.uri.decodeQueryTo(this.baseParameters, encoding);
            }
            catch (Exception e) {
                Logger.debug(e);
            }
        }
        if ((content_type = this.getContentType()) != null && content_type.length() > 0 && "application/x-www-form-urlencoded".equalsIgnoreCase(content_type = HttpFields.valueParameters(content_type, null)) && "POST".equals(this.getMethod()) && (content_length = this.getContentLength()) != 0) {
            try {
                if (content_length > 262144) {
                    throw new IllegalStateException("Form too large");
                }
                ServletInputStream in = this.getInputStream();
                UrlEncoded.decodeTo(in, this.baseParameters, encoding, content_length < 0 ? 262144 : -1);
            }
            catch (IOException e) {
                Logger.debug(e);
            }
        }
        if (this.parameters == null) {
            this.parameters = this.baseParameters;
        } else if (this.parameters != this.baseParameters) {
            Enumeration iter = this.baseParameters.keys();
            String name = null;
            LazyList<String> values = null;
            while (iter.hasMoreElements()) {
                name = (String)iter.nextElement();
                values = this.baseParameters.get(name);
                for (int i = 0; i < LazyList.size(values); ++i) {
                    this.parameters.add(name, LazyList.get(values, i));
                }
            }
        }
    }

    public void setServerName(String host) {
        this.serverName = host;
    }

    public HttpURI getUri() {
        return this.uri;
    }

    public void setUri(HttpURI uri) {
        this.uri = uri;
    }

    public HttpConnection getConnection() {
        return this.connection;
    }

    public int getInputState() {
        return this.inputState;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public void setCookies(Cookie[] cookies) {
        this.cookies = cookies;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setRequestedSessionId(String requestedSessionId) {
        this.requestedSessionId = requestedSessionId;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void setRequestedSessionIdFromCookie(boolean requestedSessionIdCookie) {
        this.requestedSessionIdFromCookie = requestedSessionIdCookie;
    }

    public void setSession(HttpSession session) {
        this.session = session;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public void setServletName(String name) {
        this.servletName = name;
    }

    public void setUserPrincipal(Principal userPrincipal) {
        this.userPrincipal = userPrincipal;
    }

    public void setContext(ContextHandler.Context context) {
        this.context = context;
    }

    public ContextHandler.Context getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer getRootURL() {
        StringBuffer url;
        StringBuffer stringBuffer = url = new StringBuffer(48);
        synchronized (stringBuffer) {
            String scheme = this.getScheme();
            int port = this.getServerPort();
            url.append(scheme);
            url.append("://");
            url.append(this.getServerName());
            if (port > 0 && (scheme.equalsIgnoreCase("http") && port != 80 || scheme.equalsIgnoreCase("https") && port != 443)) {
                url.append(':');
                url.append(port);
            }
            return url;
        }
    }

    public Attributes getAttributes() {
        if (this.attributes == null) {
            this.attributes = new AttributesMap();
        }
        return this.attributes;
    }

    public void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    public MultiMap<String> getParameters() {
        return this.parameters;
    }

    public void setParameters(MultiMap<String> parameters) {
        MultiMap<String> multiMap = this.parameters = parameters == null ? this.baseParameters : parameters;
        if (this.paramsExtracted && this.parameters == null) {
            throw new IllegalStateException();
        }
    }

    public String toString() {
        return this.getMethod() + " " + this.uri + " " + this.getProtocol() + "\n" + this.connection.getRequestFields().toString();
    }

    public static Request getRequest(HttpServletRequest request) {
        if (request instanceof Request) {
            return (Request)request;
        }
        while (request instanceof ServletRequestWrapper) {
            request = (HttpServletRequest)((ServletRequestWrapper)((Object)request)).getRequest();
        }
        if (request instanceof Request) {
            return (Request)request;
        }
        return HttpConnection.getCurrentConnection().getRequest();
    }

    public synchronized void addEventListener(EventListener listener) {
        if (listener instanceof ServletRequestAttributeListener) {
            this.requestAttributeListeners = LazyList.add(this.requestAttributeListeners, (ServletRequestAttributeListener)listener);
        }
    }

    public synchronized void removeEventListener(EventListener listener) {
        if (listener instanceof ServletRequestAttributeListener) {
            this.requestAttributeListeners = LazyList.remove(this.requestAttributeListeners, (ServletRequestAttributeListener)listener);
        }
    }

    public void saveNewSession(Object key, HttpSession session) {
        if (this.savedNewSessions == null) {
            this.savedNewSessions = new Hashtable();
        }
        this.savedNewSessions.put(key, session);
    }

    public HttpSession recoverNewSession(Object key) {
        if (this.savedNewSessions == null) {
            return null;
        }
        Logger.debug("Request recover session:" + this.savedNewSessions.get(key));
        return this.savedNewSessions.get(key);
    }

    public UserRealm getUserRealm() {
        return this.userRealm;
    }

    public void setUserRealm(UserRealm userRealm) {
        this.userRealm = userRealm;
    }

    public Vector<String> getAuthorizedRoles() {
        return this.authorizedRoles;
    }

    public void setAuthorizedRoles(Vector<String> authorizedRoles) {
        this.authorizedRoles = authorizedRoles;
    }
}

