/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.handler;

import java.io.IOException;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.EofException;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.handler.AbstractHandlerContainer;
import org.mortbay.util.LazyList;
import org.mortbay.util.MultiException;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class HandlerCollection
extends AbstractHandlerContainer {
    private LazyList<Handler> handlers;

    public LazyList<Handler> getHandlers() {
        return this.handlers;
    }

    public void setHandlers(LazyList<Handler> handlers) {
        LazyList<Handler> old_handlers = this.handlers;
        MultiException mex = new MultiException();
        if (old_handlers != null) {
            for (Handler h : old_handlers) {
                if (h == null || this.existsInNewHandlers(h, handlers) || !h.isStarted()) continue;
                try {
                    h.stop();
                }
                catch (Throwable e) {
                    mex.add(e);
                }
            }
        }
        if (handlers != null) {
            for (Handler h : handlers) {
                if (h == null) continue;
                try {
                    if (!this.isStarted() || h.isStarted()) continue;
                    h.start();
                }
                catch (Throwable e) {
                    mex.add(e);
                }
            }
        }
        this.handlers = handlers;
        mex.ifExceptionThrowRuntime();
    }

    private boolean existsInNewHandlers(Handler handler, LazyList<Handler> handlers2) {
        for (Handler h : handlers2) {
            if (!handler.equals(h)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        if (this.handlers != null && this.isStarted()) {
            MultiException mex = null;
            for (Handler element : this.handlers) {
                try {
                    element.handle(target, request, response, dispatch);
                }
                catch (EofException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (mex == null) {
                        mex = new MultiException();
                    }
                    mex.add(e);
                }
            }
            if (mex != null) {
                throw new ServletException(mex);
            }
        }
    }

    @Override
    protected void doStart() throws Exception {
        MultiException mex = new MultiException();
        if (this.handlers != null) {
            for (Handler element : this.handlers) {
                try {
                    element.start();
                }
                catch (Throwable e) {
                    mex.add(e);
                }
            }
        }
        super.doStart();
        mex.ifExceptionThrow();
    }

    @Override
    protected void doStop() throws Exception {
        MultiException mex = new MultiException();
        try {
            super.doStop();
        }
        catch (Throwable e) {
            mex.add(e);
        }
        if (this.handlers != null) {
            for (Handler h : this.handlers) {
                try {
                    h.stop();
                }
                catch (Throwable e) {
                    mex.add(e);
                }
            }
        }
        mex.ifExceptionThrow();
    }

    @Override
    public void addHandler(Handler handler) {
        this.setHandlers(LazyList.add(this.getHandlers(), handler));
    }

    public void removeHandler(Handler handler) {
        this.setHandlers(LazyList.remove(this.getHandlers(), handler));
    }

    @Override
    protected LazyList<Handler> expandChildren(LazyList<Handler> list, Class<?> byClass) {
        LazyList<Handler> handlers = this.getHandlers();
        if (handlers != null) {
            for (Handler h : handlers) {
                list = this.expandHandler(h, list, byClass);
            }
        }
        return list;
    }
}

