/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.security;

import com.sun.javacard.Logger;
import com.sun.javacard.security.Principal;
import java.io.IOException;
import java.util.Vector;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.security.Authenticator;
import org.mortbay.jetty.security.Credential;
import org.mortbay.jetty.security.Password;
import org.mortbay.jetty.security.SSORealm;
import org.mortbay.jetty.security.SecurityHandler;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.util.URIUtil;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class FormAuthenticator
implements Authenticator {
    public static final String J_URI = "org.mortbay.jetty.URI";
    public static final String J_AUTHORIZED_ROLES = "org.mortbay.jetty.Roles";
    public static final String J_AUTHENTICATED = "org.mortbay.jetty.Auth";
    public static final String J_SECURITY_CHECK = "/j_security_check";
    public static final String J_USERNAME = "j_username";
    public static final String J_PASSWORD = "j_password";
    private String formErrorPage;
    private String formErrorPath;
    private String formLoginPage;
    private String formLoginPath;

    @Override
    public String getAuthMethod() {
        return "FORM";
    }

    public void setLoginPage(String path) {
        if (!path.startsWith("/")) {
            Logger.debug("form-login-page must start with /");
            path = "/" + path;
        }
        this.formLoginPage = path;
        this.formLoginPath = path;
        if (this.formLoginPath.indexOf(63) > 0) {
            this.formLoginPath = this.formLoginPath.substring(0, this.formLoginPath.indexOf(63));
        }
    }

    public String getLoginPage() {
        return this.formLoginPage;
    }

    public void setErrorPage(String path) {
        if (path == null || path.trim().length() == 0) {
            this.formErrorPath = null;
            this.formErrorPage = null;
        } else {
            if (!path.startsWith("/")) {
                Logger.debug("form-error-page must start with /");
                path = "/" + path;
            }
            this.formErrorPage = path;
            this.formErrorPath = path;
            if (this.formErrorPath != null && this.formErrorPath.indexOf(63) > 0) {
                this.formErrorPath = this.formErrorPath.substring(0, this.formErrorPath.indexOf(63));
            }
        }
    }

    public String getErrorPage() {
        return this.formErrorPage;
    }

    @Override
    public Principal authenticate(UserRealm realm, String pathInContext, Request request, Response response) throws IOException {
        String uri = pathInContext;
        HttpSession session = request.getSession(response != null);
        if (session == null) {
            return null;
        }
        if (uri.endsWith(J_SECURITY_CHECK)) {
            if (response == null) {
                return null;
            }
            Vector authorizedRoles = (Vector)session.getAttribute(J_AUTHORIZED_ROLES);
            request.setAuthorizedRoles(authorizedRoles);
            FormCredential formCred = new FormCredential();
            formCred.authenticate(realm, request.getParameter(J_USERNAME), request.getParameter(J_PASSWORD), request);
            String nuri = (String)session.getAttribute(J_URI);
            if ((nuri == null || nuri.length() == 0) && (nuri = request.getContextPath()).length() == 0) {
                nuri = "/";
            }
            if (formCred.userPrincipal != null) {
                if (formCred.userPrincipal.getName().equals("forbidden")) {
                    response.sendError(403);
                    return null;
                }
                Logger.debug("Form authentication OK for " + formCred.jUserName);
                session.removeAttribute(J_AUTHORIZED_ROLES);
                session.removeAttribute(J_URI);
                request.setAuthType("FORM");
                request.setUserPrincipal(formCred.userPrincipal);
                session.setAttribute(J_AUTHENTICATED, formCred);
                if (realm instanceof SSORealm) {
                    ((SSORealm)((Object)realm)).setSingleSignOn(request, response, formCred.userPrincipal, new Password(formCred.jPassword));
                }
                if (response != null) {
                    response.setContentLength(0);
                    response.sendRedirect(response.encodeRedirectURL(nuri));
                }
            } else {
                Logger.debug("Form authentication FAILED for " + formCred.jUserName);
                if (this.formErrorPage == null) {
                    if (response != null) {
                        response.sendError(403);
                    }
                } else {
                    if (response != null) {
                        response.setContentLength(0);
                    }
                    response.sendRedirect(response.encodeRedirectURL(URIUtil.addPaths(request.getContextPath(), this.formErrorPage)));
                }
            }
            return null;
        }
        FormCredential formCred = (FormCredential)session.getAttribute(J_AUTHENTICATED);
        if (formCred != null) {
            if (formCred.userPrincipal == null) {
                formCred.authenticate(realm, request);
                if (formCred.userPrincipal != null && realm instanceof SSORealm) {
                    ((SSORealm)((Object)realm)).setSingleSignOn(request, response, formCred.userPrincipal, new Password(formCred.jPassword));
                }
            } else if (!realm.reauthenticate(formCred.userPrincipal)) {
                formCred.userPrincipal = null;
            }
            if (formCred.userPrincipal != null) {
                Logger.debug("FORM Authenticated for " + formCred.userPrincipal.getName());
                request.setAuthType("FORM");
                request.setUserPrincipal(formCred.userPrincipal);
                return formCred.userPrincipal;
            }
            session.setAttribute(J_AUTHENTICATED, null);
        } else if (realm instanceof SSORealm) {
            Credential cred = ((SSORealm)((Object)realm)).getSingleSignOn(request, response);
            if (request.getUserPrincipal() != null) {
                formCred = new FormCredential();
                formCred.userPrincipal = request.getUserPrincipal();
                formCred.jUserName = formCred.userPrincipal.getName();
                if (cred != null) {
                    formCred.jPassword = cred.toString();
                }
                Logger.debug("SSO for " + formCred.userPrincipal);
                request.setAuthType("FORM");
                session.setAttribute(J_AUTHENTICATED, formCred);
                return formCred.userPrincipal;
            }
        }
        if (this.isLoginOrErrorPage(pathInContext)) {
            return SecurityHandler.__NOBODY;
        }
        if (response != null) {
            Vector<String> authorizedRoles = request.getAuthorizedRoles();
            session.setAttribute(J_AUTHORIZED_ROLES, authorizedRoles);
            if (request.getQueryString() != null) {
                uri = uri + "?" + request.getQueryString();
            }
            session.setAttribute(J_URI, request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + URIUtil.addPaths(request.getContextPath(), uri));
            response.setContentLength(0);
            response.sendRedirect(response.encodeRedirectURL(URIUtil.addPaths(request.getContextPath(), this.formLoginPage)));
        }
        return null;
    }

    public boolean isLoginOrErrorPage(String pathInContext) {
        return pathInContext != null && (pathInContext.equals(this.formErrorPath) || pathInContext.equals(this.formLoginPath));
    }

    static class FormCredential
    implements HttpSessionBindingListener {
        String jUserName;
        String jPassword;
        transient Principal userPrincipal;
        transient UserRealm realm;

        FormCredential() {
        }

        void authenticate(UserRealm realm, String user, String password, Request request) {
            this.jUserName = user;
            this.jPassword = password;
            this.userPrincipal = realm.authenticate(user, password, request, "FORM");
            if (this.userPrincipal != null) {
                this.realm = realm;
            }
        }

        void authenticate(UserRealm realm, Request request) {
            this.userPrincipal = realm.authenticate(this.jUserName, this.jPassword, request, "FORM");
            if (this.userPrincipal != null) {
                this.realm = realm;
            }
            request.setAuthType("FORM");
        }

        @Override
        public void valueBound(HttpSessionBindingEvent event) {
        }

        @Override
        public void valueUnbound(HttpSessionBindingEvent event) {
            Logger.debug("Logout " + this.jUserName);
            if (this.realm instanceof SSORealm) {
                ((SSORealm)((Object)this.realm)).clearSingleSignOn(this.jUserName);
            }
            if (this.realm != null && this.userPrincipal != null) {
                this.realm.logout(this.userPrincipal);
            }
        }

        public int hashCode() {
            return this.jUserName.hashCode() + this.jPassword.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof FormCredential)) {
                return false;
            }
            FormCredential fc = (FormCredential)o;
            return this.jUserName.equals(fc.jUserName) && this.jPassword.equals(fc.jPassword);
        }

        public String toString() {
            return "Cred[" + this.jUserName + "]";
        }
    }
}

