/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.security;

import com.sun.javacard.Logger;
import com.sun.javacard.security.Principal;
import com.sun.midp.io.Properties;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.security.Credential;
import org.mortbay.jetty.security.Password;
import org.mortbay.jetty.security.SSORealm;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.resource.Resource;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class HashUserRealm
implements UserRealm,
SSORealm {
    public static final String SSO = "org.mortbay.http.SSO";
    private String realmName;
    private String config;
    private Hashtable<String, Object> users = new Hashtable();
    protected Hashtable<String, Vector<String>> roles = new Hashtable(7);
    private SSORealm ssoRealm;

    public HashUserRealm() {
    }

    public HashUserRealm(String name) {
        this.realmName = name;
    }

    public HashUserRealm(String name, String config) throws IOException {
        this.realmName = name;
        this.setConfig(config);
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) throws IOException {
        this.config = config;
        this.users.clear();
        this.roles.clear();
        Logger.debug("Load " + this + " from " + config);
        Properties properties = new Properties();
        Resource resource = Resource.newResource(config);
        properties.loadFromInputStream(resource.getInputStream());
        Enumeration<String> iter = properties.keys();
        while (iter.hasMoreElements()) {
            String username = iter.nextElement().trim();
            String credentials = properties.getProperty(username).trim();
            String roles = null;
            int c = credentials.indexOf(44);
            if (c > 0) {
                roles = credentials.substring(c + 1).trim();
                credentials = credentials.substring(0, c).trim();
            }
            if (username == null || username.length() <= 0 || credentials == null || credentials.length() <= 0) continue;
            this.put(username, credentials);
            if (roles == null || roles.length() <= 0) continue;
            StringTokenizer tok = new StringTokenizer(roles, ", ");
            while (tok.hasMoreTokens()) {
                this.addUserToRole(username, tok.nextToken());
            }
        }
    }

    public void setName(String name) {
        this.realmName = name;
    }

    @Override
    public String getName() {
        return this.realmName;
    }

    @Override
    public Principal getPrincipal(String username) {
        return (Principal)this.users.get(username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Principal authenticate(String username, Object credentials, Request request, String method) {
        KnownUser user;
        HashUserRealm hashUserRealm = this;
        synchronized (hashUserRealm) {
            user = (KnownUser)this.users.get(username);
        }
        if (user == null) {
            return null;
        }
        if (user.authenticate(credentials)) {
            return user;
        }
        return null;
    }

    @Override
    public void disassociate(Principal user) {
    }

    @Override
    public Principal pushRole(Principal user, String role) {
        if (user == null) {
            user = new User();
        }
        return new WrappedUser(user, role);
    }

    @Override
    public Principal popRole(Principal user) {
        WrappedUser wu = (WrappedUser)user;
        return wu.getUserPrincipal();
    }

    public synchronized Object put(String name, Object credentials) {
        if (credentials instanceof Principal) {
            return this.users.put(name, credentials);
        }
        if (credentials instanceof Password) {
            return this.users.put(name, new KnownUser(name, (Password)credentials));
        }
        if (credentials != null) {
            return this.users.put(name, new KnownUser(name, Credential.getCredential(credentials.toString())));
        }
        return null;
    }

    public synchronized void addUserToRole(String userName, String roleName) {
        Vector<String> userSet = this.roles.get(roleName);
        if (userSet == null) {
            userSet = new Vector(11);
            this.roles.put(roleName, userSet);
        }
        userSet.addElement(userName);
    }

    @Override
    public boolean reauthenticate(Principal user) {
        return ((User)user).isAuthenticated();
    }

    @Override
    public boolean isUserInRole(Principal user, String roleName, Request request) {
        if (user instanceof WrappedUser) {
            return ((WrappedUser)user).isUserInRole(roleName);
        }
        if (user == null || !(user instanceof User) || ((User)user).getUserRealm() != this) {
            return false;
        }
        Vector<String> userSet = this.roles.get(roleName);
        return userSet != null && userSet.contains(user.getName());
    }

    @Override
    public void logout(Principal user) {
    }

    public String toString() {
        return "Realm[" + this.realmName + "]==" + this.users.keys();
    }

    public void dump(PrintStream out) {
        out.println(this + ":");
        out.println(super.toString());
        out.println(this.roles);
    }

    public SSORealm getSSORealm() {
        return this.ssoRealm;
    }

    public void setSSORealm(SSORealm ssoRealm) {
        this.ssoRealm = ssoRealm;
    }

    @Override
    public Credential getSingleSignOn(Request request, Response response) {
        if (this.ssoRealm != null) {
            return this.ssoRealm.getSingleSignOn(request, response);
        }
        return null;
    }

    @Override
    public void setSingleSignOn(Request request, Response response, Principal principal, Credential credential) {
        if (this.ssoRealm != null) {
            this.ssoRealm.setSingleSignOn(request, response, principal, credential);
        }
    }

    @Override
    public void clearSingleSignOn(String username) {
        if (this.ssoRealm != null) {
            this.ssoRealm.clearSingleSignOn(username);
        }
    }

    private class WrappedUser
    extends User {
        private Principal user;
        private String role;

        WrappedUser(Principal user, String role) {
            this.user = user;
            this.role = role;
        }

        Principal getUserPrincipal() {
            return this.user;
        }

        @Override
        public String getName() {
            return "role:" + this.role;
        }

        @Override
        public boolean isAuthenticated() {
            return true;
        }

        public boolean isUserInRole(String role) {
            return this.role.equals(role);
        }
    }

    private class KnownUser
    extends User {
        private String userName;
        private Credential credential;

        KnownUser(String name, Credential credential) {
            this.userName = name;
            this.credential = credential;
        }

        boolean authenticate(Object credentials) {
            return this.credential != null && this.credential.check(credentials);
        }

        @Override
        public String getName() {
            return this.userName;
        }

        @Override
        public boolean isAuthenticated() {
            return true;
        }
    }

    class User
    implements Principal {
        User() {
        }

        UserRealm getUserRealm() {
            return HashUserRealm.this;
        }

        @Override
        public String getName() {
            return "Anonymous";
        }

        public boolean isAuthenticated() {
            return false;
        }

        @Override
        public String toString() {
            return this.getName();
        }
    }
}

