/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.security;

import com.sun.javacard.Logger;
import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.security.JCAuthenticator;
import com.sun.javacard.security.Principal;
import com.sun.javacard.security.SIOUserRealm;
import java.io.IOException;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.WebConnector;
import org.mortbay.jetty.handler.HandlerWrapper;
import org.mortbay.jetty.security.Authenticator;
import org.mortbay.jetty.security.BasicAuthenticator;
import org.mortbay.jetty.security.Constraint;
import org.mortbay.jetty.security.ConstraintMapping;
import org.mortbay.jetty.security.DigestAuthenticator;
import org.mortbay.jetty.security.FormAuthenticator;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.jetty.servlet.PathMap;
import org.mortbay.util.LazyList;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class SecurityHandler
extends HandlerWrapper {
    private String _authMethod = "BASIC";
    private UserRealm _userRealm;
    private LazyList<ConstraintMapping> _constraintMappings;
    private PathMap<LazyList<ConstraintMapping>> _constraintMap = new PathMap();
    private Authenticator _authenticator;
    private NotChecked _notChecked = new NotChecked();
    public static final Principal __NO_USER = new Principal(){

        @Override
        public String getName() {
            return null;
        }

        @Override
        public String toString() {
            return "No User";
        }
    };
    public static final Principal __NOBODY = new Principal(){

        @Override
        public String getName() {
            return "Nobody";
        }

        @Override
        public String toString() {
            return this.getName();
        }
    };

    public Authenticator getAuthenticator() {
        Logger.debug("SH---get auth" + this._authenticator);
        return this._authenticator;
    }

    public void setAuthenticator(Authenticator authenticator) {
        Logger.debug("SH---auth" + authenticator);
        this._authenticator = authenticator;
    }

    public UserRealm getUserRealm() {
        return this._userRealm;
    }

    public void setUserRealm(UserRealm userRealm) {
        this._userRealm = userRealm;
    }

    public LazyList<ConstraintMapping> getConstraintMappings() {
        return this._constraintMappings;
    }

    public void setConstraintMappings(LazyList<ConstraintMapping> constraintMappings) {
        this._constraintMappings = constraintMappings;
        if (this._constraintMappings != null) {
            this._constraintMappings = constraintMappings;
            this._constraintMap.clear();
            for (ConstraintMapping element : this._constraintMappings) {
                LazyList<ConstraintMapping> mappings = this._constraintMap.match(element.getPathSpec());
                mappings = LazyList.add(mappings, element);
                this._constraintMap.put(element.getPathSpec(), mappings);
            }
        }
    }

    public String getAuthMethod() {
        Logger.debug("GET AUTH METHOD=" + this._authMethod);
        return this._authMethod;
    }

    public void setAuthMethod(String method) {
        if (this.isStarted() && this._authMethod != null && !this._authMethod.equals(method)) {
            throw new IllegalStateException("Handler started");
        }
        Logger.debug("SET AUTH METHOD=" + this._authMethod);
        this._authMethod = method;
    }

    @Override
    public void doStart() throws Exception {
        if (this._authenticator == null) {
            if ("BASIC".equalsIgnoreCase(this._authMethod)) {
                this._authenticator = new BasicAuthenticator();
            } else if ("DIGEST".equalsIgnoreCase(this._authMethod)) {
                this._authenticator = new DigestAuthenticator();
            } else if ("FORM".equalsIgnoreCase(this._authMethod)) {
                this._authenticator = new FormAuthenticator();
            } else if (Constraint.getIndex(Constraint.JC_AUTH, this._authMethod) != -1) {
                this._authenticator = new JCAuthenticator(this._authMethod);
            } else {
                Logger.verbose("Unknown Authentication method:" + this._authMethod);
            }
        }
        super.doStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        Logger.debug("In org.mortbay.jetty.security.SecurityHandler.handle()");
        Request base_request = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
        Response base_response = response instanceof Response ? (Response)response : HttpConnection.getCurrentConnection().getResponse();
        UserRealm old_realm = base_request.getUserRealm();
        try {
            base_request.setUserRealm(this.getUserRealm());
            Logger.debug("Check security constraints...");
            if (dispatch == 1 && !this.checkSecurityConstraints(target, base_request, base_response)) {
                base_request.setHandled(true);
                Logger.debug("Check on security constraints returned false");
                return;
            }
            if (this._authenticator instanceof FormAuthenticator && target.endsWith("/j_security_check")) {
                this._authenticator.authenticate(this.getUserRealm(), target, base_request, base_response);
                base_request.setHandled(true);
                Logger.debug("Check on security: FormAuthenticator.J_SECURITY_CHECK");
                return;
            }
            if (this._authenticator instanceof JCAuthenticator && target.endsWith("/jc_security_check")) {
                this._authenticator.authenticate(this.getUserRealm(), target, base_request, base_response);
                base_request.setHandled(true);
                Logger.debug("Check on security: JCAuthenticator.JC_SECURITY_CHECK");
                return;
            }
            if (this.getHandler() != null) {
                this.getHandler().handle(target, request, response, dispatch);
                Logger.debug("request has been handled by sec. handler");
            }
        }
        finally {
            if (this._userRealm != null && base_request.getUserPrincipal() != null) {
                this._userRealm.disassociate(base_request.getUserPrincipal());
            }
            base_request.setUserRealm(old_realm);
        }
    }

    public boolean checkSecurityConstraints(String pathInContext, Request request, Response response) throws IOException {
        if (this._userRealm instanceof SIOUserRealm) {
            if (!((SIOUserRealm)this._userRealm).isAccessibleFromClient(request)) {
                response.sendError(403, "Not Accessible From Client");
                return false;
            }
            if (!((SIOUserRealm)this._userRealm).isCardHolderAuthorized(request)) {
                response.sendError(403, "Need Card Holder Authorization");
                return false;
            }
        }
        Logger.debug("In org.mortbay.jetty.security.SecurityHandler.checkSecurityConstraints()");
        LazyList<PathMap.Entry<LazyList<ConstraintMapping>>> mapping_entries = this._constraintMap.getLazyMatches(pathInContext);
        String pattern = null;
        LazyList<Constraint> constraints = null;
        if (mapping_entries != null) {
            block0: for (int m = 0; m < LazyList.size(mapping_entries); ++m) {
                PathMap.Entry<LazyList<ConstraintMapping>> entry = LazyList.get(mapping_entries, m);
                LazyList<ConstraintMapping> mappings = entry.getValue();
                String path_spec = entry.getKey();
                for (int c = 0; c < LazyList.size(mappings); ++c) {
                    ConstraintMapping mapping = LazyList.get(mappings, c);
                    if (mapping.getMethod() != null && !mapping.getMethod().equalsIgnoreCase(request.getMethod())) continue;
                    if (pattern != null && !pattern.equals(path_spec)) break block0;
                    pattern = path_spec;
                    constraints = LazyList.add(constraints, mapping.getConstraint());
                }
            }
            return this.check(constraints, this._authenticator, this._userRealm, pathInContext, request, response);
        }
        request.setUserPrincipal(this._notChecked);
        return true;
    }

    private boolean check(LazyList<Constraint> constraints, Authenticator authenticator, UserRealm realm, String pathInContext, Request request, Response response) throws IOException {
        Logger.debug("starting our checks" + request.getAuthType() + "," + request.getRequestURI() + "," + request.isRequestedSessionIdValid() + "," + request.getSession(false));
        int dataConstraint = 0;
        LazyList<String> roles = null;
        boolean unauthenticated = false;
        boolean forbidden = false;
        for (int c = 0; c < LazyList.size(constraints); ++c) {
            Constraint sc = LazyList.get(constraints, c);
            if (dataConstraint > -1 && sc.hasDataConstraint()) {
                if (sc.getDataConstraint() > dataConstraint) {
                    dataConstraint = sc.getDataConstraint();
                }
            } else {
                dataConstraint = -1;
            }
            if (unauthenticated || forbidden) continue;
            if (sc.getAuthenticate()) {
                if (sc.isAnyRole()) {
                    roles = LazyList.add(roles, "*");
                    continue;
                }
                LazyList<String> scr = sc.getRoles();
                if (scr == null || LazyList.size(scr) == 0) {
                    forbidden = true;
                    break;
                }
                if (roles != null && LazyList.get(roles, 0) == "*") continue;
                int r = LazyList.size(scr);
                while (r-- > 0) {
                    roles = LazyList.add(roles, LazyList.get(scr, r));
                }
                continue;
            }
            unauthenticated = true;
        }
        request.setAuthorizedRoles(LazyList.getList(roles, true));
        if (!(!forbidden || authenticator instanceof FormAuthenticator && ((FormAuthenticator)authenticator).isLoginOrErrorPage(pathInContext))) {
            response.sendError(403);
            return false;
        }
        if (dataConstraint > 0) {
            HttpConnection connection = HttpConnection.getCurrentConnection();
            WebConnector connector = connection.getConnector();
            switch (dataConstraint) {
                case 1: {
                    if (connector.isIntegral(request)) break;
                    HttpConnection.doRedirect(request, response, null);
                    return false;
                }
                case 2: {
                    if (connector.isConfidential(request)) break;
                    HttpConnection.doRedirect(request, response, null);
                    return false;
                }
                default: {
                    response.sendError(403, null);
                    return false;
                }
            }
        }
        if (!unauthenticated && roles != null) {
            Principal user = null;
            int r = LazyList.size(roles);
            while (r-- > 0) {
                if (!SIOUserRealm.isGloballyAuthenticated(request, LazyList.get(roles, r))) continue;
                request.setUserPrincipal(this._notChecked);
                return true;
            }
            if (realm == null) {
                response.sendError(403, "No realm for active authentication");
                return false;
            }
            if (request.getAuthType() != null && request.getRemoteUser() != null) {
                user = request.getUserPrincipal();
                if (user == null) {
                    Logger.debug("SH----------->1");
                    try {
                        user = realm.authenticate(request.getRemoteUser(), null, request, request.getAuthType());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (user == null && authenticator != null) {
                    Logger.debug("SH----------->2");
                    try {
                        user = authenticator.authenticate(realm, pathInContext, request, response);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else if (authenticator != null) {
                Logger.debug("SH----------->3");
                try {
                    user = authenticator.authenticate(realm, pathInContext, request, response);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                Logger.debug("SH----------->4");
                response.sendError(500, "Configuration error");
            }
            if (user == null) {
                Logger.debug("SH----------->5");
                return false;
            }
            if (user == __NOBODY) {
                Logger.debug("SH----------->6");
                return true;
            }
            if (user == __NO_USER) {
                Logger.debug("SH----------->7");
                return true;
            }
            if (LazyList.get(roles, 0) != "*") {
                boolean inRole = false;
                int r2 = LazyList.size(roles);
                while (r2-- > 0) {
                    if (!realm.isUserInRole(user, LazyList.get(roles, r2), request)) continue;
                    inRole = true;
                    break;
                }
                if (!inRole) {
                    Logger.debug("AUTH FAILURE: incorrect role for " + user.getName());
                    if ("BASIC".equalsIgnoreCase(authenticator.getAuthMethod())) {
                        ((BasicAuthenticator)authenticator).sendChallenge(realm, response);
                    } else {
                        response.sendError(403, "User not in required role");
                    }
                    return false;
                }
            }
        } else {
            request.setUserPrincipal(this._notChecked);
        }
        return true;
    }

    public static void initSecurityHandler() {
        NativeMethods.setJCREentry(__NO_USER, false);
    }

    public class NotChecked
    implements Principal {
        @Override
        public String getName() {
            return null;
        }

        @Override
        public String toString() {
            return "NOT CHECKED";
        }

        public SecurityHandler getSecurityHandler() {
            return SecurityHandler.this;
        }
    }
}

