/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.servlet;

import com.sun.javacard.file.FileConnection;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.mortbay.util.LazyList;
import org.mortbay.util.MultiMap;
import org.mortbay.util.StringUtil;
import org.mortbay.util.TypeUtil;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class MultiPartFilter
implements Filter {
    @Override
    public void init(FilterConfig filterConfig) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String line;
        HttpServletRequest srequest = (HttpServletRequest)request;
        if (srequest.getContentType() == null || !srequest.getContentType().startsWith("multipart/form-data")) {
            chain.doFilter(request, response);
            return;
        }
        ServletInputStream in = request.getInputStream();
        String content_type = srequest.getContentType();
        String boundary = "--" + this.value(content_type.substring(content_type.indexOf("boundary=")));
        byte[] byteBoundary = (boundary + "--").getBytes(StringUtil.ISO_8859_1);
        MultiMap<Object> params = new MultiMap<Object>();
        byte[] bytes = TypeUtil.readLine(in);
        String string = line = bytes == null ? null : new String(bytes, "UTF-8");
        if (line == null || !line.equals(boundary)) {
            throw new IOException("Missing initial multi part boundary");
        }
        boolean lastPart = false;
        String content_disposition = null;
        while (!lastPart) {
            while ((bytes = TypeUtil.readLine(in)) != null && bytes.length != 0) {
                line = new String(bytes, "UTF-8");
                int c = line.indexOf(58, 0);
                if (c <= 0) continue;
                String key = line.substring(0, c).trim().toLowerCase();
                String value = line.substring(c + 1, line.length()).trim();
                if (!key.equals("content-disposition")) continue;
                content_disposition = value;
            }
            boolean form_data = false;
            if (content_disposition == null) {
                throw new IOException("Missing content-disposition");
            }
            StringTokenizer tok = new StringTokenizer(content_disposition, ";");
            String name = null;
            String filename = null;
            while (tok.hasMoreTokens()) {
                String t = tok.nextToken().trim();
                String tl = t.toLowerCase();
                if (t.startsWith("form-data")) {
                    form_data = true;
                    continue;
                }
                if (tl.startsWith("name=")) {
                    name = this.value(t);
                    continue;
                }
                if (!tl.startsWith("filename=")) continue;
                filename = this.value(t);
            }
            if (!form_data || name == null || name.length() == 0) continue;
            OutputStream out = null;
            FileConnection file = null;
            try {
                if (filename != null && filename.length() > 0) {
                    file = FileConnection.createTempFile("MultiPart", "");
                    out = file.openOutputStream();
                    request.setAttribute(name, file);
                    params.add(name, filename);
                } else {
                    out = new ByteArrayOutputStream();
                }
                int state = -2;
                boolean cr = false;
                boolean lf = false;
                while (true) {
                    int c;
                    int b = 0;
                    while ((c = state != -2 ? state : in.read()) != -1) {
                        state = -2;
                        if (c == 13 || c == 10) {
                            if (c != 13) break;
                            state = in.read();
                            break;
                        }
                        if (b >= 0 && b < byteBoundary.length && c == byteBoundary[b]) {
                            ++b;
                            continue;
                        }
                        if (cr) {
                            out.write(13);
                        }
                        if (lf) {
                            out.write(10);
                        }
                        lf = false;
                        cr = false;
                        if (b > 0) {
                            out.write(byteBoundary, 0, b);
                        }
                        b = -1;
                        out.write(c);
                    }
                    if (b > 0 && b < byteBoundary.length - 2 || b == byteBoundary.length - 1) {
                        if (cr) {
                            out.write(13);
                        }
                        if (lf) {
                            out.write(10);
                        }
                        lf = false;
                        cr = false;
                        out.write(byteBoundary, 0, b);
                        b = -1;
                    }
                    if (b > 0 || c == -1) {
                        if (b == byteBoundary.length) {
                            lastPart = true;
                        }
                        if (state == 10) {
                            state = -2;
                        }
                        break;
                    }
                    if (cr) {
                        out.write(13);
                    }
                    if (lf) {
                        out.write(10);
                    }
                    cr = c == 13;
                    boolean bl = lf = c == 10 || state == 10;
                    if (state != 10) continue;
                    state = -2;
                }
            }
            finally {
                out.close();
            }
            if (file != null) continue;
            bytes = ((ByteArrayOutputStream)out).toByteArray();
            params.add(name, bytes);
        }
        chain.doFilter(new Wrapper(srequest, params), response);
    }

    private String value(String nameEqualsValue) {
        String value = nameEqualsValue.substring(nameEqualsValue.indexOf(61) + 1).trim();
        int i = value.indexOf(59);
        if (i > 0) {
            value = value.substring(0, i);
        }
        if (value.startsWith("\"")) {
            value = value.substring(1, value.indexOf(34, 1));
        } else {
            i = value.indexOf(32);
            if (i > 0) {
                value = value.substring(0, i);
            }
        }
        return value;
    }

    @Override
    public void destroy() {
    }

    private static class Wrapper
    extends HttpServletRequestWrapper {
        String encoding = "UTF-8";
        MultiMap<Object> map;

        public Wrapper(HttpServletRequest request, MultiMap<Object> map) {
            super(request);
            this.map = map;
        }

        @Override
        public int getContentLength() {
            return 0;
        }

        @Override
        public String getParameter(String name) {
            LazyList<Object> lo = this.map.get(name);
            if (lo == null) {
                return null;
            }
            Object o = LazyList.get(lo, 0);
            if (o != null && o instanceof String) {
                return (String)o;
            }
            return null;
        }

        @Override
        public Enumeration<String> getParameterNames() {
            return this.map.keys();
        }

        @Override
        public String[] getParameterValues(String name) {
            Vector<Object> l = this.map.getValues(name);
            if (l == null || l.size() == 0) {
                return new String[0];
            }
            String[] v = new String[l.size()];
            for (int i = 0; i < l.size(); ++i) {
                Object o = l.elementAt(i);
                if (o instanceof byte[]) {
                    try {
                        v[i] = new String((byte[])o, this.encoding);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (!(o instanceof String)) continue;
                v[i] = (String)o;
            }
            return v;
        }

        @Override
        public void setCharacterEncoding(String enc) {
            this.encoding = enc;
        }
    }
}

