/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.util.Vector;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import org.mortbay.util.LazyList;

@TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
public class MultiException
extends Exception {
    private LazyList<Throwable> nested;

    public MultiException() {
        super("Multiple exceptions");
    }

    public void add(Throwable e) {
        if (e instanceof MultiException) {
            MultiException me = (MultiException)e;
            for (int i = 0; i < LazyList.size(me.nested); ++i) {
                this.nested = LazyList.add(this.nested, LazyList.get(me.nested, i));
            }
        } else {
            this.nested = LazyList.add(this.nested, e);
        }
    }

    public int size() {
        return LazyList.size(this.nested);
    }

    public Vector<Throwable> getThrowables() {
        return LazyList.getList(this.nested);
    }

    public Throwable getThrowable(int i) {
        return LazyList.get(this.nested, i);
    }

    public void ifExceptionThrow() throws Exception {
        switch (LazyList.size(this.nested)) {
            case 0: {
                break;
            }
            case 1: {
                Throwable th = LazyList.get(this.nested, 0);
                if (th instanceof Error) {
                    throw (Error)th;
                }
                if (th instanceof Exception) {
                    throw (Exception)th;
                }
            }
            default: {
                throw this;
            }
        }
    }

    public void ifExceptionThrowRuntime() throws Error {
        switch (LazyList.size(this.nested)) {
            case 0: {
                break;
            }
            case 1: {
                Throwable th = LazyList.get(this.nested, 0);
                if (th instanceof Error) {
                    throw (Error)th;
                }
                if (th instanceof RuntimeException) {
                    throw (RuntimeException)th;
                }
                throw new RuntimeException(th.getMessage());
            }
            default: {
                throw new RuntimeException(this.getMessage());
            }
        }
    }

    public void ifExceptionThrowMulti() throws MultiException {
        if (LazyList.size(this.nested) > 0) {
            throw this;
        }
    }

    @Override
    public String toString() {
        if (LazyList.size(this.nested) > 0) {
            return "org.mortbay.util.MultiException" + LazyList.getList(this.nested);
        }
        return "org.mortbay.util.MultiException[]";
    }

    @Override
    public void printStackTrace() {
        super.printStackTrace();
        for (int i = 0; i < LazyList.size(this.nested); ++i) {
            LazyList.get(this.nested, i).printStackTrace();
        }
    }
}

