/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.xml;

import com.sun.javacard.Logger;
import com.sun.javacard.jaxp.javax.xml.parsers.SAXParser;
import com.sun.javacard.jaxp.javax.xml.parsers.SAXParserFactory;
import com.sun.javacard.jaxp.org.xml.sax.Attributes;
import com.sun.javacard.jaxp.org.xml.sax.InputSource;
import com.sun.javacard.jaxp.org.xml.sax.SAXException;
import com.sun.javacard.jaxp.org.xml.sax.SAXParseException;
import com.sun.javacard.jaxp.org.xml.sax.helpers.DefaultHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class XmlParser {
    private SAXParser parser;

    public XmlParser() {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            this.parser = factory.newSAXParser();
        }
        catch (Exception e) {
            Logger.debug(e);
        }
    }

    public XmlParser(boolean validating) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(validating);
            this.parser = factory.newSAXParser();
        }
        catch (Exception e) {
            Logger.debug(e);
            throw new Error(e.toString());
        }
    }

    public synchronized Node parse(InputSource source) throws IOException, SAXException {
        Handler handler = new Handler();
        Logger.debug("parsing: sid=" + source.getSystemId() + ",pid=" + source.getPublicId());
        this.parser.parse(source, (DefaultHandler)handler);
        if (handler._error != null) {
            throw handler._error;
        }
        Node doc = (Node)handler._top.get(0);
        handler.clear();
        return doc;
    }

    public synchronized Node parse(InputStream in) throws IOException, SAXException {
        Handler handler = new Handler();
        this.parser.parse(new InputSource(in), (DefaultHandler)handler);
        if (handler._error != null) {
            throw handler._error;
        }
        Node doc = (Node)handler._top.get(0);
        handler.clear();
        return doc;
    }

    public static class Node {
        Node _parent;
        Vector<Object> _list = new Vector();
        String _tag;
        private Attribute[] _attrs;
        private boolean _lastString = false;
        private String _path;

        Node(Node parent, String tag, Attributes attrs) {
            this._parent = parent;
            this._tag = tag;
            if (attrs != null) {
                this._attrs = new Attribute[attrs.getLength()];
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String name = attrs.getLocalName(i);
                    if (name == null || name.equals("")) {
                        name = attrs.getQName(i);
                    }
                    this._attrs[i] = new Attribute(name, attrs.getValue(i));
                }
            }
        }

        public Iterator<Object> iterator() {
            return this._list.iterator();
        }

        public Node getParent() {
            return this._parent;
        }

        public String getTag() {
            return this._tag;
        }

        public String getPath() {
            if (this._path == null) {
                this._path = this.getParent() != null && this.getParent().getTag() != null ? this.getParent().getPath() + "/" + this._tag : "/" + this._tag;
            }
            return this._path;
        }

        public Attribute[] getAttributes() {
            return this._attrs;
        }

        public String getAttribute(String name) {
            return this.getAttribute(name, null);
        }

        public String getAttribute(String name, String dft) {
            if (this._attrs == null || name == null) {
                return dft;
            }
            for (Attribute element : this._attrs) {
                if (!name.equals(element.getName())) continue;
                return element.getValue();
            }
            return dft;
        }

        public int size() {
            if (this._list != null) {
                return this._list.size();
            }
            return 0;
        }

        public Object get(int i) {
            if (this._list != null) {
                return this._list.elementAt(i);
            }
            return null;
        }

        public Node get(String tag) {
            if (this._list != null) {
                for (int i = 0; i < this._list.size(); ++i) {
                    Object o = this._list.elementAt(i);
                    if (!(o instanceof Node)) continue;
                    Node n = (Node)o;
                    if (!tag.equals(n._tag)) continue;
                    return n;
                }
            }
            return null;
        }

        public void add(int i, Object o) {
            if (this._list == null) {
                this._list = new Vector();
            }
            if (o instanceof String) {
                if (this._lastString) {
                    int last = this._list.size() - 1;
                    this._list.setElementAt((String)this._list.elementAt(last) + o, last);
                } else {
                    this._list.insertElementAt(o, i);
                }
                this._lastString = true;
            } else {
                this._lastString = false;
                this._list.insertElementAt(o, i);
            }
        }

        public void clear() {
            if (this._list != null) {
                this._list.removeAllElements();
            }
            this._list = null;
        }

        public String getString(String tag, boolean tags, boolean trim) {
            Node node = this.get(tag);
            if (node == null) {
                return null;
            }
            String s = node.toString(tags);
            if (s != null && trim) {
                s = s.trim();
            }
            return s;
        }

        public synchronized String toString() {
            return this.toString(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized String toString(boolean tag) {
            StringBuffer buf;
            StringBuffer stringBuffer = buf = new StringBuffer();
            synchronized (stringBuffer) {
                this.toString(buf, tag);
                return buf.toString();
            }
        }

        public synchronized String toString(boolean tag, boolean trim) {
            String s = this.toString(tag);
            if (s != null && trim) {
                s = s.trim();
            }
            return s;
        }

        private synchronized void toString(StringBuffer buf, boolean tag) {
            if (tag) {
                buf.append("<");
                buf.append(this._tag);
                if (this._attrs != null) {
                    for (Attribute element : this._attrs) {
                        buf.append(' ');
                        buf.append(element.getName());
                        buf.append("=\"");
                        buf.append(element.getValue());
                        buf.append("\"");
                    }
                }
            }
            if (this._list != null) {
                if (tag) {
                    buf.append(">");
                }
                for (int i = 0; i < this._list.size(); ++i) {
                    Object o = this._list.elementAt(i);
                    if (o == null) continue;
                    if (o instanceof Node) {
                        ((Node)o).toString(buf, tag);
                        continue;
                    }
                    buf.append(o.toString());
                }
                if (tag) {
                    buf.append("</");
                    buf.append(this._tag);
                    buf.append(">");
                }
            } else if (tag) {
                buf.append("/>");
            }
        }

        public Iterator<Node> iterator(final String tag) {
            return new Iterator<Node>(){
                int c = 0;
                Node _node;

                @Override
                public boolean hasNext() {
                    if (this._node != null) {
                        return true;
                    }
                    while (Node.this._list != null && this.c < Node.this._list.size()) {
                        Object o = Node.this._list.elementAt(this.c);
                        if (o instanceof Node) {
                            Node n = (Node)o;
                            if (tag.equals(n._tag)) {
                                this._node = n;
                                return true;
                            }
                        }
                        ++this.c;
                    }
                    return false;
                }

                @Override
                public Node next() {
                    try {
                        if (this.hasNext()) {
                            Node node = this._node;
                            return node;
                        }
                        throw new NoSuchElementException();
                    }
                    finally {
                        this._node = null;
                        ++this.c;
                    }
                }
            };
        }
    }

    public static class Attribute {
        private String _name;
        private String _value;

        Attribute(String n, String v) {
            this._name = n;
            this._value = v;
        }

        public String getName() {
            return this._name;
        }

        public String getValue() {
            return this._value;
        }
    }

    static class Handler
    extends DefaultHandler {
        Node _top;
        SAXParseException _error;
        private Node _context;

        Handler() {
            this._context = this._top = new Node(null, null, null);
        }

        void clear() {
            this._top = null;
            this._error = null;
            this._context = null;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrs) {
            String name = uri == null || uri.equals("") ? qName : localName;
            Node node = new Node(this._context, name, attrs);
            this._context.add(this._context.size(), node);
            this._context = node;
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            this._context = this._context._parent;
        }

        @Override
        public void ignorableWhitespace(char[] buf, int offset, int len) {
        }

        @Override
        public void characters(char[] buf, int offset, int len) {
            this._context.add(this._context.size(), new String(buf, offset, len));
        }

        @Override
        public void warning(SAXParseException ex) {
            Logger.debug(ex);
            Logger.debug("WARNING@" + this.getLocationString(ex) + " : " + ex.toString());
        }

        @Override
        public void error(SAXParseException ex) throws SAXException {
            if (this._error == null) {
                this._error = ex;
            }
            Logger.debug(ex);
            Logger.debug("ERROR@" + this.getLocationString(ex) + " : " + ex.toString());
        }

        @Override
        public void fatalError(SAXParseException ex) throws SAXException {
            this._error = ex;
            Logger.debug(ex);
            Logger.debug("FATAL@" + this.getLocationString(ex) + " : " + ex.toString());
            throw ex;
        }

        private String getLocationString(SAXParseException ex) {
            return ex.getSystemId() + " line:" + ex.getLineNumber() + " col:" + ex.getColumnNumber();
        }
    }
}

