/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.components.caputils.instructions;

import com.sun.javacard.components.caputils.ClassConstantPool;
import com.sun.javacard.components.caputils.Util;
import com.sun.javacard.components.caputils.instructions.Instruction;
import com.sun.javacard.components.caputils.instructions.JavaInstruction;
import com.sun.javacard.offcardverifier.Instr;
import java.util.Vector;

public class JCPushInstr
extends Instruction {
    private Vector<Integer> argVector = new Vector();

    public JCPushInstr(Instr jcInstruction, ClassConstantPool cp) {
        super(jcInstruction);
        Object argArray = null;
        switch (jcInstruction.opcode) {
            case 16: 
            case 18: {
                this.pushByte(new Integer(jcInstruction.arg & 0xFF));
                break;
            }
            case 17: 
            case 19: {
                this.pushShort(jcInstruction.arg);
                break;
            }
            case 20: {
                this.pushInteger(jcInstruction.arg, cp);
            }
        }
    }

    public JCPushInstr(int value, ClassConstantPool cp) {
        super(null);
        Object argArray = null;
        if (value >= -128 && value < 128) {
            this.pushByte(value);
        } else if (value >= Short.MIN_VALUE && value < 32768) {
            this.pushShort(value);
        } else {
            this.pushInteger(value, cp);
        }
    }

    private void pushByte(int value) {
        this.argVector.add(new Integer(value));
        this.javaInstructions.add(new JavaInstruction(16, this.argVector));
    }

    private void pushShort(int value) {
        byte[] argArray = Util.getShortBytes((short)value);
        this.argVector.add(new Integer(argArray[0] & 0xFF));
        this.argVector.add(new Integer(argArray[1] & 0xFF));
        this.javaInstructions.add(new JavaInstruction(17, this.argVector));
    }

    private void pushInteger(int value, ClassConstantPool cp) {
        int cpIndex = cp.addInteger(value);
        if (cpIndex < 255) {
            this.argVector.add(new Integer(cpIndex & 0xFF));
            this.javaInstructions.add(new JavaInstruction(18, this.argVector));
        } else {
            byte[] argArray = Util.getShortBytes((short)cpIndex);
            this.argVector.add(new Integer(argArray[0] & 0xFF));
            this.argVector.add(new Integer(argArray[1] & 0xFF));
            this.javaInstructions.add(new JavaInstruction(19, this.argVector));
        }
    }
}

