/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter;

import com.sun.javacard.ToolsVersion;
import com.sun.javacard.converter.util.Names;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.exportfile.EfExportFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintWriter;

public class Exp2Text {
    public static void main(String[] args) {
        int i;
        String class_dir = null;
        String output_dir = null;
        Notifier.newLine();
        Notifier.outPrintLn(ToolsVersion.getToolName(5) + ToolsVersion.getVersion(5));
        Notifier.outPrintLn(ToolsVersion.getCopyrightBanner());
        Notifier.newLine();
        if (args.length == 0) {
            Exp2Text.usage();
            System.exit(0);
        }
        for (i = 0; i < args.length; ++i) {
            if (args[i].equals("-classdir")) {
                class_dir = args[++i];
                continue;
            }
            if (args[i].equals("-d")) {
                output_dir = args[++i];
                continue;
            }
            if (args[i].equals("-help")) {
                Exp2Text.usage();
                System.exit(0);
                continue;
            }
            if (!args[i].startsWith("-")) break;
            Notifier.error("profile.0", args[i]);
            Exp2Text.outputStatus();
            System.exit(1);
            break;
        }
        if (i == args.length) {
            Notifier.error("exp2text.6");
            Exp2Text.outputStatus();
            System.exit(1);
        }
        if (class_dir == null) {
            class_dir = System.getProperty("user.dir");
        }
        if (output_dir == null) {
            output_dir = class_dir;
        }
        while (i < args.length) {
            String package_name = args[i].replace('.', '/');
            String ef_name = Names.getExportFileName(package_name);
            String ef_text_name = ef_name.replace('.', '_') + ".tex";
            char c = File.separatorChar;
            EfExportFile export_file = new EfExportFile();
            try {
                Object[] arguments;
                String ef_path = class_dir + c + args[i].replace('.', c) + c + "javacard" + c + ef_name;
                File ef_file = new File(ef_path);
                if (!ef_file.exists()) {
                    arguments = new String[]{ef_name, class_dir + c + args[i].replace('.', c) + c + "javacard"};
                    Notifier.error("exp2text.0", arguments);
                    Exp2Text.outputStatus();
                    System.exit(1);
                }
                if (ef_file.isDirectory()) {
                    arguments = new String[]{ef_name, class_dir + c + args[i].replace('.', c) + c + "javacard"};
                    Notifier.error("exp2text.1", arguments);
                    Exp2Text.outputStatus();
                    System.exit(1);
                }
                if (!ef_file.canRead()) {
                    Notifier.error("exp2text.2", ef_name);
                    Exp2Text.outputStatus();
                    System.exit(1);
                }
                DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(ef_file)));
                export_file.parse(dis);
                dis.close();
                export_file.resolve();
            }
            catch (Exception e) {
                Notifier.error("exp2text.4", ef_name);
                Exp2Text.outputStatus();
                System.exit(1);
            }
            try {
                File ef_out_file;
                File ef_out_path = new File(output_dir + c + args[i].replace('.', c) + c + "javacard");
                if (!ef_out_path.exists()) {
                    ef_out_path.mkdirs();
                }
                if ((ef_out_file = new File(ef_out_path, ef_text_name)).exists() && !ef_out_file.canWrite()) {
                    Notifier.error("exp2text.3", ef_text_name);
                    Exp2Text.outputStatus();
                    System.exit(1);
                }
                PrintWriter pw = new PrintWriter(new BufferedOutputStream(new FileOutputStream(ef_out_file)));
                export_file.toText(pw);
                pw.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                Notifier.error("exp2text.5", ef_text_name);
                Exp2Text.outputStatus();
                System.exit(1);
            }
            ++i;
        }
        Exp2Text.outputStatus();
        System.exit(0);
    }

    public static void usage() {
        for (int i = 0; i < 7; ++i) {
            Notifier.out("exp2textusage." + i);
        }
    }

    public static void outputStatus() {
        Notifier.newLine();
        Object[] args = new String[]{String.valueOf(Notifier.getErrorCount()), String.valueOf(Notifier.getWarningCount())};
        Notifier.out("out.1", args);
    }
}

