/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.ToolsVersion;
import com.sun.javacard.offcardverifier.AbstrInterp;
import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.Classref;
import com.sun.javacard.offcardverifier.DebugComponent;
import com.sun.javacard.offcardverifier.ImportComponent;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.VerifierError;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class Verifier {
    static int verbose = 1;
    static String packageName = null;
    static boolean printTrace = false;

    public static void main(String[] argv) {
        int i;
        boolean banner = true;
        List<String> argsList = Arrays.asList(argv);
        if (argsList.contains("-C") || argsList.contains("--commandoptionsfile")) {
            if (argv.length == 2 && (argv[0].equals("-C") || argv[0].equals("--commandoptionsfile"))) {
                try {
                    FileInputStream fs = new FileInputStream(new File(argv[1]).getCanonicalPath());
                    argv = Verifier.getArgsFromFile(fs);
                }
                catch (Exception e) {
                    System.err.println(e);
                    System.exit(1);
                }
            } else {
                Verifier.printUsageAndExit();
            }
        }
        for (i = 0; i < argv.length && argv[i].length() > 0 && argv[i].charAt(0) == '-'; ++i) {
            String s = argv[i];
            if (s.equals("-verbose")) {
                ++verbose;
                continue;
            }
            if (s.equals("-nobanner")) {
                banner = false;
                continue;
            }
            if (s.equals("-nowarn")) {
                VerifierError.noWarn = true;
                continue;
            }
            if (s.equals("-help")) {
                Verifier.printUsageAndExit();
                continue;
            }
            if (s.equals("-version")) {
                Messages.println("Main.3");
                Messages.exactPrintLn(ToolsVersion.getCopyrightBanner());
                System.exit(2);
                continue;
            }
            if (s.equals("-package") && i + 1 < argv.length) {
                packageName = argv[++i];
                continue;
            }
            Verifier.printUsageAndExit();
        }
        if (i == argv.length) {
            Verifier.printUsageAndExit();
        }
        Messages.println("Main.3", ToolsVersion.getVersion(2));
        Messages.exactPrintLn(ToolsVersion.getCopyrightBanner());
        boolean foundCapFile = false;
        while (i < argv.length) {
            try {
                String s = argv[i];
                File f = new File(s);
                if (s.endsWith(".exp")) {
                    ImportComponent.readExportFile(f);
                } else {
                    if (verbose >= 1) {
                        Messages.println("Main.4", s);
                    }
                    Messages.numWarning = 0;
                    Cap.readComponents(f);
                    Verifier.consistencyChecks();
                    if (verbose >= 1) {
                        Messages.println("Main.5", Messages.numWarning);
                    }
                    foundCapFile = true;
                }
            }
            catch (VerifierError e) {
                Messages.printSevere("Main.2", Messages.numWarning, e.getMessage(), Messages.format("Main.6"));
                System.exit(2);
            }
            ++i;
        }
        if (!foundCapFile && verbose >= 1) {
            Verifier.printUsageAndExit();
        }
    }

    private static void printUsageAndExit() {
        Messages.printTo(System.err);
        Messages.println("Main.1");
        System.exit(2);
    }

    private static void consistencyChecks() {
        Cap.Header.verify();
        if (Cap.debugComponentDataBuffer != null) {
            if (Cap.Header.minorVersion() == 2) {
                Cap.Debug = new DebugComponent(Cap.debugComponentDataBuffer);
            } else {
                Cap.addCustomComponent(Cap.debugComponentDataBuffer, Cap.debugComponentTag);
            }
        }
        Cap.Directory.verify();
        Cap.Descriptor.verify();
        Cap.Import.verify();
        if (Cap.Export != null) {
            Cap.Export.findExportFile();
        }
        Cap.Import.initialize();
        Classref.initialize();
        AbstrInterp.initialize();
        Cap.ConstantPool.verify();
        Cap.Class.verify();
        Cap.Method.verify();
        Cap.StaticField.verify();
        Cap.ReferenceLocation.verify();
        if (Cap.Applet != null) {
            Cap.Applet.verify();
        }
        if (Cap.Export != null) {
            Cap.Export.verify();
        }
        Cap.Import.checkUnreferencedPackages();
        Cap.Header.checkIntFlag();
        if (Cap.Debug != null && Cap.capMinorVersion == 2) {
            Cap.Debug.verify();
        }
    }

    public static void verifyCap(FileInputStream cap, String packageName, Vector<File> exportFiles) throws Exception {
        Verifier.packageName = packageName;
        ImportComponent.resetExportFileList();
        for (int i = 0; i < exportFiles.size(); ++i) {
            ImportComponent.readExportFile(exportFiles.elementAt(i));
        }
        Cap.readComponents(cap);
        Verifier.consistencyChecks();
    }

    private static String[] getArgsFromFile(FileInputStream file) {
        BufferedReader r = new BufferedReader(new InputStreamReader(file));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = r.readLine()) != null) {
                sb.append(line + "\n");
            }
            r.close();
        }
        catch (IOException ioe) {
            System.err.println(ioe);
            System.exit(1);
        }
        ArrayList<String> args = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(sb.toString());
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            args.add(s);
        }
        String[] argsArr = new String[args.size()];
        return args.toArray(argsArr);
    }
}

