/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.rmiclientlib;

import com.sun.javacard.clientlib.CardAccessor;
import com.sun.javacard.javax.smartcard.rmiclient.CardObjectFactory;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.Operation;
import java.rmi.server.RemoteCall;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteRef;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class JCRemoteRefImpl
implements RemoteRef,
InvocationHandler {
    private static ResourceBundle _messages = PropertyResourceBundle.getBundle("com/sun/javacard/rmiclientlib/MessagesBundle");
    private static final byte RMI_CLA = -128;
    private static final short RMI_VERSION = 514;
    private short objID;
    private String a_string;
    private CardAccessor ca;
    private CardObjectFactory factory;

    public JCRemoteRefImpl(short objID, String a_string, CardAccessor ca, CardObjectFactory cOF) {
        this.objID = objID;
        this.a_string = a_string;
        this.ca = ca;
        this.factory = cOF;
    }

    @Override
    public String getRefClass(ObjectOutput objectOutput) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object invoke(Remote remote, Method method, Object[] params, long unused) throws IOException, RemoteException, Exception {
        String name = method.getName();
        String descriptor = this.getDescriptor(method);
        short methodID = JCRemoteRefImpl.computeShortHash(this.a_string + name + descriptor);
        int Lc = JCRemoteRefImpl.computeLc(method, params);
        byte[] c_apdu = new byte[Lc + 6];
        c_apdu[0] = -128;
        c_apdu[1] = this.factory.getINSByte();
        JCRemoteRefImpl.writeShort((short)514, c_apdu, 2);
        c_apdu[4] = (byte)(Lc & 0xFF);
        JCRemoteRefImpl.writeShort(this.objID, c_apdu, 5);
        JCRemoteRefImpl.writeShort(methodID, c_apdu, 7);
        JCRemoteRefImpl.writeParams(method, params, c_apdu, 9);
        c_apdu[Lc + 5] = 127;
        byte[] r_apdu = this.ca.exchangeAPDU(c_apdu);
        return this.parseAPDU(r_apdu, method);
    }

    @Override
    public int remoteHashCode() {
        return 0;
    }

    @Override
    public String remoteToString() {
        return "Card_object_" + this.objID;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RemoteCall newCall(RemoteObject remoteObject, Operation[] operation, int param, long param3) throws RemoteException {
        throw new RemoteException(_messages.getString("deprecated.1"));
    }

    @Override
    public void invoke(RemoteCall remoteCall) throws Exception {
        throw new RemoteException(_messages.getString("deprecated.1"));
    }

    @Override
    public boolean remoteEquals(RemoteRef remoteRef) {
        try {
            JCRemoteRefImpl other = (JCRemoteRefImpl)remoteRef;
            return this.ca == other.ca && this.objID == other.objID;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void done(RemoteCall remoteCall) throws RemoteException {
        throw new RemoteException(_messages.getString("deprecated.1"));
    }

    private String getDescriptor(Method method) {
        Class<?>[] params = method.getParameterTypes();
        Class<?> ret_type = method.getReturnType();
        StringBuffer descriptor = new StringBuffer("(");
        for (int i = 0; i < params.length; ++i) {
            String pName = params[i].getName();
            if ("boolean".equals(pName)) {
                descriptor.append("Z");
                continue;
            }
            if ("byte".equals(pName)) {
                descriptor.append("B");
                continue;
            }
            if ("short".equals(pName)) {
                descriptor.append("S");
                continue;
            }
            if ("int".equals(pName)) {
                descriptor.append("I");
                continue;
            }
            descriptor.append(pName);
        }
        descriptor.append(")");
        String rName = ret_type.getName();
        if ("boolean".equals(rName)) {
            descriptor.append("Z");
        } else if ("byte".equals(rName)) {
            descriptor.append("B");
        } else if ("short".equals(rName)) {
            descriptor.append("S");
        } else if ("int".equals(rName)) {
            descriptor.append("I");
        } else if ("void".equals(rName)) {
            descriptor.append("V");
        } else if ("[Z".equals(rName)) {
            descriptor.append("[Z");
        } else if ("[B".equals(rName)) {
            descriptor.append("[B");
        } else if ("[S".equals(rName)) {
            descriptor.append("[S");
        } else if ("[I".equals(rName)) {
            descriptor.append("[I");
        } else {
            descriptor.append("L");
            descriptor.append(rName.replace('.', '/'));
            descriptor.append(";");
        }
        return descriptor.toString();
    }

    private static final short computeShortHash(String s) {
        int hash = 0;
        try {
            MessageDigest sha = MessageDigest.getInstance("SHA");
            byte[] value = s.getBytes("UTF-8");
            byte[] hasharray = sha.digest(value);
            hash = hasharray.length >= 2 ? (int)((short)(hasharray[0] << 8 | hasharray[1] & 0xFF)) : -1;
        }
        catch (IOException ignore) {
            hash = -1;
        }
        catch (NoSuchAlgorithmException complain) {
            throw new SecurityException(complain.getMessage());
        }
        return (short)hash;
    }

    private static int computeLc(Method method, Object[] values) {
        int Lc = 4;
        Class<?>[] params = method.getParameterTypes();
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            String pName = params[i].getName();
            if ("boolean".equals(pName)) {
                ++Lc;
                continue;
            }
            if ("byte".equals(pName)) {
                ++Lc;
                continue;
            }
            if ("short".equals(pName)) {
                Lc += 2;
                continue;
            }
            if ("int".equals(pName)) {
                Lc += 4;
                continue;
            }
            if (values[i] == null) {
                ++Lc;
                continue;
            }
            if ("[Z".equals(pName)) {
                ++Lc;
                Lc += ((boolean[])values[i]).length;
                continue;
            }
            if ("[B".equals(pName)) {
                ++Lc;
                Lc += ((byte[])values[i]).length;
                continue;
            }
            if ("[S".equals(pName)) {
                ++Lc;
                Lc += ((short[])values[i]).length * 2;
                continue;
            }
            if (!"[I".equals(pName)) continue;
            ++Lc;
            Lc += ((int[])values[i]).length * 4;
        }
        return Lc;
    }

    private static void writeBoolean(boolean data, byte[] buffer, int offset) {
        buffer[offset] = data ? (byte)1 : 0;
    }

    private static void writeByte(byte data, byte[] buffer, int offset) {
        buffer[offset] = data;
    }

    private static void writeShort(short data, byte[] buffer, int offset) {
        buffer[offset] = (byte)(data >> 8);
        buffer[(short)(offset + 1)] = (byte)data;
    }

    private static void writeInt(int data, byte[] buffer, int offset) {
        buffer[offset] = (byte)(data >> 24);
        buffer[(short)(offset + 1)] = (byte)(data >> 16);
        buffer[(short)(offset + 2)] = (byte)(data >> 8);
        buffer[(short)(offset + 3)] = (byte)data;
    }

    private static void writeParams(Method method, Object[] values, byte[] buffer, int offset) {
        Class<?>[] params = method.getParameterTypes();
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            int j;
            int len;
            String pName = params[i].getName();
            if ("boolean".equals(pName)) {
                boolean data = (Boolean)values[i];
                JCRemoteRefImpl.writeBoolean(data, buffer, offset);
                ++offset;
                continue;
            }
            if ("byte".equals(pName)) {
                byte data = (Byte)values[i];
                JCRemoteRefImpl.writeByte(data, buffer, offset);
                ++offset;
                continue;
            }
            if ("short".equals(pName)) {
                short data = (Short)values[i];
                JCRemoteRefImpl.writeShort(data, buffer, offset);
                offset += 2;
                continue;
            }
            if ("int".equals(pName)) {
                int data = (Integer)values[i];
                JCRemoteRefImpl.writeInt(data, buffer, offset);
                offset += 4;
                continue;
            }
            if (values[i] == null) {
                buffer[offset] = -1;
                ++offset;
                continue;
            }
            if ("[Z".equals(pName)) {
                boolean[] data = (boolean[])values[i];
                len = data.length;
                buffer[offset] = (byte)len;
                ++offset;
                for (j = 0; j < len; ++j) {
                    JCRemoteRefImpl.writeBoolean(data[j], buffer, offset);
                    ++offset;
                }
                continue;
            }
            if ("[B".equals(pName)) {
                byte[] data = (byte[])values[i];
                len = data.length;
                buffer[offset] = (byte)len;
                ++offset;
                for (j = 0; j < len; ++j) {
                    JCRemoteRefImpl.writeByte(data[j], buffer, offset);
                    ++offset;
                }
                continue;
            }
            if ("[S".equals(pName)) {
                short[] data = (short[])values[i];
                len = data.length;
                buffer[offset] = (byte)len;
                ++offset;
                for (j = 0; j < len; ++j) {
                    JCRemoteRefImpl.writeShort(data[j], buffer, offset);
                    offset += 2;
                }
                continue;
            }
            if (!"[I".equals(pName)) continue;
            int[] data = (int[])values[i];
            len = data.length;
            buffer[offset] = (byte)len;
            ++offset;
            for (j = 0; j < len; ++j) {
                JCRemoteRefImpl.writeInt(data[j], buffer, offset);
                offset += 4;
            }
        }
    }

    private Object parseAPDU(byte[] buffer, Method method) throws Exception {
        int SW = (buffer[0] & 0xFF) << 8 | buffer[1] & 0xFF;
        if (SW != 36864) {
            throw new RemoteException(_messages.getString("fail.1") + Integer.toHexString(0xFFFF & SW));
        }
        int tag_offset = 2;
        Class<?> ret_type = method.getReturnType();
        return this.factory.getObject(buffer, 2, ret_type, this.ca);
    }

    @Override
    public Object invoke(Object obj, Method method, Object[] params) throws IOException, RemoteException, Throwable {
        return this.invoke(null, method, params, 0L);
    }
}

