/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.scriptgen;

import com.sun.javacard.ToolsVersion;
import com.sun.javacard.scriptgen.CAP;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class Main {
    static final int SUCCESS = 0;
    static final int FAILURE = 1;
    static String pkgName;
    static String capPath;
    static String scriptPath;
    static String logPath;
    static boolean nobanner;
    static boolean noBeginEnd;
    static Object[] version;
    static PrintWriter scriptWriter;
    static PrintWriter logWriter;
    protected static ResourceBundle msg;

    public static void main(String[] stringArray) {
        try {
            if (Main.parseArgs(stringArray) == 0) {
                Main.processCAP(capPath);
            }
            Main.terminate();
        }
        catch (Exception exception) {
            System.exit(1);
        }
        System.exit(0);
    }

    static void processCAP(String string) {
        CAP cAP;
        try {
            cAP = new CAP(string, logWriter, msg, pkgName);
        }
        catch (Exception exception) {
            return;
        }
        if (cAP.verifyCAP() == 0) {
            cAP.genScript(scriptWriter, noBeginEnd);
        }
        if (!nobanner) {
            System.out.println(msg.getString("Main.02"));
        }
    }

    static int parseArgs(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-o") && stringArray.length > n + 1) {
                scriptPath = stringArray[++n];
            } else if (stringArray[n].equals("-package") && stringArray.length > n + 1) {
                pkgName = stringArray[++n];
            } else {
                if (stringArray[n].equals("-help")) {
                    Main.usage();
                    return 1;
                }
                if (stringArray[n].equals("-version")) {
                    Main.banner();
                    return 1;
                }
                if (stringArray[n].equals("-nobanner")) {
                    nobanner = true;
                } else if (stringArray[n].equals("-nobeginend")) {
                    noBeginEnd = true;
                } else {
                    if (stringArray[n].startsWith("-")) {
                        Object[] objectArray = new Object[]{stringArray[n]};
                        logWriter.println(MessageFormat.format(msg.getString("Main.badArg"), objectArray));
                        Main.banner();
                        return 1;
                    }
                    capPath = stringArray[n];
                }
            }
            ++n;
        }
        if (logPath != null) {
            try {
                logWriter = new PrintWriter(new FileOutputStream(logPath));
            }
            catch (Exception exception) {
                logWriter.println(exception);
                return 1;
            }
        }
        if (capPath == null) {
            logWriter.println(msg.getString("Main.capPath"));
            Main.usage();
            return 1;
        }
        try {
            File file = new File(capPath);
            if (!file.canRead()) {
                Object[] objectArray = new Object[]{capPath};
                logWriter.println(MessageFormat.format(msg.getString("Main.access"), objectArray));
                return 1;
            }
        }
        catch (Exception exception) {
            logWriter.println(exception);
            return 1;
        }
        if (scriptPath != null) {
            try {
                scriptWriter = new PrintWriter(new FileOutputStream(scriptPath));
            }
            catch (Exception exception) {
                logWriter.println(exception);
                return 1;
            }
        }
        Main.banner();
        return 0;
    }

    static void terminate() {
        logWriter.flush();
        scriptWriter.flush();
    }

    private static void usage() {
        logWriter.println(msg.getString("Main.10"));
        logWriter.println(msg.getString("Main.11"));
        int n = 12;
        while (n < 18) {
            logWriter.println(msg.getString("Main." + n));
            ++n;
        }
    }

    private static void banner() {
        if (nobanner) {
            return;
        }
        System.out.println(ToolsVersion.getProductName() + " " + ToolsVersion.getToolName(3) + ", " + ToolsVersion.getVersionString() + " " + ToolsVersion.getVersion(3));
        System.out.println(ToolsVersion.getCopyrightBanner());
    }

    static {
        version = new Object[]{new Integer(0), new Integer(11)};
        scriptWriter = new PrintWriter(System.out, true);
        logWriter = new PrintWriter(System.err, true);
        msg = PropertyResourceBundle.getBundle("com/sun/javacard/scriptgen/MessagesBundle");
    }
}

