/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.clientsamples.photocardclient;

import com.sun.javacard.clientlib.ApduIOCardAccessor;
import com.sun.javacard.clientlib.CardAccessor;
import com.sun.javacard.rmiclientlib.JCRMIConnect;
import com.sun.javacard.samples.photocard.PhotoCard;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.security.MessageDigest;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javacard.framework.UserException;

public class PhotoCardClient {
    private static ResourceBundle msg;
    private static final byte[] PHOTO_CARD_AID;

    public static void putPhotoInCard(PhotoCard photoCard, byte[] byArray) throws Exception {
        short s = photoCard.requestPhotoStorage((short)byArray.length);
        System.out.println(MessageFormat.format(msg.getString("msg10"), new Integer(s)));
        for (int i = 0; i < byArray.length; i += 96) {
            byte[] byArray2 = new byte[96];
            if (byArray.length - i >= 96) {
                System.arraycopy(byArray, i, byArray2, 0, 96);
                photoCard.loadPhoto(s, byArray2, (short)96, (short)i, true);
                continue;
            }
            System.arraycopy(byArray, i, byArray2, 0, (short)(byArray.length - i));
            photoCard.loadPhoto(s, byArray2, (short)(byArray.length - i), (short)i, false);
        }
    }

    public static byte[] recoverPhoto(PhotoCard photoCard, short s) throws Exception {
        int n = photoCard.getPhotoSize(s);
        System.out.println(MessageFormat.format(msg.getString("msg09"), new Integer(n)));
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; i += 96) {
            byte[] byArray2 = null;
            if (n - i >= 96) {
                byArray2 = photoCard.getPhoto(s, (short)i, (short)96);
                System.arraycopy(byArray2, 0, byArray, i, 96);
                continue;
            }
            byArray2 = photoCard.getPhoto(s, (short)i, (short)(n - i));
            System.arraycopy(byArray2, 0, byArray, i, (short)(n - i));
        }
        return byArray;
    }

    public static void verifyPhoto(PhotoCard photoCard, short s, byte[] byArray) throws Exception {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (Exception exception) {
            System.out.println(msg.getString("msg14"));
            return;
        }
        byte[] byArray2 = messageDigest.digest(byArray);
        short s2 = photoCard.verifyPhoto(s, byArray2, (short)0);
        switch (s2) {
            case 0: {
                System.out.println(msg.getString("msg21"));
                break;
            }
            case 28944: {
                System.out.println(msg.getString("msg16"));
                break;
            }
            case 29218: {
                System.out.println(msg.getString("msg17"));
                break;
            }
            case 29491: {
                System.out.println(msg.getString("msg18"));
                break;
            }
            case 29764: {
                System.out.println(msg.getString("msg19"));
                break;
            }
            default: {
                System.out.println(msg.getString("msg20"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws RemoteException {
        msg = ResourceBundle.getBundle("com/sun/javacard/clientsamples/photocardclient/MessagesBundle");
        ApduIOCardAccessor apduIOCardAccessor = null;
        try {
            int n;
            Closeable closeable;
            Object object;
            Object object2;
            int n2;
            if (stringArray.length < 1 || stringArray.length > 4) {
                System.out.println(msg.getString("msg00"));
            }
            System.out.println(msg.getString("msg01"));
            apduIOCardAccessor = new ApduIOCardAccessor();
            JCRMIConnect jCRMIConnect = new JCRMIConnect((CardAccessor)apduIOCardAccessor);
            if (stringArray.length == 0) {
                jCRMIConnect.selectApplet(PHOTO_CARD_AID, (byte)0);
            } else {
                jCRMIConnect.selectApplet(PHOTO_CARD_AID, (byte)16);
            }
            PhotoCard photoCard = (PhotoCard)jCRMIConnect.getInitialReference();
            if (photoCard == null) {
                throw new Exception(msg.getString("msg02"));
            }
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                object2 = stringArray[n2];
                object = null;
                System.out.println(MessageFormat.format(msg.getString("msg03"), object2));
                closeable = new FileInputStream(new File((String)object2));
                n = ((FileInputStream)closeable).available();
                System.out.println(MessageFormat.format(msg.getString("msg04"), new Integer(n)));
                object = new byte[n];
                int n3 = ((FileInputStream)closeable).read((byte[])object);
                ((FileInputStream)closeable).close();
                System.out.println(msg.getString("msg05"));
                PhotoCardClient.putPhotoInCard(photoCard, (byte[])object);
            }
            System.out.println(msg.getString("msg06"));
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                System.out.println(MessageFormat.format(msg.getString("msg07"), new Integer(n2 + 1)));
                object2 = PhotoCardClient.recoverPhoto(photoCard, (short)(n2 + 1));
                object = stringArray[n2];
                System.out.println(MessageFormat.format(msg.getString("msg08"), new Integer(((Object)object2).length), object));
                System.out.println(MessageFormat.format(msg.getString("msg12"), object));
                closeable = new FileOutputStream(new File((String)object + ".recv"));
                ((FileOutputStream)closeable).write((byte[])object2);
                ((OutputStream)closeable).flush();
                ((FileOutputStream)closeable).close();
            }
            System.out.println("");
            System.out.println(msg.getString("msg13"));
            System.out.println("");
            String string = stringArray[0];
            object2 = null;
            System.out.println(MessageFormat.format(msg.getString("msg03"), string));
            object = new FileInputStream(new File(string));
            int n4 = ((FileInputStream)object).available();
            object2 = new byte[n4];
            n = ((FileInputStream)object).read((byte[])object2);
            ((FileInputStream)object).close();
            System.out.println(msg.getString("msg15"));
            PhotoCardClient.verifyPhoto(photoCard, (short)1, (byte[])object2);
        }
        catch (UserException userException) {
            if (userException.getReason() == 28944) {
                System.out.println(msg.getString("msg14"));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (apduIOCardAccessor != null) {
                    apduIOCardAccessor.closeCard();
                }
            }
            catch (Exception exception) {}
        }
    }

    static {
        PHOTO_CARD_AID = new byte[]{-96, 0, 0, 0, 98, 3, 1, 12, 7, 1};
    }
}

