/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.classfile.constants;

import com.sun.javacard.classfile.constants.JConstantClass;
import com.sun.javacard.classfile.constants.JConstantDouble;
import com.sun.javacard.classfile.constants.JConstantFieldRef;
import com.sun.javacard.classfile.constants.JConstantFloat;
import com.sun.javacard.classfile.constants.JConstantInteger;
import com.sun.javacard.classfile.constants.JConstantInterfaceMethodRef;
import com.sun.javacard.classfile.constants.JConstantLong;
import com.sun.javacard.classfile.constants.JConstantMethodRef;
import com.sun.javacard.classfile.constants.JConstantNameAndType;
import com.sun.javacard.classfile.constants.JConstantPool;
import com.sun.javacard.classfile.constants.JConstantString;
import com.sun.javacard.classfile.constants.JConstantUtf8;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintWriter;

public abstract class JConstant {
    public static final int CONSTANT_UTF8 = 1;
    public static final int CONSTANT_INTEGER = 3;
    public static final int CONSTANT_FLOAT = 4;
    public static final int CONSTANT_LONG = 5;
    public static final int CONSTANT_DOUBLE = 6;
    public static final int CONSTANT_CLASS = 7;
    public static final int CONSTANT_STRING = 8;
    public static final int CONSTANT_FIELDREF = 9;
    public static final int CONSTANT_METHODREF = 10;
    public static final int CONSTANT_INTERFACE_METHODREF = 11;
    public static final int CONSTANT_NAME_AND_TYPE = 12;
    protected JConstantPool cp;
    protected boolean resolved = false;

    public JConstant(JConstantPool cp) {
        this.cp = cp;
    }

    public static final JConstant create(int tag, JConstantPool cp) {
        switch (tag) {
            case 7: {
                return new JConstantClass(cp);
            }
            case 1: {
                return new JConstantUtf8(cp);
            }
            case 9: {
                return new JConstantFieldRef(cp);
            }
            case 10: {
                return new JConstantMethodRef(cp);
            }
            case 11: {
                return new JConstantInterfaceMethodRef(cp);
            }
            case 12: {
                return new JConstantNameAndType(cp);
            }
            case 8: {
                return new JConstantString(cp);
            }
            case 3: {
                return new JConstantInteger(cp);
            }
            case 4: {
                return new JConstantFloat(cp);
            }
            case 5: {
                return new JConstantLong(cp);
            }
            case 6: {
                return new JConstantDouble(cp);
            }
        }
        return null;
    }

    public void dump(PrintWriter w) {
    }

    public abstract void parse(DataInputStream var1) throws IOException;

    public void resolve() {
        this.resolved = true;
    }
}

