/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter;

import com.sun.javacard.converter.ConversionProfile;
import com.sun.javacard.converter.Converter;
import com.sun.javacard.converter.ConverterException;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.OptionParser;
import com.sun.javacard.converter.util.Names;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.jcasm.Globals;
import com.sun.javacard.jcasm.cap.CapgenWrapper;
import java.io.File;

public class ConverterHarness {
    private ConversionProfile conversion_profile;
    private boolean delateJCA = false;

    private void cleanup() {
        if (this.conversion_profile.deleteJCA) {
            String jca_file_name = Names.getJcaFileName(this.conversion_profile.package_profile.package_name);
            File jca_file = new File(this.conversion_profile.getFullOutputPath(), jca_file_name);
            jca_file.delete();
            if (this.conversion_profile.debug) {
                String debug_component_name = new String("debug.cap");
                File debug_component_file = new File(this.conversion_profile.getFullOutputPath(), debug_component_name);
                debug_component_file.delete();
            }
        }
    }

    private void convert(String[] args) {
        try {
            this.conversion_profile = new ConversionProfile();
            OptionParser option_parser = new OptionParser(args, this.conversion_profile);
            option_parser.parse();
            Notifier.newLine();
            Notifier.out("converter.version", "1.2");
            Notifier.out("converter.copyright");
            Notifier.newLine();
            this.generateJCA();
            try {
                this.generateCAP();
            }
            catch (Exception exception) {
                Notifier.out("converter.5");
            }
            this.cleanup();
            Notifier.newLine();
            Object[] arguments = new Object[]{String.valueOf(Notifier.getErrorCount() + Globals.errors), String.valueOf(Notifier.getWarningCount() + Globals.warnings)};
            Notifier.out("out.1", arguments);
        }
        catch (Throwable t) {
            Notifier.error("error.1");
            t.printStackTrace();
            System.exit(1);
        }
    }

    private void generateCAP() {
        if ((this.conversion_profile.output & 1) != 0) {
            CapgenWrapper.generateCAPFile(this.conversion_profile);
        }
    }

    private void generateJCA() {
        try {
            Converter converter = new Converter(this.conversion_profile);
            converter.convert();
        }
        catch (ConverterException converterException) {
            Notifier.newLine();
            Object[] arguments = new Object[]{String.valueOf(Notifier.getErrorCount()), String.valueOf(Notifier.getWarningCount())};
            Notifier.out("out.1", arguments);
            System.exit(1);
        }
        catch (ConverterInternalError cie) {
            Notifier.error("error.1");
            cie.printStackTrace();
            System.exit(1);
        }
        catch (Exception e) {
            Notifier.error("error.1");
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        ConverterHarness converter_harness = new ConverterHarness();
        converter_harness.convert(args);
    }
}

