/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.classfile.instructions.JInstrByteIndex;
import com.sun.javacard.converter.ConversionException;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.converters.InstrContainer;
import com.sun.javacard.converter.converters.InstructionConverter;
import com.sun.javacard.converter.converters.MethodConverter;
import com.sun.javacard.converter.converters.OperandStack;
import com.sun.javacard.converter.converters.OperandStackEntry;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.jcfile.JcLocalVariable;
import com.sun.javacard.jcfile.instructions.JcInstrByteIndex;
import com.sun.javacard.jcfile.instructions.JcInstrNoOperands;
import com.sun.javacard.jcfile.instructions.JcInstruction;

class InstrStoreConverter
extends InstructionConverter {
    public InstrStoreConverter(InstrContainer instr_container, MethodConverter method_converter) {
        super(instr_container, method_converter);
    }

    public JcInstruction convert() throws Exception {
        int java_local_index;
        int java_opcode = this.java_instr.getOpcode();
        switch (java_opcode) {
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                java_local_index = java_opcode - 59;
                break;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                java_local_index = java_opcode - 75;
                break;
            }
            case 54: {
                java_local_index = ((JInstrByteIndex)this.java_instr).getIndex();
                break;
            }
            case 58: {
                java_local_index = ((JInstrByteIndex)this.java_instr).getIndex();
                break;
            }
            default: {
                throw new ConverterInternalError();
            }
        }
        JcLocalVariable local = this.method_converter.getLocalVariableConverter().getJcLocalVariable(java_local_index, this.java_instr);
        if (local == null) {
            throw new ConverterInternalError();
        }
        this.createStoreInstruction(local, this.operand_stack);
        this.operand_stack.pop();
        return this.jc_instr;
    }

    private void createStoreInstruction(JcLocalVariable local_var, OperandStack operand_stack) throws Exception {
        OperandStackEntry stack_entry = operand_stack.peek(1);
        int local_type = local_var.getType();
        int stack_entry_type = stack_entry.getType();
        int new_index = local_var.getJcIndex();
        switch (local_type) {
            case 1: 
            case 2: {
                this.jc_instr = new_index < 4 ? new JcInstrNoOperands(47 + new_index) : new JcInstrByteIndex(41, new_index);
                return;
            }
            case 3: {
                if (!this.method_converter.isIntSupported()) {
                    Notifier.error(this.java_instr.getSourceLineNumber(), "int.5", this.method_converter.getClassName().replace('/', '.'));
                    throw new ConversionException();
                }
                Notifier.warning(this.java_instr.getSourceLineNumber(), "warning.5", this.method_converter.getClassName().replace('/', '.'));
                this.method_converter.getPackageConverter().setIntFlag(true);
                if (stack_entry_type != 3) {
                    stack_entry.rollBack();
                }
                this.jc_instr = new_index < 4 ? new JcInstrNoOperands(51 + new_index) : new JcInstrByteIndex(42, new_index);
                return;
            }
            case 10: {
                this.jc_instr = new_index < 4 ? new JcInstrNoOperands(43 + new_index) : new JcInstrByteIndex(40, new_index);
                return;
            }
        }
        throw new ConverterInternalError();
    }
}

