/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.Assert;
import com.sun.javacard.jcasm.ExceptionTableEntry;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.Msg;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ExceptionTable {
    protected Vector entryVector;
    protected int relocAddr;
    protected boolean relocated;
    protected JCMethod parentMethod;

    ExceptionTable(JCMethod parent) {
        this.parentMethod = parent;
        this.entryVector = new Vector();
    }

    public void addExceptionEntry(ExceptionTableEntry entry) {
        this.entryVector.addElement(entry);
    }

    public int count() {
        return this.entryVector.size();
    }

    public Enumeration elements() {
        return this.entryVector.elements();
    }

    protected void fixup(Hashtable symbolTable) {
        if (this.entryVector.size() == 0) {
            return;
        }
        Vector<ExceptionTableEntry> fixupVector = new Vector<ExceptionTableEntry>(this.entryVector.size());
        Enumeration e = this.entryVector.elements();
        while (e.hasMoreElements()) {
            ExceptionTableEntry exe = (ExceptionTableEntry)e.nextElement();
            exe.fixup(symbolTable);
            fixupVector.insertElementAt(exe, 0);
        }
        ExceptionTableEntry last = null;
        Enumeration e2 = fixupVector.elements();
        while (e2.hasMoreElements()) {
            ExceptionTableEntry exe = (ExceptionTableEntry)e2.nextElement();
            if (last == null) {
                exe.isOuterMost = true;
                last = exe;
                continue;
            }
            if (last.getStartOffset() <= exe.getStartOffset() && last.getStartOffset() + last.getActiveLength() >= exe.getStartOffset() + exe.getActiveLength()) continue;
            exe.isOuterMost = true;
            last = exe;
        }
    }

    public int getRelocAddr() {
        Assert.PreCondition(this.relocated, "!relocated");
        return this.relocAddr;
    }

    public boolean isRelocated() {
        return this.relocated;
    }

    public void relocate(int address) {
        this.relocAddr = address;
        this.relocated = true;
    }

    public int size() {
        return this.entryVector.size() * ExceptionTableEntry.size();
    }

    public byte[] toByteArray() {
        byte[] array = new byte[this.size()];
        int offset = 0;
        Enumeration e = this.entryVector.elements();
        while (e.hasMoreElements()) {
            ExceptionTableEntry exe = (ExceptionTableEntry)e.nextElement();
            byte[] entry = exe.toByteArray();
            System.arraycopy(entry, 0, array, offset, entry.length);
            offset += entry.length;
        }
        return array;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(".exceptionTable {" + Msg.eol);
        Enumeration e = this.entryVector.elements();
        while (e.hasMoreElements()) {
            ExceptionTableEntry exe = (ExceptionTableEntry)e.nextElement();
            sb.append(String.valueOf(exe.toString()) + Msg.eol);
        }
        sb.append("}");
        return sb.toString();
    }
}

