/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.ClassIdentifier;

public class FieldDescriptor {
    protected String descriptor;
    protected ClassIdentifier classIdentifier;
    protected boolean isArray;
    protected boolean isPrimitive;

    public FieldDescriptor(ClassIdentifier classIdentifier, boolean isArray) {
        this.classIdentifier = classIdentifier;
        this.isArray = isArray;
        this.isPrimitive = false;
    }

    public FieldDescriptor(String descriptor, boolean isPrimitive, boolean isArray) {
        this.descriptor = descriptor;
        this.isArray = isArray;
        this.isPrimitive = isPrimitive;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FieldDescriptor)) {
            return false;
        }
        FieldDescriptor fd = (FieldDescriptor)obj;
        if (this.descriptor != null && this.descriptor.equals(fd.descriptor)) {
            return true;
        }
        return this.classIdentifier.equals(fd.classIdentifier);
    }

    public ClassIdentifier getClassIdentifier() {
        return this.classIdentifier;
    }

    public String getDescriptorString() {
        return this.descriptor;
    }

    public int hashCode() {
        if (this.descriptor != null) {
            return this.descriptor.hashCode();
        }
        return this.classIdentifier.hashCode();
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    public String toString() {
        if (this.descriptor != null) {
            return this.descriptor;
        }
        return "<" + this.classIdentifier.toString() + ">";
    }
}

