/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.Assert;
import com.sun.javacard.jcasm.ClassIdentifier;
import com.sun.javacard.jcasm.Field;
import com.sun.javacard.jcasm.FieldIdentifier;
import com.sun.javacard.jcasm.InterfaceTable;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Member;
import com.sun.javacard.jcasm.MethodIdentifier;
import com.sun.javacard.jcasm.MethodTable;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.PackageIdentifier;
import com.sun.javacard.jcasm.Sortable;
import com.sun.javacard.jcasm.SuperInterface;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class JCClass
extends Member
implements Sortable {
    public static final int MAX_INTERFACES = 15;
    public static final int MAX_FIELDS = 255;
    public static final int ACC_INTERFACE = 128;
    public static final int ACC_SHAREABLE = 64;
    protected ClassIdentifier classId;
    protected JCPackage parentPackage;
    protected JCClass superClass;
    protected String superClassName;
    protected ClassIdentifier superClassIdentifier;
    protected Vector fieldVector;
    protected boolean isShareable;
    public MethodTable publicMethodTable;
    public MethodTable packageMethodTable;
    public Vector interfaceVector;
    public Vector superInterfaceVector;
    protected int referenceCount;
    protected int firstReferenceToken;
    protected int instanceSize;
    protected Vector methodVector;
    public Hashtable methodSymbolTable;
    public Hashtable fieldSymbolTable;

    public JCClass(JCPackage parentPackage, int modifier, String name, ClassIdentifier id, int line) {
        super(modifier, name, line, 0);
        Assert.PreCondition(id != null, "id != null");
        this.parentPackage = parentPackage;
        this.classId = id;
        this.methodSymbolTable = new Hashtable();
        this.fieldSymbolTable = new Hashtable();
        this.fieldVector = new Vector();
        this.interfaceVector = new Vector(4);
        this.methodVector = new Vector();
        this.firstReferenceToken = 255;
        this.isShareable = false;
        if (Modifier.isInterface(modifier)) {
            this.superInterfaceVector = new Vector();
        }
    }

    public void addField(Field field) {
        Assert.PreCondition(field != null, "field != null");
        String name = field.getName();
        if (this.fieldSymbolTable.containsKey(name)) {
            Object[] arguments = new Object[]{name, this.name};
            Msg.error("class.3", arguments);
            return;
        }
        if (!(!Modifier.isInterface(this.attributes) || Modifier.isFinal(field.getAttributes()) && Modifier.isStatic(field.getAttributes()))) {
            Object[] arguments = new Object[]{field.getName(), this.name};
            Msg.error("class.10", arguments);
            return;
        }
        FieldIdentifier fid = field.getFieldIdentifier();
        if (fid != null) {
            if (this.fieldSymbolTable.containsKey(fid)) {
                Object[] arguments = new Object[]{new Integer(fid.getFieldToken()), this.name};
                Msg.error("class.4", arguments);
                return;
            }
            this.fieldSymbolTable.put(fid, field);
        }
        this.fieldSymbolTable.put(name, field);
        this.fieldVector.addElement(field);
    }

    public void addInterface(InterfaceTable inter) {
        Assert.PreCondition(inter != null, "inter != null");
        if (this.interfaceVector.size() >= 15) {
            Object[] arguments = new Object[]{this.name};
            Msg.error("class.5", arguments);
        }
        this.interfaceVector.addElement(inter);
    }

    public void addMethod(JCMethod jcMethod) {
        Assert.PreCondition(jcMethod != null, "jcMethod != null");
        String name = jcMethod.getName();
        if (this.methodSymbolTable.containsKey(name)) {
            Object[] arguments = new Object[]{name, this.name};
            Msg.error("class.1", arguments);
            return;
        }
        if (Modifier.isInterface(this.attributes) && !Modifier.isAbstract(jcMethod.getAttributes())) {
            Object[] arguments = new Object[]{jcMethod.getName(), this.name};
            Msg.error("class.9", arguments);
            return;
        }
        MethodIdentifier mid = jcMethod.getMethodIdentifier();
        if (mid != null) {
            if (this.methodSymbolTable.containsKey(mid)) {
                Object[] arguments = new Object[]{new Integer(mid.getMethodToken()), this.name};
                Msg.error("class.2", arguments);
                return;
            }
            this.methodSymbolTable.put(mid, jcMethod);
        }
        jcMethod.methodFixup();
        this.methodSymbolTable.put(name, jcMethod);
        this.methodVector.addElement(jcMethod);
    }

    public void addSuperInterface(ClassIdentifier cid) {
        Assert.PreCondition(Modifier.isInterface(this.attributes), "!isInterface");
        this.superInterfaceVector.addElement(new SuperInterface(this, cid));
    }

    public void addSuperInterface(String name) {
        Assert.PreCondition(Modifier.isInterface(this.attributes), "!isInterface");
        this.superInterfaceVector.addElement(new SuperInterface(this, name));
    }

    public int compare(Object other) {
        JCClass otherClass = (JCClass)other;
        if (Modifier.isInterface(otherClass.getAttributes()) && !Modifier.isInterface(this.getAttributes())) {
            return 1;
        }
        if (!Modifier.isInterface(otherClass.getAttributes()) && Modifier.isInterface(this.getAttributes())) {
            return -1;
        }
        JCClass currentClass = otherClass;
        while (currentClass != null) {
            if (currentClass.equals(this)) {
                return -1;
            }
            currentClass = currentClass.getSuperClass();
        }
        currentClass = this;
        while (currentClass != null) {
            if (currentClass.equals(otherClass)) {
                return 1;
            }
            currentClass = currentClass.getSuperClass();
        }
        return 0;
    }

    public Enumeration fieldElements() {
        return this.fieldVector.elements();
    }

    public ClassIdentifier getClassIdentifier() {
        return this.classId;
    }

    public int getFirstReferenceToken() {
        return this.firstReferenceToken;
    }

    public int getInstanceBase() {
        int base = 0;
        JCClass c = this.getSuperClass();
        while (c != null) {
            base += c.getInstanceSize();
            c = c.getSuperClass();
        }
        return base;
    }

    public int getInstanceSize() {
        return this.instanceSize;
    }

    public JCPackage getParentPackage() {
        return this.parentPackage;
    }

    public int getReferenceCount() {
        return this.referenceCount;
    }

    public JCClass getSuperClass() {
        return this.superClass;
    }

    public ClassIdentifier getSuperClassIdentifier() {
        return this.superClassIdentifier;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public Enumeration interfaceElements() {
        return this.interfaceVector.elements();
    }

    public boolean isShareable() {
        return this.isShareable;
    }

    void makeShareable() {
        this.isShareable = true;
    }

    public Enumeration methodElements() {
        return this.methodVector.elements();
    }

    public void setSuperClass(JCClass c) {
        this.superClass = c;
        this.superClassName = c.getName();
        this.superClassIdentifier = c.getClassIdentifier();
    }

    public void setSuperClassIdentifier(ClassIdentifier id) {
        this.superClassIdentifier = id;
    }

    public void setSuperClassName(String str) {
        this.superClassName = str;
    }

    public int size() {
        if (Modifier.isInterface(this.attributes)) {
            return 1 + this.superInterfaceVector.size() * 2;
        }
        int size = 10 + 2 * this.packageMethodTable.getCount() + 2 * this.publicMethodTable.getCount();
        Enumeration e = this.interfaceVector.elements();
        while (e.hasMoreElements()) {
            InterfaceTable i = (InterfaceTable)e.nextElement();
            size += i.size();
        }
        return size;
    }

    public void sortFields() {
        this.instanceSize = 0;
        this.firstReferenceToken = 255;
        this.referenceCount = 0;
        int maxField = this.fieldVector.size() * 2;
        Field[][] staticFields = new Field[4][maxField];
        Field[] instanceFields = new Field[maxField];
        int i = 0;
        int j = 0;
        int k = 0;
        int l = 0;
        Enumeration e = this.fieldVector.elements();
        while (e.hasMoreElements()) {
            Object[] args;
            Field field = (Field)e.nextElement();
            int mod = field.getAttributes();
            if (Modifier.isStatic(mod)) {
                if (!field.getDescriptor().isPrimitive()) {
                    if (field.getDescriptor().isArray() && field.getFieldInitializer() != null) {
                        staticFields[0][i++] = field;
                        continue;
                    }
                    staticFields[1][j++] = field;
                    continue;
                }
                if (field.getFieldInitializer() == null) {
                    staticFields[2][k++] = field;
                    continue;
                }
                staticFields[3][l++] = field;
                continue;
            }
            int token = field.getFieldIdentifier().getFieldToken();
            if (token > maxField) {
                args = new Object[]{field.getName(), field.getParentClass().getName()};
                Msg.error("class.7", args);
                continue;
            }
            if (instanceFields[token] != null) {
                args = new Object[]{field.getName(), field.getParentClass().getName()};
                Msg.error("class.8", args);
                continue;
            }
            instanceFields[token] = field;
        }
        Vector<Field> nVec = new Vector<Field>(this.fieldVector.size());
        int m = 0;
        while (m < 4) {
            int n = 0;
            while (n < staticFields[0].length && staticFields[m][n] != null) {
                nVec.addElement(staticFields[m][n++]);
            }
            ++m;
        }
        int expectedToken = 0;
        int m2 = 0;
        while (m2 < instanceFields.length) {
            Field field = instanceFields[m2];
            if (field != null) {
                int token = field.getFieldIdentifier().getFieldToken();
                int size = Math.max(2, field.size()) / 2;
                if (token != expectedToken) {
                    Object[] args = new Object[]{field.getName(), field.getParentClass().getName()};
                    Msg.error("class.7", args);
                }
                expectedToken = token + size;
                if (!field.getDescriptor().isPrimitive()) {
                    ++this.referenceCount;
                    if (this.firstReferenceToken == 255) {
                        this.firstReferenceToken = token;
                    }
                }
                this.instanceSize += size;
                nVec.addElement(field);
            }
            ++m2;
        }
        this.fieldVector = nVec;
    }

    public Enumeration superInterfaceElements() {
        return this.superInterfaceVector.elements();
    }

    public byte[] toByteArray() {
        int flags;
        byte[] record = new byte[this.size()];
        int index = 0;
        int n = flags = this.isShareable ? 64 : 0;
        if (Modifier.isInterface(this.attributes)) {
            record[index++] = (byte)((flags |= 0x80) | this.superInterfaceVector.size() & 0xF);
            Enumeration e = this.superInterfaceVector.elements();
            while (e.hasMoreElements()) {
                SuperInterface s = (SuperInterface)e.nextElement();
                if (s.isResolved()) {
                    int addr = s.resolve().getRelocAddr();
                    record[index++] = (byte)(addr >> 8 & 0xFF);
                    record[index++] = (byte)(addr & 0xFF);
                    continue;
                }
                ClassIdentifier cid = s.getClassIdentifier();
                PackageIdentifier pid = cid.getPackageIdentifier();
                record[index++] = (byte)(this.parentPackage.getPackageToken(pid) | 0x80);
                record[index++] = (byte)cid.getClassToken();
            }
        } else {
            record[index++] = (byte)(flags | this.interfaceVector.size() & 0xF);
            if (this.superClass == null && this.superClassIdentifier == null) {
                record[index++] = -1;
                record[index++] = -1;
            } else if (this.superClass == null) {
                PackageIdentifier pid = this.superClassIdentifier.getPackageIdentifier();
                record[index++] = (byte)(this.parentPackage.getPackageToken(pid) | 0x80);
                record[index++] = (byte)this.superClassIdentifier.getClassToken();
            } else {
                int addr = this.superClass.getRelocAddr();
                record[index++] = (byte)(addr >> 8 & 0xFF);
                record[index++] = (byte)(addr & 0xFF);
            }
            record[index++] = (byte)this.instanceSize;
            record[index++] = (byte)this.firstReferenceToken;
            record[index++] = (byte)this.referenceCount;
            record[index++] = (byte)this.publicMethodTable.getBase();
            record[index++] = (byte)this.publicMethodTable.getCount();
            record[index++] = (byte)this.packageMethodTable.getBase();
            record[index++] = (byte)this.packageMethodTable.getCount();
            Enumeration e = this.publicMethodTable.elements();
            while (e.hasMoreElements()) {
                JCMethod m = (JCMethod)e.nextElement();
                if (m != null) {
                    int addr = m.getRelocAddr();
                    record[index++] = (byte)(addr >> 8 & 0xFF);
                    record[index++] = (byte)(addr & 0xFF);
                    continue;
                }
                record[index++] = -1;
                record[index++] = -1;
            }
            Enumeration e2 = this.packageMethodTable.elements();
            while (e2.hasMoreElements()) {
                JCMethod m = (JCMethod)e2.nextElement();
                Assert.Assert(m != null, "m!= null");
                int addr = m.getRelocAddr();
                record[index++] = (byte)(addr >> 8 & 0xFF);
                record[index++] = (byte)(addr & 0xFF);
            }
            Enumeration e3 = this.interfaceVector.elements();
            while (e3.hasMoreElements()) {
                InterfaceTable i = (InterfaceTable)e3.nextElement();
                byte[] table = i.toByteArray();
                System.arraycopy(table, 0, record, index, table.length);
                index += table.length;
            }
        }
        return record;
    }

    public String toString() {
        Enumeration e;
        StringBuffer sb = new StringBuffer();
        if (Modifier.isInterface(this.attributes)) {
            sb.append(".interface");
        } else {
            sb.append(".class");
        }
        sb.append(" " + super.toString());
        if (this.classId != null) {
            sb.append(" <" + this.classId + ">");
        }
        sb.append(" {" + Msg.eol);
        sb.append(".fields {" + Msg.eol);
        Enumeration e2 = this.fieldElements();
        while (e2.hasMoreElements()) {
            Field f = (Field)e2.nextElement();
            sb.append(String.valueOf(String.valueOf(f)) + ";" + Msg.eol);
        }
        sb.append("}" + Msg.eol);
        if (this.publicMethodTable != null) {
            sb.append("public method table base: " + this.publicMethodTable.getBase() + ", ");
            sb.append("public method table count: " + this.publicMethodTable.getCount() + Msg.eol);
            e = this.publicMethodTable.elements();
            while (e.hasMoreElements()) {
                e.nextElement();
            }
        }
        if (this.packageMethodTable != null) {
            sb.append("package method table base: " + this.packageMethodTable.getBase() + ", ");
            sb.append("package method table count: " + this.packageMethodTable.getCount() + Msg.eol);
            e = this.publicMethodTable.elements();
            while (e.hasMoreElements()) {
                e.nextElement();
            }
        }
        e = this.interfaceVector.elements();
        while (e.hasMoreElements()) {
            InterfaceTable i = (InterfaceTable)e.nextElement();
            sb.append(String.valueOf(String.valueOf(i)) + Msg.eol);
        }
        Enumeration e3 = this.methodVector.elements();
        while (e3.hasMoreElements()) {
            JCMethod m = (JCMethod)e3.nextElement();
            sb.append(m);
        }
        sb.append("}" + Msg.eol);
        return sb.toString();
    }
}

