/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.mask;

import com.sun.javacard.jcasm.Assert;
import com.sun.javacard.jcasm.Globals;
import com.sun.javacard.jcasm.mask.RomMask;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Properties;

public abstract class OutputFormatter {
    protected Properties mappingTable;

    public OutputFormatter(BufferedReader in) throws IOException {
        String section = "none";
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        this.mappingTable = new Properties();
        boolean startReading = false;
        switch (Globals.target) {
            case 3: {
                section = "[Cref]";
                break;
            }
            case 4: {
                section = "[Jref]";
                break;
            }
        }
        if (in != null) {
            String s;
            while ((s = in.readLine()) != null) {
                if (s.trim().equalsIgnoreCase(section) || s.trim().equalsIgnoreCase("[Common]")) {
                    startReading = true;
                    continue;
                }
                if (s.trim().startsWith("[") && s.trim().endsWith("]")) {
                    startReading = false;
                }
                if (!startReading || s.length() <= 0) continue;
                s = String.valueOf(s) + "\n";
                dos.writeBytes(s);
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            this.mappingTable.load(bis);
        }
    }

    public abstract void format(RomMask var1);

    public String getMapEntry(String key) {
        Assert.PreCondition(key != null, "key != null");
        return (String)((Hashtable)this.mappingTable).get(key);
    }

    public Properties getProperties() {
        return this.mappingTable;
    }

    public abstract void write(OutputStream var1) throws IOException;
}

