/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.VerifierError;

class Safeptr {
    byte[] componentData;
    String componentName;
    int ofs;

    Safeptr(byte[] byArray, String string) {
        this.componentData = byArray;
        this.componentName = string;
        this.ofs = 0;
    }

    Safeptr(Safeptr safeptr) {
        this.componentData = safeptr.componentData;
        this.componentName = safeptr.componentName;
        this.ofs = safeptr.ofs;
    }

    Safeptr(Safeptr safeptr, int n) {
        this.componentData = safeptr.componentData;
        this.componentName = safeptr.componentName;
        this.ofs = n;
        if (this.ofs < 0 || this.ofs > this.componentData.length) {
            this.overflow(0);
        }
    }

    int u1(int n) {
        if (this.ofs + n >= this.componentData.length) {
            this.overflow(n);
        }
        return this.componentData[this.ofs + n] & 0xFF;
    }

    int s1(int n) {
        if (this.ofs + n >= this.componentData.length) {
            this.overflow(n);
        }
        return this.componentData[this.ofs + n];
    }

    int u2(int n) {
        if (this.ofs + n + 1 >= this.componentData.length) {
            this.overflow(n);
        }
        return (this.componentData[this.ofs + n] & 0xFF) << 8 | this.componentData[this.ofs + n + 1] & 0xFF;
    }

    int s2(int n) {
        if (this.ofs + n + 1 >= this.componentData.length) {
            this.overflow(n);
        }
        return this.componentData[this.ofs + n] << 8 | this.componentData[this.ofs + n + 1] & 0xFF;
    }

    int s4(int n) {
        if (this.ofs + n + 3 >= this.componentData.length) {
            this.overflow(n);
        }
        return this.componentData[this.ofs + n] << 24 | (this.componentData[this.ofs + n + 1] & 0xFF) << 16 | (this.componentData[this.ofs + n + 2] & 0xFF) << 8 | this.componentData[this.ofs + n + 3] & 0xFF;
    }

    int nibble(int n) {
        if ((n & 1) == 0) {
            return this.u1(n >> 1) >> 4;
        }
        return this.u1(n >> 1) & 0xF;
    }

    void advance(int n) {
        this.ofs += n;
        if (this.ofs < 0 || this.ofs > this.componentData.length) {
            this.overflow(0);
        }
    }

    Safeptr offset(int n) {
        return new Safeptr(this, this.ofs + n);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Safeptr)) {
            return false;
        }
        Safeptr safeptr = (Safeptr)object;
        return safeptr.componentData == this.componentData && safeptr.ofs == this.ofs;
    }

    public String toString() {
        return Messages.format("Safeptr.2", (Object)this.componentName, this.ofs);
    }

    private void overflow(int n) {
        throw new VerifierError("Safeptr.1", (Object)this.toString(), n);
    }

    int size() {
        return this.componentData.length;
    }

    boolean atComponentEnd() {
        return this.ofs == this.componentData.length;
    }

    void write1(int n, int n2) {
        if (this.ofs + n >= this.componentData.length) {
            this.overflow(n);
        }
        this.componentData[this.ofs + n] = (byte)n2;
    }

    void write2(int n, int n2) {
        if (this.ofs + n + 1 >= this.componentData.length) {
            this.overflow(n);
        }
        this.componentData[this.ofs + n] = (byte)(n2 >> 8);
        this.componentData[this.ofs + n + 1] = (byte)n2;
    }
}

