/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.impl;

import com.sun.javacard.impl.AppletMgr;
import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.impl.PackageMgr;
import com.sun.javacard.impl.PrivAccess;
import javacard.framework.ISOException;
import javacard.framework.JCSystem;
import javacard.framework.SystemException;

public class GarbageCollector {
    public static byte GCRequested = (byte)-1;
    public static boolean deletingPackage = false;
    public static boolean sweepStarted = false;
    public static byte packageBeingDeleted = (byte)-1;
    public static short[] RMIExpObjArray = null;

    public static void setExpObjArray(short[] expArray) {
        RMIExpObjArray = expArray;
    }

    public static boolean startGC() {
        boolean doCommit = false;
        if (!GarbageCollector.markObjects()) {
            return false;
        }
        sweepStarted = true;
        NativeMethods.startSweepCycle();
        sweepStarted = false;
        GarbageCollector.cleanupExportedObjectsArray();
        return true;
    }

    private static boolean markObjects() {
        boolean gcRequested = PrivAccess.getPrivAccess().isGarbageCollectionRequested();
        PrivAccess.getPrivAccess().setGCRequestedFlag(false);
        try {
            NativeMethods.initializeGC();
        }
        catch (SystemException e2) {
            if (!gcRequested) {
                ISOException.throwIt((short)25673);
            }
            return false;
        }
        NativeMethods.markAppletRoots(AppletMgr.theAppTable);
        if (PackageMgr.f_pkgTable != null) {
            for (byte i2 = 0; i2 < 33; i2 = (byte)((byte)(i2 + 1))) {
                if (PackageMgr.f_pkgTable[i2] == null) continue;
                short refCount = PackageMgr.f_pkgTable[i2].pkgStaticReferenceCount;
                if (deletingPackage && packageBeingDeleted == i2 || refCount == 0 || NativeMethods.markStaticRoots(i2, refCount) != 0) continue;
                return false;
            }
        }
        return NativeMethods.markNonRootObjects();
    }

    private static void cleanupExportedObjectsArray() {
        if (RMIExpObjArray != null) {
            NativeMethods.cleanupExportedObjectsArray(RMIExpObjArray);
        }
    }

    public static void deleteApplets(byte[] contexts, byte count) throws ISOException {
        boolean markSuccessful = false;
        NativeMethods.initializeAppletDeletion(contexts, count);
        JCSystem.beginTransaction();
        for (byte i2 = 0; i2 < count; i2 = (byte)(i2 + 1)) {
            AppletMgr.removeApplet((byte)(contexts[i2] & 0xF));
        }
        try {
            markSuccessful = GarbageCollector.markObjects();
        }
        catch (ISOException e2) {
            JCSystem.abortTransaction();
            ISOException.throwIt(e2.getReason());
        }
        if (!markSuccessful) {
            JCSystem.abortTransaction();
            ISOException.throwIt((short)25672);
        }
        JCSystem.commitTransaction();
        NativeMethods.startSweepCycle();
        GarbageCollector.cleanupExportedObjectsArray();
    }

    public static void initPackageDeletion(byte index) {
        deletingPackage = true;
        packageBeingDeleted = index;
    }

    public static void resetPackageDeletion() {
        packageBeingDeleted = (byte)-1;
        deletingPackage = false;
    }

    public static void cleanupTables(byte index) {
        if (PackageMgr.f_pkgTable[index] == null) {
            return;
        }
        if (PackageMgr.f_pkgTable[index].appletCount > 0) {
            PackageMgr.packageContextTable[PackageMgr.getPkgContext((byte)index)] = -1;
            PackageMgr.appletPkgCount = (byte)(PackageMgr.appletPkgCount - 1);
        }
        PackageMgr.f_pkgTable[index] = null;
        GarbageCollector.resetPackageDeletion();
        GarbageCollector.startGC();
    }

    public static void deletePackage(byte index) throws ISOException {
        if (PackageMgr.g_packageInProcess == -1) {
            PackageMgr.g_packageInProcess = index;
        }
        NativeMethods.removePackage(index, (byte)0);
        JCSystem.beginTransaction();
        GarbageCollector.cleanupTables(index);
        JCSystem.commitTransaction();
    }

    public static void deletePackageAndApplets(byte index, byte[] buffer, byte appCount) throws ISOException {
        PackageMgr.g_packageInProcess = index;
        GarbageCollector.initPackageDeletion(index);
        if (appCount != 0) {
            try {
                GarbageCollector.deleteApplets(buffer, appCount);
            }
            catch (ISOException e2) {
                PackageMgr.g_packageInProcess = (byte)-1;
                GarbageCollector.resetPackageDeletion();
                ISOException.throwIt(e2.getReason());
            }
        }
        GarbageCollector.deletePackage(index);
    }
}

