/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import java.util.Arrays;

class Contour {
    int[] substack;
    static Contour empty = new Contour();

    Contour(int[] nArray) {
        this.substack = nArray;
    }

    Contour() {
        this.substack = new int[0];
    }

    Contour(int n, Contour contour) {
        this.substack = new int[1 + contour.substack.length];
        this.substack[0] = n;
        System.arraycopy(contour.substack, 0, this.substack, 1, contour.substack.length);
    }

    boolean contains(int n) {
        int n2 = 0;
        while (n2 < this.substack.length) {
            if (this.substack[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    Contour popUpto(int n) {
        int n2 = 0;
        while (n2 < this.substack.length && this.substack[n2] != n) {
            ++n2;
        }
        if (n2 == this.substack.length) {
            return null;
        }
        if (n2 == this.substack.length - 1) {
            return empty;
        }
        int[] nArray = new int[this.substack.length - n2 - 1];
        System.arraycopy(this.substack, n2 + 1, nArray, 0, nArray.length);
        return new Contour(nArray);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Contour)) {
            return false;
        }
        Contour contour = (Contour)object;
        return Arrays.equals(this.substack, contour.substack);
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.substack.length) {
            n = n * 13 + this.substack[n2];
            ++n2;
        }
        return n;
    }

    public String toString() {
        if (this.substack.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append('{');
        int n = 0;
        while (n < this.substack.length) {
            if (n > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.substack[n]);
            ++n;
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }
}

