/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ClassDescriptor;
import com.sun.javacard.offcardverifier.Classref;
import com.sun.javacard.offcardverifier.FieldDescriptor;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.MethodDescriptor;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.TypeDescriptor;
import com.sun.javacard.offcardverifier.Verifier;
import com.sun.javacard.offcardverifier.VerifierError;
import java.util.BitSet;

class DescriptorComponent
extends Safeptr {
    private int maxInterfaceLocation = Integer.MIN_VALUE;
    private int minClassLocation = Integer.MAX_VALUE;

    DescriptorComponent(byte[] byArray) {
        super(byArray, "Descriptor");
    }

    int classCount() {
        return this.u1(0);
    }

    ClassDescriptor firstClassDescriptor() {
        return new ClassDescriptor(this.offset(1));
    }

    void verify() {
        if (Verifier.verbose >= 2) {
            Messages.println("DescriptorComponent.100");
        }
        ClassDescriptor classDescriptor = Cap.Descriptor.firstClassDescriptor();
        int n = Cap.Descriptor.classCount();
        while (n > 0) {
            classDescriptor.next();
            --n;
        }
        TypeDescriptor typeDescriptor = new TypeDescriptor(classDescriptor);
        BitSet bitSet = new BitSet();
        int n2 = typeDescriptor.firstTypeByte();
        while (n2 <= typeDescriptor.lastTypeByte()) {
            bitSet.set(n2);
            n2 = this.verifyTypeDescr(typeDescriptor, n2);
        }
        Cap.TypeDescr = typeDescriptor;
        classDescriptor = Cap.Descriptor.firstClassDescriptor();
        BitSet bitSet2 = new BitSet();
        int n3 = Cap.Descriptor.classCount();
        while (n3 > 0) {
            try {
                this.verifyClassDescr(bitSet, classDescriptor, bitSet2);
            }
            catch (VerifierError verifierError) {
                throw new VerifierError("DescriptorComponent.1", (Object)classDescriptor, (Object)verifierError.getMessage());
            }
            classDescriptor.next();
            --n3;
        }
        int n4 = 0;
        while (n4 < typeDescriptor.constantPoolCount()) {
            int n5 = typeDescriptor.constantPoolType(n4);
            if (n5 != 65535) {
                this.verifyTypeOffset(bitSet, n5);
            }
            ++n4;
        }
    }

    private int verifyTypeDescr(TypeDescriptor typeDescriptor, int n) {
        Safeptr safeptr = typeDescriptor.offset(n);
        int n2 = safeptr.u1(0);
        Safeptr safeptr2 = safeptr.offset(1);
        if (n2 == 0) {
            throw new VerifierError("DescriptorComponent.2", safeptr);
        }
        int n3 = 0;
        while (n3 < n2) {
            switch (safeptr2.nibble(n3)) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    ++n3;
                    break;
                }
                case 6: 
                case 14: {
                    n3 += 5;
                    break;
                }
                default: {
                    throw new VerifierError("DescriptorComponent.3", safeptr2.nibble(n3), (Object)safeptr);
                }
            }
        }
        if (n3 > n2) {
            throw new VerifierError("DescriptorComponent.4", safeptr);
        }
        if ((n2 & 1) == 1 && safeptr2.nibble(n2) != 0) {
            throw new VerifierError("DescriptorComponent.5", safeptr);
        }
        return n + 1 + (n2 + 1) / 2;
    }

    private void verifyTypeOffset(BitSet bitSet, int n) {
        if (!bitSet.get(n)) {
            throw new VerifierError("DescriptorComponent.6", n);
        }
    }

    private void verifyClassDescr(BitSet bitSet, ClassDescriptor classDescriptor, BitSet bitSet2) {
        int n;
        BitSet bitSet3;
        BitSet bitSet4;
        int n2 = classDescriptor.flags();
        int n3 = classDescriptor.token();
        if ((n2 & 0xFFFFFF2E) != 0) {
            throw new VerifierError("DescriptorComponent.7", n2);
        }
        if (Classref.isExternal(classDescriptor.thisClass())) {
            throw new VerifierError("DescriptorComponent.26");
        }
        if ((n2 & 0x40) != 0 && (n2 & 0x80) == 0) {
            throw new VerifierError("DescriptorComponent.8");
        }
        if ((n2 & 0x90) == 144) {
            throw new VerifierError("DescriptorComponent.31");
        }
        if ((n2 & 1) == 0 && n3 != 255) {
            throw new VerifierError("DescriptorComponent.9", n3);
        }
        if ((n2 & 1) != 0 && n3 == 255) {
            throw new VerifierError("DescriptorComponent.27");
        }
        if ((n2 & 0x40) != 0) {
            if (classDescriptor.thisClass() >= this.minClassLocation) {
                throw new VerifierError("DescriptorComponent.44");
            }
            if (classDescriptor.thisClass() > this.maxInterfaceLocation) {
                this.maxInterfaceLocation = classDescriptor.thisClass();
            }
            if (classDescriptor.fieldCount() != 0) {
                throw new VerifierError("DescriptorComponent.37");
            }
            if (classDescriptor.interfaceCount() != 0) {
                throw new VerifierError("DescriptorComponent.46");
            }
        } else {
            if (classDescriptor.thisClass() <= this.maxInterfaceLocation) {
                throw new VerifierError("DescriptorComponent.45");
            }
            if (classDescriptor.thisClass() < this.minClassLocation) {
                this.minClassLocation = classDescriptor.thisClass();
            }
            bitSet4 = new BitSet();
            bitSet3 = new BitSet();
            n = 0;
            while (n < classDescriptor.fieldCount()) {
                try {
                    this.verifyFieldDescr(bitSet, classDescriptor, classDescriptor.fieldDescr(n), bitSet4, bitSet3);
                }
                catch (VerifierError verifierError) {
                    throw new VerifierError("DescriptorComponent.10", n, (Object)verifierError.getMessage());
                }
                ++n;
            }
            if (!DescriptorComponent.isInitialSegment(bitSet4)) {
                throw new VerifierError("DescriptorComponent.41");
            }
        }
        bitSet4 = new BitSet();
        bitSet3 = new BitSet();
        n = 0;
        while (n < classDescriptor.methodCount()) {
            try {
                this.verifyMethodDescr(classDescriptor, bitSet, classDescriptor.methodDescr(n), bitSet4, bitSet3);
            }
            catch (VerifierError verifierError) {
                throw new VerifierError("DescriptorComponent.11", n, (Object)verifierError.getMessage());
            }
            ++n;
        }
        if (!DescriptorComponent.isInitialSegment(bitSet4)) {
            throw new VerifierError("DescriptorComponent.42");
        }
        if ((n2 & 0x40) != 0 && !DescriptorComponent.isInitialSegment(bitSet3)) {
            throw new VerifierError("DescriptorComponent.43");
        }
        if ((n2 & 1) != 0) {
            if (bitSet2.get(n3)) {
                throw new VerifierError("DescriptorComponent.30", n3);
            }
            bitSet2.set(n3);
        }
    }

    private void verifyFieldDescr(BitSet bitSet, ClassDescriptor classDescriptor, FieldDescriptor fieldDescriptor, BitSet bitSet2, BitSet bitSet3) {
        Object object;
        int n;
        boolean bl;
        int n2 = fieldDescriptor.flags();
        int n3 = fieldDescriptor.token();
        if ((n2 & 0xFFFFFFE0) != 0) {
            throw new VerifierError("DescriptorComponent.12", n2);
        }
        switch (n2 & 7) {
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            default: {
                throw new VerifierError("DescriptorComponent.13", n2);
            }
        }
        boolean bl2 = bl = (n2 & 8) != 0 && (n2 & 5) == 0;
        if (bl && n3 != 255) {
            throw new VerifierError("DescriptorComponent.14");
        }
        if ((n2 & 8) == 0) {
            if (fieldDescriptor.classRefVirtualRef() != classDescriptor.thisClass()) {
                throw new VerifierError("DescriptorComponent.16");
            }
            if (fieldDescriptor.tokenVirtualRef() != fieldDescriptor.token()) {
                throw new VerifierError("DescriptorComponent.17");
            }
        }
        if (((n = fieldDescriptor.type()) & 0x8000) == 0) {
            this.verifyTypeOffset(bitSet, n);
            object = Cap.TypeDescr.at(n);
            if (((Safeptr)object).u1(0) == 0 || ((Safeptr)object).nibble(2) != 6 && (((Safeptr)object).nibble(2) < 10 || ((Safeptr)object).nibble(2) > 14)) {
                throw new VerifierError("DescriptorComponent.24", n);
            }
            if (((Safeptr)object).nibble(2) == 13) {
                Cap.Header.useInts();
            }
        } else {
            switch (n) {
                case 32773: {
                    Cap.Header.useInts();
                    break;
                }
                case 32770: 
                case 32771: 
                case 32772: {
                    break;
                }
                default: {
                    throw new VerifierError("DescriptorComponent.18", n);
                }
            }
            if ((n2 & 0x18) == 24) {
                throw new VerifierError("DescriptorComponent.39");
            }
        }
        if ((n2 & 8) != 0 && fieldDescriptor.packageTokenRef() != 0) {
            throw new VerifierError("DescriptorComponent.19");
        }
        if (!bl) {
            Object object2 = object = (n2 & 8) != 0 ? bitSet2 : bitSet3;
            if (((BitSet)object).get(n3)) {
                throw new VerifierError("DescriptorComponent.28", n3);
            }
            ((BitSet)object).set(n3);
        }
    }

    private void verifyMethodDescr(ClassDescriptor classDescriptor, BitSet bitSet, MethodDescriptor methodDescriptor, BitSet bitSet2, BitSet bitSet3) {
        boolean bl;
        int n = methodDescriptor.flags();
        int n2 = methodDescriptor.token();
        if ((n & 0xFFFFFF20) != 0) {
            throw new VerifierError("DescriptorComponent.20", n);
        }
        switch (n & 7) {
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            default: {
                throw new VerifierError("DescriptorComponent.21", n);
            }
        }
        if ((classDescriptor.flags() & 0x80) == 0 && (n & 0x40) != 0) {
            throw new VerifierError("DescriptorComponent.40");
        }
        if ((n & 0x40) != 0 && (n & 0x12) != 0) {
            throw new VerifierError("DescriptorComponent.38");
        }
        boolean bl2 = bl = (n & 2) != 0 || (n & 5) == 0 && (n & 0x88) != 0;
        if (bl && n2 != 255) {
            throw new VerifierError("DescriptorComponent.22");
        }
        this.verifyTypeOffset(bitSet, methodDescriptor.type());
        if (!bl) {
            BitSet bitSet4;
            BitSet bitSet5 = bitSet4 = (n & 0x88) != 0 ? bitSet2 : bitSet3;
            if (bitSet4.get(n2)) {
                throw new VerifierError("DescriptorComponent.29", n2);
            }
            bitSet4.set(n2);
        }
        if ((classDescriptor.flags() & 0x40) != 0) {
            if (n != 65) {
                throw new VerifierError("DescriptorComponent.32");
            }
            if (methodDescriptor.methodOffset() != 0) {
                throw new VerifierError("DescriptorComponent.33");
            }
            if (methodDescriptor.bytecodeCount() != 0) {
                throw new VerifierError("DescriptorComponent.34");
            }
            if (methodDescriptor.exnHandlerCount() != 0) {
                throw new VerifierError("DescriptorComponent.35");
            }
            if (methodDescriptor.exnHandlerIndex() != 0) {
                throw new VerifierError("DescriptorComponent.36");
            }
        }
    }

    private static boolean isInitialSegment(BitSet bitSet) {
        int n = bitSet.length();
        int n2 = 0;
        while (n2 < n) {
            if (!bitSet.get(n2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

