/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.AID;
import com.sun.javacard.offcardverifier.AIDintf;
import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.PackageInfo;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.Verifier;
import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.EfConstant_Package;
import com.sun.javacard.offcardverifier.exportfile.ExportFile;
import java.io.File;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Vector;

class ImportComponent
extends Safeptr {
    private Vector importedPackages;
    private BitSet referencedImportedPackages;
    private int numImportedPackages;
    private static Vector exportFiles = new Vector();

    ImportComponent(byte[] byArray) {
        super(byArray, "Import");
    }

    int count() {
        return this.u1(0);
    }

    PackageInfo packageInfo() {
        return new PackageInfo(this.offset(1));
    }

    void verify() {
        int n;
        if (Verifier.verbose >= 2) {
            Messages.println("ImportComponent.100");
        }
        if ((n = this.count()) > 128) {
            throw new VerifierError("ImportComponent.1", n);
        }
        this.importedPackages = new Vector(n);
        this.numImportedPackages = 0;
        PackageInfo packageInfo = this.packageInfo();
        int n2 = 0;
        while (n2 < n) {
            if (!AID.isValid(packageInfo)) {
                throw new VerifierError("ImportComponent.2", AID.pretty(packageInfo));
            }
            if (AID.same((AIDintf)packageInfo, Cap.Header.thisPackage())) {
                throw new VerifierError("ImportComponent.2", AID.pretty(packageInfo));
            }
            ExportFile exportFile = ImportComponent.findExportByAid(packageInfo);
            if (exportFile == null) {
                throw new VerifierError("ImportComponent.3", AID.pretty(packageInfo));
            }
            EfConstant_Package efConstant_Package = exportFile.thisPackage();
            if (packageInfo.majorVersion() != efConstant_Package.majorVersion || packageInfo.minorVersion() > efConstant_Package.minorVersion) {
                throw new VerifierError("ImportComponent.4", exportFile.thisName(), AID.pretty(packageInfo), packageInfo.majorVersion(), packageInfo.minorVersion(), efConstant_Package.majorVersion, efConstant_Package.minorVersion);
            }
            if (Verifier.verbose >= 2) {
                if (packageInfo.minorVersion() == efConstant_Package.minorVersion) {
                    Messages.println("ImportComponent.101", exportFile.thisName(), AID.pretty(packageInfo), packageInfo.majorVersion(), packageInfo.minorVersion());
                } else {
                    Messages.println("ImportComponent.102", exportFile.thisName(), AID.pretty(packageInfo), packageInfo.majorVersion(), packageInfo.minorVersion(), efConstant_Package.majorVersion, efConstant_Package.minorVersion);
                }
                Messages.println("ImportComponent.103", exportFile.file);
            }
            this.importedPackages.add(exportFile);
            ++this.numImportedPackages;
            packageInfo.next();
            ++n2;
        }
        if (!packageInfo.atComponentEnd()) {
            throw new VerifierError("ImportComponent.5");
        }
    }

    ExportFile importPackage(int n) {
        if (n >= 0 && n < this.numImportedPackages) {
            if (this.referencedImportedPackages != null) {
                this.referencedImportedPackages.set(n);
            }
            return (ExportFile)this.importedPackages.get(n);
        }
        return null;
    }

    ExportFile exportfileForPackageToken(int n) {
        if (this.referencedImportedPackages != null) {
            this.referencedImportedPackages.set(n);
        }
        return (ExportFile)this.importedPackages.get(n);
    }

    int tokenForPackage(String string) {
        ExportFile exportFile;
        int n = 0;
        while (n < this.importedPackages.size()) {
            exportFile = (ExportFile)this.importedPackages.get(n);
            if (string.equals(exportFile.thisName())) {
                if (this.referencedImportedPackages != null) {
                    this.referencedImportedPackages.set(n);
                }
                return n;
            }
            ++n;
        }
        exportFile = ImportComponent.findExportByName(string);
        if (exportFile == null) {
            throw new VerifierError("ImportComponent.6", string);
        }
        this.importedPackages.add(exportFile);
        return this.importedPackages.size() - 1;
    }

    void initialize() {
        this.referencedImportedPackages = new BitSet(this.count());
    }

    void checkUnreferencedPackages() {
        int n = 0;
        while (n < this.numImportedPackages) {
            if (!this.referencedImportedPackages.get(n)) {
                VerifierError.warning("ImportComponent.105", ((ExportFile)this.importedPackages.get(n)).thisName());
            }
            ++n;
        }
    }

    static void readExportFile(File file) {
        ExportFile exportFile = ExportFile.readFromFile(file);
        exportFile.verify();
        exportFiles.add(exportFile);
        if (Verifier.verbose >= 2) {
            Messages.println("ImportComponent.104", file, exportFile.thisName(), exportFile.thisPackage().majorVersion, exportFile.thisPackage().minorVersion);
        }
    }

    static ExportFile findExportByAid(PackageInfo packageInfo) {
        ExportFile exportFile = null;
        Enumeration enumeration = exportFiles.elements();
        while (enumeration.hasMoreElements()) {
            ExportFile exportFile2 = (ExportFile)enumeration.nextElement();
            EfConstant_Package efConstant_Package = exportFile2.thisPackage();
            if (!AID.same((AIDintf)packageInfo, efConstant_Package.AID)) continue;
            if (exportFile == null) {
                exportFile = exportFile2;
                continue;
            }
            throw new VerifierError("ImportComponent.7", (Object)exportFile.file, (Object)exportFile2.file);
        }
        return exportFile;
    }

    static ExportFile findExportByAidAndVersion(PackageInfo packageInfo) {
        Enumeration enumeration = exportFiles.elements();
        while (enumeration.hasMoreElements()) {
            ExportFile exportFile = (ExportFile)enumeration.nextElement();
            EfConstant_Package efConstant_Package = exportFile.thisPackage();
            if (!AID.same((AIDintf)packageInfo, efConstant_Package.AID) || packageInfo.majorVersion() != efConstant_Package.majorVersion || packageInfo.minorVersion() != efConstant_Package.minorVersion) continue;
            return exportFile;
        }
        return null;
    }

    static Vector findAllExportByAid(PackageInfo packageInfo) {
        Vector<ExportFile> vector = new Vector<ExportFile>(4);
        Enumeration enumeration = exportFiles.elements();
        while (enumeration.hasMoreElements()) {
            ExportFile exportFile = (ExportFile)enumeration.nextElement();
            EfConstant_Package efConstant_Package = exportFile.thisPackage();
            if (!AID.same((AIDintf)packageInfo, efConstant_Package.AID)) continue;
            vector.add(exportFile);
        }
        return vector;
    }

    static ExportFile findExportByName(String string) {
        Enumeration enumeration = exportFiles.elements();
        while (enumeration.hasMoreElements()) {
            ExportFile exportFile = (ExportFile)enumeration.nextElement();
            if (!string.equals(exportFile.thisName())) continue;
            return exportFile;
        }
        return null;
    }
}

