/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier.exportfile;

import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.EfClass;
import com.sun.javacard.offcardverifier.exportfile.EfConstantInfo;
import com.sun.javacard.offcardverifier.exportfile.EfConstant_ClassRef;
import com.sun.javacard.offcardverifier.exportfile.EfConstant_Integer;
import com.sun.javacard.offcardverifier.exportfile.EfConstant_Package;
import com.sun.javacard.offcardverifier.exportfile.EfConstant_Utf8;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Vector;

public class ExportFile {
    DataInputStream in;
    static final byte CONSTANT_PACKAGE = 13;
    static final byte CONSTANT_CLASS_REF = 7;
    static final byte CONSTANT_INTEGER = 3;
    static final byte CONSTANT_UTF8 = 1;
    public static final short ACC_PUBLIC = 1;
    public static final short ACC_PROTECTED = 4;
    public static final short ACC_STATIC = 8;
    public static final short ACC_FINAL = 16;
    public static final short ACC_INTERFACE = 512;
    public static final short ACC_ABSTRACT = 1024;
    public static final short ACC_SHAREABLE = 2048;
    public static final short ACC_LIBRARY = 1;
    public static final short ACC_REMOTE = 4096;
    public String file;
    EfConstantInfo[] constantPool;
    int thisPackage;
    int minorVersion;
    public EfClass[] classes;
    private Vector newClasses;
    private boolean sameVersion;
    static final int MAGIC_NUMBER = 16435934;
    static final int MAJOR_VERSION = 2;
    static final int MINOR_VERSION = 2;
    static final int MIN_MINOR_VERSION = 1;

    void checkPackageIndex(int n) {
        if (n < 0 || n >= this.constantPool.length || !(this.constantPool[n] instanceof EfConstant_Package)) {
            throw new VerifierError("ExportFile.3", n);
        }
    }

    void checkClassrefIndex(int n) {
        if (n < 0 || n >= this.constantPool.length || !(this.constantPool[n] instanceof EfConstant_ClassRef)) {
            throw new VerifierError("ExportFile.4", n);
        }
    }

    void checkIntegerIndex(int n) {
        if (n < 0 || n >= this.constantPool.length || !(this.constantPool[n] instanceof EfConstant_Integer)) {
            throw new VerifierError("ExportFile.5", n);
        }
    }

    void checkUtf8Index(int n) {
        if (n < 0 || n >= this.constantPool.length || !(this.constantPool[n] instanceof EfConstant_Utf8)) {
            throw new VerifierError("ExportFile.6", n);
        }
    }

    public EfConstant_Package thisPackage() {
        return (EfConstant_Package)this.constantPool[this.thisPackage];
    }

    public String thisName() {
        EfConstant_Package efConstant_Package = this.thisPackage();
        return ((EfConstant_Utf8)this.constantPool[efConstant_Package.nameIndex]).contents;
    }

    void read() throws IOException {
        int n;
        int n2 = this.in.readInt();
        if (n2 != 16435934) {
            throw new VerifierError("ExportFile.2");
        }
        this.minorVersion = this.in.readUnsignedByte();
        int n3 = this.in.readUnsignedByte();
        if (n3 != 2 || this.minorVersion > 2 || this.minorVersion < 1) {
            throw new VerifierError("ExportFile.7", n3, this.minorVersion);
        }
        int n4 = this.in.readUnsignedShort();
        this.constantPool = new EfConstantInfo[n4];
        int n5 = 0;
        while (n5 < n4) {
            EfConstantInfo efConstantInfo;
            n = this.in.readUnsignedByte();
            switch (n) {
                case 3: {
                    efConstantInfo = new EfConstant_Integer(this);
                    break;
                }
                case 1: {
                    efConstantInfo = new EfConstant_Utf8(this);
                    break;
                }
                case 7: {
                    efConstantInfo = new EfConstant_ClassRef(this);
                    break;
                }
                case 13: {
                    efConstantInfo = new EfConstant_Package(this);
                    break;
                }
                default: {
                    throw new VerifierError("ExportFile.8", n);
                }
            }
            efConstantInfo.read();
            this.constantPool[n5] = efConstantInfo;
            ++n5;
        }
        int n6 = 0;
        while (n6 < n4) {
            this.constantPool[n6].validate();
            ++n6;
        }
        this.thisPackage = this.in.readUnsignedShort();
        this.checkPackageIndex(this.thisPackage);
        n = this.in.readUnsignedByte();
        this.classes = new EfClass[n];
        int n7 = 0;
        while (n7 < n) {
            EfClass efClass = new EfClass(this);
            efClass.read();
            this.classes[n7] = efClass;
            ++n7;
        }
    }

    public void verify() {
        try {
            BitSet bitSet = new BitSet();
            HashSet hashSet = new HashSet();
            int n = 0;
            while (n < this.classes.length) {
                this.classes[n].verify(hashSet, bitSet);
                ++n;
            }
        }
        catch (VerifierError verifierError) {
            throw new VerifierError("ExportFile.52", (Object)this.file, (Object)verifierError.getMessage());
        }
    }

    public static ExportFile readFromFile(File file) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            ExportFile exportFile = new ExportFile();
            exportFile.file = file.toString();
            exportFile.in = new DataInputStream(new BufferedInputStream(fileInputStream));
            exportFile.read();
            fileInputStream.close();
            return exportFile;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new VerifierError("ExportFile.50", file.toString());
        }
        catch (IOException iOException) {
            throw new VerifierError("ExportFile.51", file.toString());
        }
        catch (VerifierError verifierError) {
            throw new VerifierError("ExportFile.52", (Object)file.toString(), (Object)verifierError.getMessage());
        }
    }

    public EfClass findClassByName(String string) {
        int n = 0;
        while (n < this.classes.length) {
            if (string.equals(this.classes[n].thisName())) {
                return this.classes[n];
            }
            ++n;
        }
        return null;
    }

    public void compareTo(ExportFile exportFile) {
        this.sameVersion = false;
        this.thisPackage().compareTo(exportFile.thisPackage());
        this.compareClasses(exportFile);
    }

    public void checkEquality(ExportFile exportFile) {
        this.sameVersion = true;
        this.thisPackage().checkEquality(exportFile.thisPackage());
        this.compareClasses(exportFile);
    }

    private void compareClasses(ExportFile exportFile) {
        boolean bl = false;
        int n = this.classes.length;
        int n2 = exportFile.classes.length;
        if (this.sameVersion && n != n2) {
            throw new VerifierError("RevisionError.2");
        }
        int n3 = 0;
        while (n3 < n) {
            bl = false;
            EfClass efClass = this.classes[n3];
            String string = efClass.thisName();
            int n4 = 0;
            while (n4 < n2) {
                EfClass efClass2 = exportFile.classes[n4];
                String string2 = efClass2.thisName();
                if (string2.equals(string)) {
                    bl = true;
                    if (this.sameVersion) {
                        efClass.checkEquality(efClass2);
                        break;
                    }
                    efClass.compareTo(efClass2);
                    break;
                }
                ++n4;
            }
            if (!bl) {
                throw new VerifierError("RevisionError.3", string);
            }
            ++n3;
        }
    }
}

