/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.classfile.instructions.JInstrIinc;
import com.sun.javacard.classfile.instructions.JInstrWide;
import com.sun.javacard.converter.ConversionException;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.converters.InstrContainer;
import com.sun.javacard.converter.converters.InstructionConverter;
import com.sun.javacard.converter.converters.MethodConverter;
import com.sun.javacard.converter.converters.RecalculateIndexException;
import com.sun.javacard.converter.util.DataType;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.jcfile.JcLocalVariable;
import com.sun.javacard.jcfile.instructions.JcInstrIncrement;
import com.sun.javacard.jcfile.instructions.JcInstruction;

class InstrIncrementConverter
extends InstructionConverter {
    public InstrIncrementConverter(InstrContainer instr_container, MethodConverter method_converter) {
        super(instr_container, method_converter);
    }

    public JcInstruction convert() throws Exception {
        JcInstrIncrement jc_instr;
        if (!this.method_converter.isIntSupported()) {
            Notifier.error(this.java_instr.getSourceLineNumber(), "int.5", this.method_converter.getClassName().replace('/', '.'));
            throw new ConversionException();
        }
        Notifier.progress(this.java_instr.getSourceLineNumber(), "warning.5", this.method_converter.getClassName().replace('/', '.'));
        this.method_converter.getPackageConverter().setIntFlag(true);
        int java_opcode = this.java_instr.getOpcode();
        int java_local_index = 0;
        int constant = 0;
        if (java_opcode == 196) {
            java_local_index = ((JInstrWide)this.java_instr).getIndex();
            constant = ((JInstrWide)this.java_instr).getConstant();
        } else {
            java_local_index = ((JInstrIinc)this.java_instr).getIndex();
            constant = ((JInstrIinc)this.java_instr).getConstant();
        }
        JcLocalVariable local = this.method_converter.getLocalVariableConverter().getJcLocalVariable(java_local_index, this.java_instr);
        if (local == null) {
            throw new ConverterInternalError();
        }
        if (this.method_converter.getLocalVariableConverter().getDefinedLocalVariablesSize() == 0 && local.getType() != 3 && !local.isVarTypeKnown()) {
            this.method_converter.getLocalVariableConverter().updateJcLocalVariable(java_local_index, "I");
            local.setPromoted(true);
            throw new RecalculateIndexException(java_local_index);
        }
        int new_index = local.getJcIndex();
        int value_type = DataType.getType(constant);
        switch (value_type) {
            case 1: {
                jc_instr = new JcInstrIncrement(90, (short)new_index, (byte)constant);
                break;
            }
            case 2: {
                jc_instr = new JcInstrIncrement(151, (short)new_index, (short)constant);
                jc_instr.setWideInstr(true);
                break;
            }
            default: {
                throw new ConverterInternalError();
            }
        }
        return jc_instr;
    }
}

