/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.exportfile;

import com.sun.javacard.basicstructure.PackageDefinition;
import com.sun.javacard.converter.util.Strings;
import com.sun.javacard.exportfile.EfConstant;
import com.sun.javacard.exportfile.EfConstantPool;
import com.sun.javacard.exportfile.EfConstantUtf8;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class EfConstantPackage
extends EfConstant {
    private byte flags;
    private int name_index;
    private byte minor_version;
    private byte major_version;
    private byte[] aid;
    private String package_name;
    private EfConstantPool constant_pool;

    public EfConstantPackage(EfConstantPool cp) {
        this.constant_pool = cp;
    }

    public EfConstantPackage(EfConstantPool cp, PackageDefinition a_package, byte flags) {
        this.constant_pool = cp;
        this.flags = flags;
        this.minor_version = a_package.getPackageMinorVersion();
        this.major_version = a_package.getPackageMajorVersion();
        this.aid = a_package.getAID();
        this.package_name = a_package.getPackageName();
        EfConstant[] constants = cp.getConstants();
        for (int i = 0; i < constants.length; ++i) {
            EfConstantUtf8 utf8_constant;
            if (!(constants[i] instanceof EfConstantUtf8) || !(utf8_constant = (EfConstantUtf8)constants[i]).getUtf8String().equals(this.package_name)) continue;
            this.name_index = i;
            return;
        }
        this.name_index = this.constant_pool.addConstantUtf8(this.package_name);
    }

    public void parse(DataInputStream dis) throws IOException {
        this.flags = dis.readByte();
        this.name_index = dis.readUnsignedShort();
        this.minor_version = dis.readByte();
        this.major_version = dis.readByte();
        this.aid = new byte[dis.readUnsignedByte()];
        dis.readFully(this.aid);
    }

    public void resolve() {
        this.package_name = this.constant_pool.getConstantUtf8(this.name_index).getUtf8String();
    }

    public void toText(PrintWriter pw, int tab_level) throws IOException {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < tab_level; ++i) {
            sb.append("\t");
        }
        String indent = sb.toString();
        pw.println(indent + "CONSTANT_Package_info {");
        pw.println(indent + "\ttag\t" + 13);
        pw.println(indent + "\tflags\t" + Integer.toHexString(this.flags));
        pw.println(indent + "\tname_index\t" + this.name_index + "\t\t// " + this.package_name);
        pw.println(indent + "\tminor_version\t" + this.minor_version);
        pw.println(indent + "\tmajor_version\t" + this.major_version);
        pw.println(indent + "\taid_length\t" + this.aid.length);
        pw.println(indent + "\taid\t" + Strings.toHexString(this.aid, ":"));
        pw.println(indent + "}");
    }

    public void toBinary(DataOutputStream dos) throws IOException {
        dos.writeByte(13);
        dos.writeByte(this.flags);
        dos.writeShort(this.name_index);
        dos.writeByte(this.minor_version);
        dos.writeByte(this.major_version);
        dos.writeByte(this.aid.length);
        dos.write(this.aid, 0, this.aid.length);
    }

    public int getNameIndex() {
        return this.name_index;
    }

    public byte getMinorVersion() {
        return this.minor_version;
    }

    public byte getMajorVersion() {
        return this.major_version;
    }

    public byte[] getAID() {
        return this.aid;
    }

    public String getPackageName() {
        return this.package_name;
    }
}

