/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.converter.util.Strings;
import com.sun.javacard.jcasm.Assert;
import com.sun.javacard.jcasm.ClassIdentifier;
import com.sun.javacard.jcasm.Field;
import com.sun.javacard.jcasm.FieldIdentifier;
import com.sun.javacard.jcasm.InterfaceTable;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Member;
import com.sun.javacard.jcasm.MethodIdentifier;
import com.sun.javacard.jcasm.MethodTable;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.PackageIdentifier;
import com.sun.javacard.jcasm.RemoteMethodInfo;
import com.sun.javacard.jcasm.Sortable;
import com.sun.javacard.jcasm.SuperInterface;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class JCClass
extends Member
implements Sortable {
    public static final int MAX_INTERFACES = 15;
    public static final int MAX_FIELDS = 255;
    public static final int ACC_INTERFACE = 128;
    public static final int ACC_SHAREABLE = 64;
    public static final int ACC_REMOTE = 32;
    protected ClassIdentifier classId;
    protected JCPackage parentPackage;
    protected JCClass superClass;
    protected String superClassName;
    protected ClassIdentifier superClassIdentifier;
    protected Vector fieldVector;
    protected boolean isShareable;
    protected boolean remoteFlag;
    public MethodTable publicMethodTable;
    public MethodTable packageMethodTable;
    public Vector interfaceVector;
    public Vector remoteInterfaceVector;
    public Vector superInterfaceVector;
    protected int referenceCount;
    protected int firstReferenceToken;
    protected int instanceSize;
    protected Vector methodVector;
    public Hashtable methodSymbolTable;
    public Hashtable fieldSymbolTable;
    public Vector remoteMethods;
    Vector methodhashes = new Vector();
    private String hashAntiCollisionString = null;
    public static final byte STRING_MAX = 127;
    public static final byte STRING_MIN = 0;
    boolean noMethodHashCollisions = true;

    public JCClass(JCPackage parentPackage, int modifier, String name, ClassIdentifier id, int line) {
        super(modifier, name, line, 0);
        Assert.PreCondition(id != null, "id != null");
        this.parentPackage = parentPackage;
        this.classId = id;
        this.methodSymbolTable = new Hashtable();
        this.fieldSymbolTable = new Hashtable();
        this.fieldVector = new Vector();
        this.interfaceVector = new Vector(4);
        this.remoteInterfaceVector = new Vector(4);
        this.methodVector = new Vector();
        this.firstReferenceToken = 255;
        this.isShareable = false;
        if (Modifier.isInterface(modifier)) {
            this.superInterfaceVector = new Vector();
        }
        this.remoteMethods = new Vector();
    }

    void processRemoteMethodInfo() {
        for (int i = 0; i < this.remoteInterfaceVector.size(); ++i) {
            InterfaceTable inter = (InterfaceTable)this.remoteInterfaceVector.elementAt(i);
            Vector nameDescVector = inter.getNameDescrVector();
            Vector tokenVector = inter.getIndexVector();
            Assert.PreCondition(nameDescVector.size() == tokenVector.size(), "NameTableSize == TokenTableSize");
            for (int j = 0; j < tokenVector.size(); ++j) {
                String nameAndDescr = (String)nameDescVector.elementAt(j);
                int token = (Integer)tokenVector.elementAt(j);
                if (this.findRemoteMethodWithToken(token)) continue;
                RemoteMethodInfo rmi = new RemoteMethodInfo(nameAndDescr, token, this);
                this.remoteMethods.add(rmi);
            }
        }
        this.resolveMethodHashes();
        this.remoteMethods = this.sortRemoteMethods();
    }

    boolean findRemoteMethodWithToken(int token) {
        for (int i = 0; i < this.remoteMethods.size(); ++i) {
            byte rmt = ((RemoteMethodInfo)this.remoteMethods.elementAt((int)i)).flagAndToken;
            if (rmt != token) continue;
            return true;
        }
        return false;
    }

    public ClassIdentifier getClassIdentifier() {
        return this.classId;
    }

    public JCPackage getParentPackage() {
        return this.parentPackage;
    }

    public void setSuperClass(JCClass c) {
        this.superClass = c;
        this.superClassName = c.getName();
        this.superClassIdentifier = c.getClassIdentifier();
    }

    public JCClass getSuperClass() {
        return this.superClass;
    }

    public void setSuperClassName(String str) {
        this.superClassName = str;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public void setSuperClassIdentifier(ClassIdentifier id) {
        this.superClassIdentifier = id;
    }

    public ClassIdentifier getSuperClassIdentifier() {
        return this.superClassIdentifier;
    }

    public void addMethod(JCMethod jcMethod) {
        Assert.PreCondition(jcMethod != null, "jcMethod != null");
        String name = jcMethod.getName();
        if (this.methodSymbolTable.containsKey(name)) {
            Object[] arguments = new Object[]{name, this.name};
            Msg.error("class.1", arguments);
            return;
        }
        if (Modifier.isInterface(this.attributes) && !Modifier.isAbstract(jcMethod.getAttributes())) {
            Object[] arguments = new Object[]{jcMethod.getName(), this.name};
            Msg.error("class.9", arguments);
            return;
        }
        MethodIdentifier mid = jcMethod.getMethodIdentifier();
        if (mid != null) {
            if (this.methodSymbolTable.containsKey(mid)) {
                Object[] arguments = new Object[]{new Integer(mid.getMethodToken()), this.name};
                Msg.error("class.2", arguments);
                return;
            }
            this.methodSymbolTable.put(mid, jcMethod);
        }
        jcMethod.methodFixup();
        this.methodSymbolTable.put(name, jcMethod);
        this.methodVector.addElement(jcMethod);
    }

    public Enumeration methodElements() {
        return this.methodVector.elements();
    }

    public void addField(Field field) {
        Assert.PreCondition(field != null, "field != null");
        String name = field.getName();
        if (this.fieldSymbolTable.containsKey(name)) {
            Object[] arguments = new Object[]{name, this.name};
            Msg.error("class.3", arguments);
            return;
        }
        if (!(!Modifier.isInterface(this.attributes) || Modifier.isFinal(field.getAttributes()) && Modifier.isStatic(field.getAttributes()))) {
            Object[] arguments = new Object[]{field.getName(), this.name};
            Msg.error("class.10", arguments);
            return;
        }
        FieldIdentifier fid = field.getFieldIdentifier();
        if (fid != null) {
            if (this.fieldSymbolTable.containsKey(fid)) {
                Object[] arguments = new Object[]{new Integer(fid.getFieldToken()), this.name};
                Msg.error("class.4", arguments);
                return;
            }
            this.fieldSymbolTable.put(fid, field);
        }
        this.fieldSymbolTable.put(name, field);
        this.fieldVector.addElement(field);
    }

    public Enumeration fieldElements() {
        return this.fieldVector.elements();
    }

    public int getInstanceSize() {
        return this.instanceSize;
    }

    public int getFirstReferenceToken() {
        return this.firstReferenceToken;
    }

    public int getReferenceCount() {
        return this.referenceCount;
    }

    public boolean isShareable() {
        return this.isShareable;
    }

    public boolean isExported() {
        boolean exported = false;
        if (!Modifier.isPublic(this.attributes) && !Modifier.isProtected(this.attributes)) {
            exported = false;
        }
        if (this.parentPackage.appletCount() == 0 || this.isShareable() && Modifier.isInterface(this.attributes)) {
            exported = true;
        }
        return exported;
    }

    void makeShareable() {
        this.isShareable = true;
    }

    public int getInstanceBase() {
        int base = 0;
        for (JCClass c = this.getSuperClass(); c != null; c = c.getSuperClass()) {
            base += c.getInstanceSize();
        }
        return base;
    }

    public int compare(Object other) {
        JCClass currentClass;
        JCClass otherClass = (JCClass)other;
        if (Modifier.isInterface(otherClass.getAttributes()) && !Modifier.isInterface(this.getAttributes())) {
            return 1;
        }
        if (!Modifier.isInterface(otherClass.getAttributes()) && Modifier.isInterface(this.getAttributes())) {
            return -1;
        }
        for (currentClass = otherClass; currentClass != null; currentClass = currentClass.getSuperClass()) {
            if (!currentClass.equals(this)) continue;
            return -1;
        }
        for (currentClass = this; currentClass != null; currentClass = currentClass.getSuperClass()) {
            if (!currentClass.equals(otherClass)) continue;
            return 1;
        }
        return 0;
    }

    public void sortFields() {
        this.instanceSize = 0;
        this.firstReferenceToken = 255;
        this.referenceCount = 0;
        int maxField = this.fieldVector.size() * 2;
        Field[][] staticFields = new Field[4][maxField];
        Field[] instanceFields = new Field[maxField];
        int i = 0;
        int j = 0;
        int k = 0;
        int l = 0;
        Enumeration e = this.fieldVector.elements();
        while (e.hasMoreElements()) {
            Object[] args;
            Field field = (Field)e.nextElement();
            int mod = field.getAttributes();
            if (Modifier.isStatic(mod)) {
                if (!field.getDescriptor().isPrimitive()) {
                    if (field.getDescriptor().isArray() && field.getFieldInitializer() != null) {
                        staticFields[0][i++] = field;
                        continue;
                    }
                    staticFields[1][j++] = field;
                    continue;
                }
                if (field.getFieldInitializer() == null) {
                    staticFields[2][k++] = field;
                    continue;
                }
                staticFields[3][l++] = field;
                continue;
            }
            int token = field.getFieldIdentifier().getFieldToken();
            if (token > maxField) {
                args = new Object[]{field.getName(), field.getParentClass().getName()};
                Msg.error("class.7", args);
                continue;
            }
            if (instanceFields[token] != null) {
                args = new Object[]{field.getName(), field.getParentClass().getName()};
                Msg.error("class.8", args);
                continue;
            }
            instanceFields[token] = field;
        }
        Vector<Field> nVec = new Vector<Field>(this.fieldVector.size());
        for (int m = 0; m < 4; ++m) {
            int n = 0;
            while (n < staticFields[0].length && staticFields[m][n] != null) {
                nVec.addElement(staticFields[m][n++]);
            }
        }
        int expectedToken = 0;
        for (int m = 0; m < instanceFields.length; ++m) {
            Field field = instanceFields[m];
            if (field == null) continue;
            int token = field.getFieldIdentifier().getFieldToken();
            int size = Math.max(2, field.size()) / 2;
            if (token != expectedToken) {
                Object[] args = new Object[]{field.getName(), field.getParentClass().getName()};
                Msg.error("class.7", args);
            }
            expectedToken = token + size;
            if (!field.getDescriptor().isPrimitive()) {
                ++this.referenceCount;
                if (this.firstReferenceToken == 255) {
                    this.firstReferenceToken = token;
                }
            }
            this.instanceSize += size;
            nVec.addElement(field);
        }
        this.fieldVector = nVec;
    }

    public void addInterface(InterfaceTable inter) {
        Assert.PreCondition(inter != null, "inter != null");
        if (this.interfaceVector.size() >= 15) {
            Object[] arguments = new Object[]{this.name};
            Msg.error("class.5", arguments);
        }
        this.interfaceVector.addElement(inter);
    }

    public void addRemoteInterface(InterfaceTable inter) {
        Assert.PreCondition(inter != null, "inter != null");
        if (this.remoteInterfaceVector.size() >= 15) {
            Object[] arguments = new Object[]{this.name};
            Msg.error("class.5", arguments);
        }
        this.remoteInterfaceVector.addElement(inter);
    }

    public void addSuperInterface(String name) {
        Assert.PreCondition(Modifier.isInterface(this.attributes), "!isInterface");
        this.superInterfaceVector.addElement(new SuperInterface(this, name));
    }

    public void addSuperInterface(ClassIdentifier cid) {
        Assert.PreCondition(Modifier.isInterface(this.attributes), "!isInterface");
        this.superInterfaceVector.addElement(new SuperInterface(this, cid));
    }

    public Enumeration interfaceElements() {
        return this.interfaceVector.elements();
    }

    public Enumeration remoteInterfaceElements() {
        return this.remoteInterfaceVector.elements();
    }

    public Enumeration superInterfaceElements() {
        return this.superInterfaceVector.elements();
    }

    public void setRemote(boolean flag) {
        this.remoteFlag = flag;
        if (flag) {
            this.parentPackage.set22Flag();
        }
    }

    public boolean isInterface() {
        return Modifier.isInterface(this.attributes);
    }

    public boolean isRemote() {
        return this.remoteFlag;
    }

    public byte[] toByteArray() {
        byte[] record;
        block21: {
            int addr;
            JCMethod m;
            int flags;
            int index;
            block20: {
                record = new byte[this.size()];
                index = 0;
                int n = flags = this.isShareable ? 64 : 0;
                if (this.isRemote()) {
                    flags |= 0x20;
                }
                if (!Modifier.isInterface(this.attributes)) break block20;
                record[index++] = (byte)((flags |= 0x80) | this.superInterfaceVector.size() & 0xF);
                Enumeration e = this.superInterfaceVector.elements();
                while (e.hasMoreElements()) {
                    SuperInterface s = (SuperInterface)e.nextElement();
                    if (s.isResolved()) {
                        int addr2 = s.resolve().getRelocAddr();
                        record[index++] = (byte)(addr2 >> 8 & 0xFF);
                        record[index++] = (byte)(addr2 & 0xFF);
                        continue;
                    }
                    ClassIdentifier cid = s.getClassIdentifier();
                    PackageIdentifier pid = cid.getPackageIdentifier();
                    record[index++] = (byte)(this.parentPackage.getPackageToken(pid) | 0x80);
                    record[index++] = (byte)cid.getClassToken();
                }
                if (!this.isRemote()) break block21;
                String interfaceName = this.getName();
                interfaceName = interfaceName.substring(interfaceName.lastIndexOf("/") + 1);
                byte[] utf8Bytes = interfaceName.getBytes();
                record[index++] = (byte)utf8Bytes.length;
                for (int i = 0; i < utf8Bytes.length; ++i) {
                    record[index++] = utf8Bytes[i];
                }
                break block21;
            }
            record[index++] = (byte)(flags | this.interfaceVector.size() & 0xF);
            if (this.superClass == null && this.superClassIdentifier == null) {
                record[index++] = -1;
                record[index++] = -1;
            } else if (this.superClass == null) {
                PackageIdentifier pid = this.superClassIdentifier.getPackageIdentifier();
                record[index++] = (byte)(this.parentPackage.getPackageToken(pid) | 0x80);
                record[index++] = (byte)this.superClassIdentifier.getClassToken();
            } else {
                int addr3 = this.superClass.getRelocAddr();
                record[index++] = (byte)(addr3 >> 8 & 0xFF);
                record[index++] = (byte)(addr3 & 0xFF);
            }
            record[index++] = (byte)this.instanceSize;
            record[index++] = (byte)this.firstReferenceToken;
            record[index++] = (byte)this.referenceCount;
            record[index++] = (byte)this.publicMethodTable.getBase();
            record[index++] = (byte)this.publicMethodTable.getCount();
            record[index++] = (byte)this.packageMethodTable.getBase();
            record[index++] = (byte)this.packageMethodTable.getCount();
            Enumeration e = this.publicMethodTable.elements();
            while (e.hasMoreElements()) {
                m = (JCMethod)e.nextElement();
                if (m != null) {
                    addr = m.getRelocAddr();
                    record[index++] = (byte)(addr >> 8 & 0xFF);
                    record[index++] = (byte)(addr & 0xFF);
                    continue;
                }
                record[index++] = -1;
                record[index++] = -1;
            }
            e = this.packageMethodTable.elements();
            while (e.hasMoreElements()) {
                m = (JCMethod)e.nextElement();
                Assert.Assert(m != null, "m!= null");
                addr = m.getRelocAddr();
                record[index++] = (byte)(addr >> 8 & 0xFF);
                record[index++] = (byte)(addr & 0xFF);
            }
            e = this.interfaceVector.elements();
            while (e.hasMoreElements()) {
                InterfaceTable i = (InterfaceTable)e.nextElement();
                byte[] table = i.toByteArray();
                System.arraycopy(table, 0, record, index, table.length);
                index += table.length;
            }
            if (this.isRemote()) {
                record[index++] = (byte)this.remoteMethods.size();
                if (this.remoteMethods.size() > 0) {
                    Enumeration g = this.remoteMethods.elements();
                    while (g.hasMoreElements()) {
                        RemoteMethodInfo rmi = (RemoteMethodInfo)g.nextElement();
                        int remoteMethodSignatureOffset = this.getParentPackage().getSignaturePool().getAddressForOffset(rmi.methodSigOffset);
                        record[index++] = (byte)(rmi.remoteMethodHash >> 8 & 0xFF);
                        record[index++] = (byte)(rmi.remoteMethodHash & 0xFF);
                        record[index++] = (byte)(remoteMethodSignatureOffset >> 8 & 0xFF);
                        record[index++] = (byte)(remoteMethodSignatureOffset & 0xFF);
                        record[index++] = rmi.flagAndToken;
                    }
                }
                if (this.hashAntiCollisionString != null) {
                    byte[] stringData = this.hashAntiCollisionString.getBytes();
                    record[index++] = (byte)stringData.length;
                    for (int i = 0; i < stringData.length; ++i) {
                        record[index++] = stringData[i];
                    }
                } else {
                    record[index++] = 0;
                }
                String className = this.getName();
                className = className.substring(className.lastIndexOf("/") + 1);
                byte[] nameBytes = className.getBytes();
                int classNameLength = nameBytes.length;
                record[index++] = (byte)classNameLength;
                for (int i = 0; i < classNameLength; ++i) {
                    record[index++] = nameBytes[i];
                }
                record[index++] = (byte)this.remoteInterfaceVector.size();
                Enumeration e2 = this.remoteInterfaceVector.elements();
                while (e2.hasMoreElements()) {
                    InterfaceTable i = (InterfaceTable)e2.nextElement();
                    byte[] table = i.remoteInterfaceToByteArray();
                    System.arraycopy(table, 0, record, index, table.length);
                    index += table.length;
                }
            }
        }
        return record;
    }

    public Vector sortRemoteMethods() {
        Vector<RemoteMethodInfo> sortedVector = new Vector<RemoteMethodInfo>();
        while (this.remoteMethods.size() > 0) {
            sortedVector.addElement(this.getMethodWithSmallestHash());
        }
        return sortedVector;
    }

    private RemoteMethodInfo getMethodWithSmallestHash() {
        RemoteMethodInfo smallestHashMethod = (RemoteMethodInfo)this.remoteMethods.elementAt(0);
        int oldHash = smallestHashMethod.remoteMethodHash & Integer.MAX_VALUE;
        for (int i = 1; i < this.remoteMethods.size(); ++i) {
            RemoteMethodInfo rmi = (RemoteMethodInfo)this.remoteMethods.elementAt(i);
            int newHash = rmi.remoteMethodHash & Integer.MAX_VALUE;
            if (oldHash <= newHash) continue;
            smallestHashMethod = rmi;
            oldHash = newHash;
        }
        this.remoteMethods.removeElement(smallestHashMethod);
        return smallestHashMethod;
    }

    public int size() {
        if (Modifier.isInterface(this.attributes)) {
            int size = 1 + this.superInterfaceVector.size() * 2;
            if (this.isRemote()) {
                String interfaceName = this.name.substring(this.name.lastIndexOf("/") + 1);
                size += interfaceName.getBytes().length + 1;
            }
            return size;
        }
        int size = 10 + 2 * this.packageMethodTable.getCount() + 2 * this.publicMethodTable.getCount();
        Enumeration e = this.interfaceVector.elements();
        while (e.hasMoreElements()) {
            InterfaceTable i = (InterfaceTable)e.nextElement();
            size += i.size();
        }
        if (this.isRemote()) {
            String className = this.name.substring(this.name.lastIndexOf("/") + 1);
            size += 1 + this.remoteMethods.size() * 5;
            size = this.hashAntiCollisionString != null ? (size += this.hashAntiCollisionString.getBytes().length + 1) : ++size;
            size += className.getBytes().length + 1;
            size += this.remoteInterfaceVector.size() * 2 + 1;
        }
        return size;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (Modifier.isInterface(this.attributes)) {
            sb.append(".interface");
        } else {
            sb.append(".class");
        }
        sb.append(" " + super.toString());
        if (this.classId != null) {
            sb.append(" <" + this.classId + ">");
        }
        sb.append(" {" + Msg.eol);
        sb.append(".fields {" + Msg.eol);
        Enumeration e = this.fieldElements();
        while (e.hasMoreElements()) {
            Field f = (Field)e.nextElement();
            sb.append(f + ";" + Msg.eol);
        }
        sb.append("}" + Msg.eol);
        if (this.publicMethodTable != null) {
            sb.append("public method table base: " + this.publicMethodTable.getBase() + ", ");
            sb.append("public method table count: " + this.publicMethodTable.getCount() + Msg.eol);
            e = this.publicMethodTable.elements();
            while (e.hasMoreElements()) {
                e.nextElement();
            }
        }
        if (this.packageMethodTable != null) {
            sb.append("package method table base: " + this.packageMethodTable.getBase() + ", ");
            sb.append("package method table count: " + this.packageMethodTable.getCount() + Msg.eol);
            e = this.publicMethodTable.elements();
            while (e.hasMoreElements()) {
                e.nextElement();
            }
        }
        e = this.interfaceVector.elements();
        while (e.hasMoreElements()) {
            InterfaceTable i = (InterfaceTable)e.nextElement();
            sb.append(i + Msg.eol);
        }
        e = this.methodVector.elements();
        while (e.hasMoreElements()) {
            JCMethod m = (JCMethod)e.nextElement();
            sb.append(m);
        }
        sb.append("}" + Msg.eol);
        return sb.toString();
    }

    public String getAntiHashCollisionString() {
        this.resolveMethodHashes();
        return this.hashAntiCollisionString;
    }

    public void resolveMethodHashes() {
        if (this.noMethodHashCollisions) {
            return;
        }
        int stringIndex = 0;
        byte[] stringBytes = new byte[]{0};
        this.methodhashes.removeAllElements();
        for (int i = 0; i < this.remoteMethods.size(); ++i) {
            this.hashAntiCollisionString = new String(stringBytes);
            RemoteMethodInfo rm = (RemoteMethodInfo)this.remoteMethods.elementAt(i);
            Short tempHash = new Short(Strings.computeShortHash(this.hashAntiCollisionString + rm.methodNameAndDesc));
            if (this.methodhashes.indexOf(tempHash) < 0) {
                this.methodhashes.addElement(tempHash);
                rm.remoteMethodHash = tempHash;
                this.noMethodHashCollisions = true;
                continue;
            }
            this.methodhashes.removeAllElements();
            i = -1;
            this.hashAntiCollisionString = null;
            this.noMethodHashCollisions = false;
            if (stringBytes[stringIndex] == 127) {
                Object[] args = new Object[]{this.getName()};
                Msg.error("cap.4", args);
                System.exit(1);
                continue;
            }
            int n = stringIndex;
            stringBytes[n] = (byte)(stringBytes[n] + 1);
        }
    }
}

