/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.mask.jrefmask;

import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.mask.OutputFormatter;
import com.sun.javacard.jcasm.mask.RomMask;
import com.sun.javacard.jcasm.mask.jrefmask.PersistentState;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class JrefOutputFormatter
extends OutputFormatter {
    PersistentState ps;
    Vector zipEntries;
    Vector dataVector = new Vector();

    public JrefOutputFormatter(BufferedReader configFile) throws IOException {
        super(configFile);
        this.zipEntries = new Vector();
        this.ps = new PersistentState(this.getProperties());
    }

    public void format(RomMask r) {
        this.ps.formatPS(r);
    }

    public void write(OutputStream s) throws IOException {
        ZipOutputStream zipOut = (ZipOutputStream)s;
        ByteArrayOutputStream finalBos = new ByteArrayOutputStream();
        DataOutputStream finalDos = new DataOutputStream(finalBos);
        this.ps.write(finalDos);
        this.createZipEntry(finalBos.toByteArray(), "Persistent.data", false);
        for (int i = 0; i < this.zipEntries.size(); ++i) {
            zipOut.putNextEntry((ZipEntry)this.zipEntries.elementAt(i));
            byte[] data = (byte[])this.dataVector.elementAt(i);
            zipOut.write(data, 0, data.length);
        }
        finalDos.flush();
        finalDos.close();
        finalBos.flush();
        finalBos.close();
    }

    public void createZipEntry(byte[] data, String entryName, boolean isDebugInfo) {
        ZipEntry ze = new ZipEntry(entryName);
        ze.setMethod(0);
        ze.setSize(data.length);
        ze.setTime(System.currentTimeMillis());
        CRC32 crc = new CRC32();
        crc.update(data, 0, data.length);
        ze.setCrc(crc.getValue());
        if (isDebugInfo) {
            this.zipEntries.add(ze);
            this.dataVector.add(data);
        } else {
            this.zipEntries.insertElementAt(ze, 0);
            this.dataVector.insertElementAt(data, 0);
        }
    }

    public void writeDebugInfo(Vector debugFiles) {
        try {
            Enumeration e = debugFiles.elements();
            while (e.hasMoreElements()) {
                File inFile = (File)e.nextElement();
                this.mergeDebugLocations(inFile, this.ps.maskSymbols.getTable());
            }
        }
        catch (FileNotFoundException e) {
            System.err.println(e);
            System.exit(1);
        }
        catch (IOException e) {
            Msg.error("jref.1", null);
            System.exit(1);
        }
    }

    private void mergeDebugLocations(File debugCompFile, Map symtab) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(debugCompFile)));
        String packageName = this.mergeDebugComponent(dis, dos, symtab);
        bos.flush();
        byte[] data = bos.toByteArray();
        this.createZipEntry(data, packageName + "/javacard/debug.cap", true);
    }

    private String mergeDebugComponent(DataInputStream dis, DataOutputStream dos, Map symtab) throws IOException {
        dos.writeByte(dis.readUnsignedByte());
        dos.writeShort(dis.readUnsignedShort());
        int string_count = dis.readUnsignedShort();
        dos.writeShort(string_count);
        String[] strings = new String[string_count];
        for (int s = 0; s < string_count; ++s) {
            strings[s] = dis.readUTF();
            dos.writeUTF(strings[s]);
        }
        int package_name_index = dis.readUnsignedShort();
        dos.writeShort(package_name_index);
        int class_count = dis.readUnsignedShort();
        dos.writeShort(class_count);
        for (int c = 0; c < class_count; ++c) {
            this.mergeClassDebugInfo(dis, dos, strings, symtab);
        }
        return strings[package_name_index];
    }

    private void mergeClassDebugInfo(DataInputStream dis, DataOutputStream dos, String[] strings, Map symtab) throws IOException {
        int name_index = dis.readUnsignedShort();
        dos.writeShort(name_index);
        dos.writeShort(dis.readUnsignedShort());
        dis.readUnsignedShort();
        String name = strings[name_index];
        String offset = (String)symtab.get("CLASS:" + name);
        int offsetValue = Integer.parseInt(offset, 16);
        dos.writeShort(offsetValue);
        dos.writeShort(dis.readUnsignedShort());
        dos.writeShort(dis.readUnsignedShort());
        int interface_count = dis.readUnsignedByte();
        dos.writeByte(interface_count);
        int field_count = dis.readUnsignedShort();
        dos.writeShort(field_count);
        int method_count = dis.readUnsignedShort();
        dos.writeShort(method_count);
        for (int i = 0; i < interface_count; ++i) {
            dos.writeShort(dis.readUnsignedShort());
        }
        for (int f = 0; f < field_count; ++f) {
            this.mergeFieldDebugInfo(dis, dos, strings, symtab, name);
        }
        for (int m = 0; m < method_count; ++m) {
            this.mergeMethodDebugInfo(dis, dos, strings, symtab, name);
        }
    }

    private void mergeMethodDebugInfo(DataInputStream dis, DataOutputStream dos, String[] strings, Map symtab, String className) throws IOException {
        int ACC_ABSTRACT = 1024;
        int name_index = dis.readUnsignedShort();
        dos.writeShort(name_index);
        int descriptor_index = dis.readUnsignedShort();
        dos.writeShort(descriptor_index);
        int access_flags = dis.readUnsignedShort();
        dos.writeShort(access_flags);
        boolean isAbstract = (access_flags & 0x400) != 0;
        dis.readUnsignedShort();
        if (isAbstract) {
            dos.writeShort(0);
        } else {
            String name = strings[name_index];
            String descriptor = strings[descriptor_index];
            String signature = className + "/" + name + descriptor;
            String offset = (String)symtab.get("METHOD:" + signature);
            int offsetValue = Integer.parseInt(offset, 16);
            dos.writeShort(offsetValue);
        }
        dos.writeByte(dis.readUnsignedByte());
        dos.writeShort(dis.readUnsignedShort());
        int variable_count = dis.readUnsignedShort();
        dos.writeShort(variable_count);
        int line_count = dis.readUnsignedShort();
        dos.writeShort(line_count);
        for (int v = 0; v < variable_count; ++v) {
            dos.writeByte(dis.readUnsignedByte());
            dos.writeShort(dis.readUnsignedShort());
            dos.writeShort(dis.readUnsignedShort());
            dos.writeShort(dis.readUnsignedShort());
            dos.writeShort(dis.readUnsignedShort());
        }
        for (int k = 0; k < line_count; ++k) {
            dos.writeShort(dis.readUnsignedShort());
            dos.writeShort(dis.readUnsignedShort());
            dos.writeShort(dis.readUnsignedShort());
        }
    }

    private void mergeFieldDebugInfo(DataInputStream dis, DataOutputStream dos, String[] strings, Map symtab, String className) throws IOException {
        int ACC_STATIC = 8;
        int ACC_FINAL = 16;
        int name_index = dis.readUnsignedShort();
        dos.writeShort(name_index);
        int descriptor_index = dis.readUnsignedShort();
        dos.writeShort(descriptor_index);
        int access_flags = dis.readUnsignedShort();
        dos.writeShort(access_flags);
        boolean isStatic = (access_flags & 8) != 0;
        boolean isFinal = (access_flags & 0x10) != 0;
        boolean isPrimitive = strings[descriptor_index].length() == 1;
        if (isStatic & !(isFinal & isPrimitive)) {
            dos.writeShort(dis.readUnsignedShort());
            dis.readUnsignedShort();
            String name = className + "/" + strings[name_index];
            String offset = (String)symtab.get("FIELD:" + name);
            int offsetValue = Integer.parseInt(offset, 16);
            dos.writeShort(offsetValue);
        } else {
            dos.writeInt(dis.readInt());
        }
    }
}

