/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcapiandbcprofiler;

import com.sun.javacard.jcapiandbcprofiler.CryptoAlgorithmInfo;
import com.sun.javacard.jcapiandbcprofiler.CryptoAlgorithmList;
import com.sun.javacard.jcapiandbcprofiler.CryptoCallAnalyzer;
import com.sun.javacard.jcapiandbcprofiler.UsedAPI;
import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ClassDescriptor;
import com.sun.javacard.offcardverifier.ClassInfo;
import com.sun.javacard.offcardverifier.Classref;
import com.sun.javacard.offcardverifier.ConstantPoolEntry;
import com.sun.javacard.offcardverifier.ExnHandler;
import com.sun.javacard.offcardverifier.ExnHandlerInfo;
import com.sun.javacard.offcardverifier.ImplementedInterface;
import com.sun.javacard.offcardverifier.Instr;
import com.sun.javacard.offcardverifier.MethodDescriptor;
import com.sun.javacard.offcardverifier.MethodInfo;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.TypeClass;
import com.sun.javacard.offcardverifier.TypeMethod;
import com.sun.javacard.offcardverifier.Verifier;
import com.sun.javacard.offcardverifier.exportfile.EfClass;
import com.sun.javacard.offcardverifier.exportfile.EfField;
import com.sun.javacard.offcardverifier.exportfile.EfMethod;
import com.sun.javacard.offcardverifier.exportfile.ExportFile;
import java.io.File;
import java.io.FileInputStream;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassicCAPProcesssor {
    public static final String UNABLE_TO_DETERMINE_CRYPTO_ALGOS = "* Unable to determine all crypto algorithms used";
    Vector<int[]> cryptoMethodFinderPattern = new Vector();
    private Vector<String> usedByteCodes = new Vector();
    private Vector<String> unUsedByteCodes = new Vector();
    private Vector<String> usedCryptoAlgos = new Vector();
    private UsedAPI usedAPI = new UsedAPI();
    private boolean capProcessed = false;
    private Vector<String> apiPkgsList;
    private static final int LOOK_BACK_FOR_CIPHER_GET_INSTNACE_CIPHER = 3;
    private static final int LOOK_BACK_FOR_CIPHER_GET_INSTNACE_PAD = 2;
    private static final int LOOK_BACK_FOR_KEY_BUILDER_ALGORITHM = 4;
    private static final int LOOK_BACK_FOR_KEY_BUILDER_MEM = 3;
    private static final int LOOK_BACK_FOR_KEY_BUILDER_LENGTH = 2;
    private static final int LOOK_BACK_FOR_SIGNATURE_MD_ALGO = 4;
    private static final int LOOK_BACK_FOR_SIGNATURE_CIPHER_ALGO = 3;
    private static final int LOOK_BACK_FOR_SIGNATURE_PAD_ALGO = 2;

    public ClassicCAPProcesssor(File capFile, Vector<File> exportFiles, Vector<String> apiPkgList) throws Exception {
        FileInputStream fis = new FileInputStream(capFile);
        assert (fis != null);
        assert (exportFiles != null);
        try {
            Verifier.verifyCap((FileInputStream)fis, null, exportFiles);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.apiPkgsList = apiPkgList;
    }

    private boolean isApiClass(String className) {
        for (String apiPkgName : this.apiPkgsList) {
            if (!className.startsWith(apiPkgName)) continue;
            return true;
        }
        return false;
    }

    void checkAPICryptoMethod(int pkgToken, int classToken, int methodToken, String fullMethodNameAndSig) {
        if (fullMethodNameAndSig.equals("javacard.security.KeyBuilder.buildKey(BSZ)Ljavacard/security/Key;")) {
            this.cryptoMethodFinderPattern.add(new int[]{pkgToken, classToken, methodToken, 3});
        } else if (fullMethodNameAndSig.equals("javacard.security.KeyBuilder.buildKey(BBSZ)Ljavacard/security/Key;")) {
            this.cryptoMethodFinderPattern.add(new int[]{pkgToken, classToken, methodToken, -1});
        } else if (fullMethodNameAndSig.equals("javacard.security.MessageDigest.getInstance(BZ)Ljavacard/security/MessageDigest;")) {
            this.cryptoMethodFinderPattern.add(new int[]{pkgToken, classToken, methodToken, 2});
        } else if (fullMethodNameAndSig.equals("javacard.security.MessageDigest.getInitializedMessageDigestInstance(BZ)Ljavacard/security/InitializedMessageDigest;")) {
            this.cryptoMethodFinderPattern.add(new int[]{pkgToken, classToken, methodToken, 2});
        } else if (fullMethodNameAndSig.equals("javacard.security.Signature.getInstance(BZ)Ljavacard/security/Signature;")) {
            this.cryptoMethodFinderPattern.add(new int[]{pkgToken, classToken, methodToken, 2});
        } else if (fullMethodNameAndSig.equals("javacard.security.Signature.getInstance(BBBZ)Ljavacard/security/Signature;")) {
            this.cryptoMethodFinderPattern.add(new int[]{pkgToken, classToken, methodToken, -2});
        } else if (fullMethodNameAndSig.equals("javacard.security.Checksum.getInstance(BZ)Ljavacard/security/Checksum;")) {
            this.cryptoMethodFinderPattern.add(new int[]{pkgToken, classToken, methodToken, 2});
        } else if (fullMethodNameAndSig.equals("javacard.security.KeyAgreement.getInstance(BZ)Ljavacard/security/KeyAgreement;")) {
            this.cryptoMethodFinderPattern.add(new int[]{pkgToken, classToken, methodToken, 2});
        } else if (fullMethodNameAndSig.equals("javacard.security.RandomData.getInstance(B)Ljavacard/security/RandomData;")) {
            this.cryptoMethodFinderPattern.add(new int[]{pkgToken, classToken, methodToken, 1});
        } else if (fullMethodNameAndSig.equals("javacard.security.KeyPair.<init>(BS)V")) {
            this.cryptoMethodFinderPattern.add(new int[]{pkgToken, classToken, methodToken, 2});
        } else if (fullMethodNameAndSig.equals("javacardx.crypto.Cipher.getInstance(BZ)Ljavacardx/crypto/Cipher;")) {
            this.cryptoMethodFinderPattern.add(new int[]{pkgToken, classToken, methodToken, 2});
        } else if (fullMethodNameAndSig.equals("javacardx.crypto.Cipher.getInstance(BBZ)Ljavacardx/crypto/Cipher;")) {
            this.cryptoMethodFinderPattern.add(new int[]{pkgToken, classToken, methodToken, -3});
        }
    }

    private void processConstantPool() {
        int entryCount = Cap.ConstantPool.count();
        block5: for (int i = 0; i < entryCount; ++i) {
            ConstantPoolEntry entry = Cap.ConstantPool.entry(i);
            int tag = entry.tag();
            switch (tag) {
                case 1: {
                    EfClass ec;
                    int classref = entry.classRef();
                    if (!Classref.isExternal((int)classref) || !this.isApiClass((ec = Classref.checkExternal((int)classref)).toString())) continue block5;
                    this.usedAPI.add(ec.toString(), null);
                    continue block5;
                }
                case 2: 
                case 3: 
                case 4: {
                    EfClass ec;
                    int classref = entry.classRefVirtualRef();
                    if (!Classref.isExternal((int)classref) || !this.isApiClass((ec = Classref.checkExternal((int)classref)).toString())) continue block5;
                    if (tag == 2) {
                        EfField ef = ec.getFieldForTokenAndFlag(entry.tokenVirtualRef(), false);
                        this.usedAPI.add(ec.toString(), ef.toString());
                        continue block5;
                    }
                    EfMethod em = ec.getMethodForTokenAndFlag(entry.tokenVirtualRef(), false);
                    this.usedAPI.add(ec.toString(), em.toString());
                    continue block5;
                }
                case 5: 
                case 6: {
                    if (!entry.isExternalStaticRef()) continue block5;
                    int pkgTok = entry.externalStaticRefPackageToken();
                    int classToken = entry.externalStaticRefClassToken();
                    ExportFile ef = Cap.Import.exportfileForPackageToken(pkgTok);
                    EfClass ec = ef.findClassByToken((short)entry.externalStaticRefClassToken());
                    if (!this.isApiClass(ec.toString())) continue block5;
                    if (tag == 5) {
                        EfField afield = ec.getFieldForTokenAndFlag(entry.tokenStaticRef(), true);
                        this.usedAPI.add(ec.toString(), afield.toString());
                        continue block5;
                    }
                    EfMethod em = ec.getMethodForTokenAndFlag(entry.tokenStaticRef(), true);
                    this.checkAPICryptoMethod(pkgTok, classToken, entry.tokenStaticRef(), ec.toString() + "." + em.name() + em.sig());
                    this.usedAPI.add(ec.toString(), em.toString());
                }
            }
        }
    }

    private static void addExnHandlers(Safeptr startCode, Instr[] instrs, int firstExnHandler, int numExnHandlers) {
        for (int i = 0; i < numExnHandlers; ++i) {
            ExnHandlerInfo exn = Cap.Method.exceptionHandler(firstExnHandler + i);
            Safeptr startPc = Cap.Method.methodCode(exn.startOffset());
            Safeptr endPc = Cap.Method.methodCode(exn.endOffset());
            Safeptr handlerPc = Cap.Method.methodCode(exn.handlerOffset());
            int hdlrType = exn.catchType();
            int hdlrClass = hdlrType != 0 ? Cap.ConstantPool.entry(hdlrType).classRef() : Classref.Throwable;
            for (int j = startPc.ofs; j < endPc.ofs; ++j) {
                Instr instr = instrs[j - startCode.ofs];
                if (instr == null) continue;
                instr.handler = new ExnHandler(handlerPc.ofs - startCode.ofs, hdlrClass, instr.handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMethodComponent(ClassDescriptor cdesc) {
        int methodCount = cdesc.methodCount();
        for (int i = 0; i < methodCount; ++i) {
            Safeptr startCode;
            int maxLocals;
            int numParams;
            int maxStack;
            Safeptr byteCodesFromCAP;
            boolean isExtended;
            MethodDescriptor md = cdesc.methodDescr(i);
            TypeMethod mty = TypeMethod.parseCap((Safeptr)Cap.TypeDescr.at(md.type()));
            int flags = md.flags();
            boolean isInit = (flags & 0x80) != 0;
            TypeClass tySelf = (flags & 8) == 0 ? new TypeClass(cdesc.thisClass()) : null;
            if ((flags & 0x40) == 64) break;
            MethodInfo mi = Cap.Method.methodInfo(md.methodOffset());
            int methodFlagFromCap = mi.flags();
            boolean bl = isExtended = (methodFlagFromCap & 8) == 8;
            if (isExtended) {
                byteCodesFromCAP = mi.bytecodeExtended();
                maxStack = mi.maxStackExtended();
                numParams = mi.numArgsExtended();
                maxLocals = mi.maxLocalsExtended() + numParams;
                startCode = mi.bytecodeExtended();
            } else {
                byteCodesFromCAP = mi.bytecodeCompact();
                maxStack = mi.maxStackCompact();
                numParams = mi.numArgsCompact();
                maxLocals = mi.maxLocalsCompact() + numParams;
                startCode = mi.bytecodeCompact();
            }
            Instr[] instrs = Instr.instrsBetween((Safeptr)byteCodesFromCAP, (int)md.bytecodeCount());
            for (int j = 0; j < instrs.length; j += instrs[j].length()) {
                ConstantPoolEntry cpe;
                String instructionName = Instr.instrName[instrs[j].opcode];
                if (!this.usedByteCodes.contains(instructionName)) {
                    this.usedByteCodes.add(instructionName);
                }
                if (instrs[j].opcode == 142) {
                    EfClass ec;
                    cpe = Cap.ConstantPool.entry(instrs[j].arg);
                    int interfaceRef = cpe.classRef();
                    if (!Classref.isExternal((int)interfaceRef) || !this.isApiClass((ec = Classref.checkExternal((int)interfaceRef)).toString())) continue;
                    int token = instrs[j].arg2;
                    EfMethod m = ec.getMethodForTokenAndFlag(token, false);
                    if (m == null) {
                        m = ec.getMethodFromSupers(j, false);
                    }
                    if (m == null) continue;
                    this.usedAPI.add(ec.toString(), m.toString());
                    continue;
                }
                if (instrs[j].opcode != 141 || !(cpe = Cap.ConstantPool.entry(instrs[j].arg)).isExternalStaticRef()) continue;
                for (int[] entry : this.cryptoMethodFinderPattern) {
                    boolean result;
                    if (entry[0] != cpe.externalStaticRefPackageToken() || entry[1] != cpe.externalStaticRefClassToken() || entry[2] != cpe.tokenStaticRef() || (result = this.listCryptoAlgorithmUsed(instrs, entry, j))) continue;
                    CryptoCallAnalyzer.ccp = this;
                    int firstExnHandler = md.exnHandlerIndex();
                    int numExnHandlers = md.exnHandlerCount();
                    ClassicCAPProcesssor.addExnHandlers(startCode, instrs, firstExnHandler, numExnHandlers);
                    try {
                        CryptoCallAnalyzer.simulate(instrs, maxStack, maxLocals, mty, tySelf, isInit, new TypeClass(cdesc.thisClass()), md);
                    }
                    catch (Exception e) {}
                    finally {
                        for (String algoName : CryptoCallAnalyzer.cryptoAlgoNames) {
                            if (this.usedCryptoAlgos.contains(algoName)) continue;
                            this.usedCryptoAlgos.add(0, algoName);
                        }
                        if (CryptoCallAnalyzer.allCryptoAlgosFound || this.usedCryptoAlgos.contains(UNABLE_TO_DETERMINE_CRYPTO_ALGOS)) continue;
                        this.usedCryptoAlgos.add(0, UNABLE_TO_DETERMINE_CRYPTO_ALGOS);
                    }
                }
            }
        }
    }

    boolean isValidIntermediateInstruction(Instr anInstr) {
        switch (anInstr.opcode) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: {
                return true;
            }
        }
        return false;
    }

    Instr getInstr(int index, int lookback, Instr[] instrs) {
        int i = 1;
        int count = 0;
        while (count < lookback) {
            if (instrs[index - i] != null) {
                if (!this.isValidIntermediateInstruction(instrs[index - i])) {
                    return null;
                }
                if (++count == lookback) break;
            }
            ++i;
        }
        Instr anInstr = instrs[index - i];
        return anInstr;
    }

    boolean listCryptoAlgorithmUsed(Instr[] instrs, int[] info, int index) {
        switch (info[3]) {
            case -1: {
                return this.listFlexKeyBuilderAlgorithms(instrs, index, info[0], info[1]);
            }
            case -2: {
                return this.listFlexSignatureAlgorithms(instrs, index, info[0], info[1]);
            }
            case -3: {
                return this.listFlexCipherAlgorithms(instrs, index, info[0], info[1]);
            }
        }
        String name = this.getConstantFieldName(this.getInstr(index, info[3], instrs), info[0], info[1], CryptoAlgorithmInfo.TYPE_NON_FLEX);
        if (name == null) {
            return false;
        }
        if (!this.usedCryptoAlgos.contains(name)) {
            this.usedCryptoAlgos.add(name);
        }
        return true;
    }

    boolean listFlexCipherAlgorithms(Instr[] instrs, int index, int pkgToken, int classToken) {
        Instr instrForCipher = this.getInstr(index, 3, instrs);
        Instr instrForPadding = this.getInstr(index, 2, instrs);
        if (instrForCipher == null || instrForPadding == null) {
            return false;
        }
        String cipherAlgoName = this.getConstantFieldName(instrForCipher, "javacardx.crypto.Cipher", CryptoAlgorithmInfo.TYPE_FLEX_CIPHER_ALG);
        String paddingAlgoName = this.getConstantFieldName(instrForPadding, "javacardx.crypto.Cipher", CryptoAlgorithmInfo.TYPE_FLEX_PAD_ALG);
        if (cipherAlgoName == null || paddingAlgoName == null) {
            return false;
        }
        String fullName = cipherAlgoName + ", " + paddingAlgoName;
        if (!this.usedCryptoAlgos.contains(fullName)) {
            this.usedCryptoAlgos.add(fullName);
        }
        return true;
    }

    boolean listFlexKeyBuilderAlgorithms(Instr[] instrs, int index, int pkgToken, int classToken) {
        Instr instrForAlgo = this.getInstr(index, 4, instrs);
        Instr instrForMem = this.getInstr(index, 3, instrs);
        Instr instrForLength = this.getInstr(index, 2, instrs);
        if (instrForAlgo == null || instrForMem == null || instrForLength == null) {
            return false;
        }
        String algoName = this.getConstantFieldName(instrForAlgo, "javacard.security.KeyBuilder", CryptoAlgorithmInfo.TYPE_FLEX_CIPHER_ALG);
        String memType = this.getConstantFieldName(instrForMem, "javacard.security.KeyBuilder", CryptoAlgorithmInfo.TYPE_FLEX_MEM);
        String length = this.getConstantFieldName(instrForLength, "javacard.security.KeyBuilder", CryptoAlgorithmInfo.TYPE_FLEX_KEY_LENGTH);
        if (algoName == null || memType == null || length == null) {
            return false;
        }
        String fullName = algoName + ", " + memType + "," + length;
        if (!this.usedCryptoAlgos.contains(fullName)) {
            this.usedCryptoAlgos.add(fullName);
        }
        return true;
    }

    boolean listFlexSignatureAlgorithms(Instr[] instrs, int index, int pkgToken, int classToken) {
        Instr instrForMDAlgo = this.getInstr(index, 4, instrs);
        Instr instrForCipherAlgo = this.getInstr(index, 3, instrs);
        Instr instrForPadAlgo = this.getInstr(index, 2, instrs);
        if (instrForMDAlgo == null || instrForCipherAlgo == null || instrForPadAlgo == null) {
            return false;
        }
        String MDAlgoName = this.getConstantFieldName(instrForMDAlgo, "javacard.security.MessageDigest", CryptoAlgorithmInfo.TYPE_NON_FLEX);
        String cipherAlgoName = this.getConstantFieldName(instrForCipherAlgo, "javacard.security.Signature", CryptoAlgorithmInfo.TYPE_FLEX_CIPHER_ALG);
        String padAlgoName = this.getConstantFieldName(instrForPadAlgo, "javacardx.crypto.Cipher", CryptoAlgorithmInfo.TYPE_FLEX_PAD_ALG);
        if (padAlgoName == null || cipherAlgoName == null || MDAlgoName == null) {
            return false;
        }
        String fullName = MDAlgoName + ", " + cipherAlgoName + "," + padAlgoName;
        if (!this.usedCryptoAlgos.contains(fullName)) {
            this.usedCryptoAlgos.add(fullName);
        }
        return true;
    }

    int getConstantValue(Instr anInstr) {
        if (anInstr == null) {
            return -1;
        }
        switch (anInstr.opcode) {
            case 16: {
                return anInstr.arg;
            }
            case 17: {
                return anInstr.arg;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 6: {
                return 3;
            }
            case 7: {
                return 4;
            }
            case 8: {
                return 5;
            }
        }
        return -1;
    }

    String getConstantFieldName(Instr anInstr, String className, int type) {
        if (anInstr == null) {
            return null;
        }
        int value = this.getConstantValue(anInstr);
        if (value == -1) {
            return null;
        }
        return CryptoAlgorithmList.getAlgoName(value, className, type);
    }

    String getConstantFieldName(Instr anInstr, int pkgToken, int classToken, int type) {
        if (anInstr == null) {
            return null;
        }
        int value = this.getConstantValue(anInstr);
        if (value == -1) {
            return null;
        }
        ExportFile ef = Cap.Import.exportfileForPackageToken(pkgToken);
        EfClass ec = ef.findClassByToken((short)classToken);
        String className = ec.thisName().replace('/', '.');
        return CryptoAlgorithmList.getAlgoName(value, className, type);
    }

    private void getImplementedInterfacesForExternalSuperClass(EfClass ec) {
        int i;
        for (i = 0; i < ec.interfaces.length; ++i) {
            String name = ec.interfaceName(i);
            if (!this.isApiClass(name)) continue;
            this.usedAPI.add(name, null);
        }
        for (i = 0; i < ec.supers.length; ++i) {
            String superName = ec.superName(i);
            EfClass superClass = Classref.exportclassForName((String)superName);
            this.getImplementedInterfacesForExternalSuperClass(superClass);
        }
    }

    private void checkImplentedInterfaceMehods(ImplementedInterface intfc) {
        int count = intfc.count();
        int ref = intfc.interfaceImpl();
        EfClass ec = Classref.checkExternal((int)ref);
        for (int j = 0; j < count; ++j) {
            int tokenValue = intfc.indexMethod(j);
            if (tokenValue <= -1) continue;
            EfMethod m = ec.getMethodForTokenAndFlag(j, false);
            if (m == null) {
                m = ec.getMethodFromSupers(j, false);
            }
            if (m == null) continue;
            this.usedAPI.add(ec.toString(), m.toString());
        }
    }

    private void CheckAPIInterfacesForClass(ClassInfo cinfo) {
        int superRef = cinfo.superclass();
        do {
            int count;
            if ((count = cinfo.interfaceCount()) > 0) {
                ImplementedInterface intfc = cinfo.firstImplementedInterface();
                do {
                    EfClass ec;
                    if (Classref.isExternal((int)intfc.interfaceImpl()) && this.isApiClass((ec = Classref.checkExternal((int)intfc.interfaceImpl())).toString())) {
                        this.usedAPI.add(ec.toString(), null);
                        this.checkImplentedInterfaceMehods(intfc);
                    }
                    if (--count <= 0) continue;
                    intfc.next();
                } while (count > 0);
            }
            if (superRef == 65535) continue;
            if (!Classref.isExternal((int)superRef)) {
                cinfo = Cap.Class.infoOfs(superRef);
                superRef = cinfo.superclass();
                continue;
            }
            EfClass ec = Classref.checkExternal((int)superRef);
            this.getImplementedInterfacesForExternalSuperClass(ec);
            break;
        } while (superRef != 65535);
    }

    private void CheckAPIInterfacesForInterface(ClassInfo cinfo) {
        int count = cinfo.interfaceCount();
        for (int i = 0; i < count; ++i) {
            EfClass ec;
            int ref = cinfo.superinterface(i);
            if (!Classref.isExternal((int)ref) || !this.isApiClass((ec = Classref.checkExternal((int)ref)).toString())) continue;
            this.usedAPI.add(ec.toString(), null);
        }
    }

    private void processSuperClassesAndInterfaces(ClassDescriptor cdesc) {
        ClassInfo ci = Cap.Class.infoOfs(cdesc.thisClass());
        int superRef = ci.superclass();
        while (superRef != 65535) {
            if (!Classref.isExternal((int)superRef)) continue;
            EfClass ec = Classref.checkExternal((int)superRef);
            if (!this.isApiClass(ec.toString())) break;
            this.usedAPI.add(ec.toString(), null);
            break;
        }
        if ((ci.flags() & 8) == 8) {
            this.CheckAPIInterfacesForInterface(ci);
        } else {
            this.CheckAPIInterfacesForClass(ci);
        }
    }

    private void processCAP() {
        int i;
        this.processConstantPool();
        ClassDescriptor cdesc = Cap.Descriptor.firstClassDescriptor();
        for (i = Cap.Descriptor.classCount(); i > 0; --i) {
            this.processMethodComponent(cdesc);
            this.processSuperClassesAndInterfaces(cdesc);
            cdesc.next();
        }
        for (i = 0; i < Instr.instrName.length; ++i) {
            if (this.usedByteCodes.contains(Instr.instrName[i])) continue;
            this.unUsedByteCodes.add(Instr.instrName[i]);
        }
    }

    public Vector<String> listUsedByteCodes() {
        if (!this.capProcessed) {
            this.processCAP();
        }
        this.capProcessed = true;
        return this.usedByteCodes;
    }

    public Vector<String> listUnUsedByteCodes() {
        if (!this.capProcessed) {
            this.processCAP();
        }
        this.capProcessed = true;
        return this.unUsedByteCodes;
    }

    public UsedAPI listUsedJCAPI() {
        if (!this.capProcessed) {
            this.processCAP();
        }
        this.capProcessed = true;
        return this.usedAPI;
    }

    public Vector<String> listUsedCryptoAlgos() {
        if (!this.capProcessed) {
            this.processCAP();
        }
        this.usedCryptoAlgos.add("List created from a different jar file");
        this.capProcessed = true;
        return this.usedCryptoAlgos;
    }
}

