/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.ExceptionTable;
import com.sun.javacard.jcasm.ExceptionTableEntry;
import com.sun.javacard.jcasm.Instruction;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.Operand;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Statement {
    protected String label;
    protected Instruction ins;
    protected int relPc;
    protected int lineNumber;
    protected Vector<ExceptionTableEntry> exceptions;

    public Statement(String label, Instruction ins) {
        this.label = label;
        this.ins = ins;
        this.lineNumber = ins.lineNumber;
        this.exceptions = new Vector();
    }

    public Statement(String label, Instruction ins, int line) {
        this.label = label;
        this.ins = ins;
        this.lineNumber = line;
        this.exceptions = new Vector();
    }

    public Statement(Instruction ins) {
        this.ins = ins;
        this.exceptions = new Vector();
    }

    public Instruction getInstruction() {
        return this.ins;
    }

    public int getRelPc() {
        return this.relPc;
    }

    public int size() {
        return this.ins.size();
    }

    protected void methodFixup(Hashtable<String, Integer> symtab) {
        this.ins.methodFixup(symtab, this.relPc);
    }

    public Vector<ExceptionTableEntry> getExceptionHandlers() {
        return this.exceptions;
    }

    public void processForExceptionHandlers(JCMethod m) {
        ExceptionTable et = m.getExceptionTable();
        if (et == null) {
            return;
        }
        Enumeration<ExceptionTableEntry> e = et.elements();
        while (e.hasMoreElements()) {
            ExceptionTableEntry ete = e.nextElement();
            if (ete.startOffset > this.relPc || ete.endOffset < this.relPc) continue;
            this.exceptions.add(ete);
        }
    }

    public byte[] toByteArray() {
        byte[] array = new byte[this.size()];
        array[0] = (byte)this.ins.getOpcode();
        int index = 1;
        Enumeration<Operand> e = this.ins.elements();
        block5: while (e.hasMoreElements()) {
            Operand operand = e.nextElement();
            int value = operand.getValue();
            switch (operand.size()) {
                case 1: {
                    array[index++] = (byte)value;
                    continue block5;
                }
                case 2: {
                    array[index++] = (byte)(value >> 8);
                    array[index++] = (byte)(value & 0xFF);
                    continue block5;
                }
                case 4: {
                    array[index++] = (byte)(value >> 24);
                    array[index++] = (byte)((value & 0xFF0000) >> 16);
                    array[index++] = (byte)((value & 0xFF00) >> 8);
                    array[index++] = (byte)(value & 0xFF);
                    continue block5;
                }
            }
            throw new InternalError();
        }
        return array;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.label != null) {
            sb.append(this.label + ": ");
        }
        sb.append(this.ins + ";" + Msg.eol);
        return sb.toString();
    }
}

