/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.classfile.JClassFile;
import com.sun.javacard.classfile.JMethod;
import com.sun.javacard.classfile.JPackage;
import com.sun.javacard.classfile.attributes.JCodeAttr;
import com.sun.javacard.classfile.attributes.JExceptionRecord;
import com.sun.javacard.classfile.instructions.JInstrIntBranch;
import com.sun.javacard.classfile.instructions.JInstrLookupSwitch;
import com.sun.javacard.classfile.instructions.JInstrNoOperands;
import com.sun.javacard.classfile.instructions.JInstrShortBranch;
import com.sun.javacard.classfile.instructions.JInstrTableSwitch;
import com.sun.javacard.classfile.instructions.JInstruction;
import com.sun.javacard.converter.ConversionException;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.converters.ClassConverter;
import com.sun.javacard.converter.converters.ExceptionTableConverter;
import com.sun.javacard.converter.converters.I2SException;
import com.sun.javacard.converter.converters.InstrContainer;
import com.sun.javacard.converter.converters.InstrLoadConverter;
import com.sun.javacard.converter.converters.InstructionConverter;
import com.sun.javacard.converter.converters.LocalVariableConverter;
import com.sun.javacard.converter.converters.OperandStack;
import com.sun.javacard.converter.converters.OperandStackEntry;
import com.sun.javacard.converter.converters.PackageConverter;
import com.sun.javacard.converter.converters.RecalculateIndexException;
import com.sun.javacard.converter.converters.RollBackException;
import com.sun.javacard.converter.util.MethodDescriptor;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.jcfile.JcException;
import com.sun.javacard.jcfile.JcLocalVariable;
import com.sun.javacard.jcfile.JcMethod;
import com.sun.javacard.jcfile.constants.JcConstantPool;
import com.sun.javacard.jcfile.instructions.JcInstrNoOperands;
import com.sun.javacard.jcfile.instructions.JcInstruction;
import java.lang.reflect.Modifier;
import java.util.Vector;

public class MethodConverter {
    private JMethod java_method;
    private JcMethod jc_method;
    private ClassConverter c_converter;
    private PackageConverter p_converter;
    private InstrContainer instr_containers;
    private LocalVariableConverter local_var_converter;
    private JcLocalVariable[] jc_locals;
    private JcException[] jc_exceptions;
    private int nargs;
    private int max_locals;
    private int max_stack;

    public MethodConverter(JMethod java_method, ClassConverter c_converter, PackageConverter p_converter) {
        this.java_method = java_method;
        this.c_converter = c_converter;
        this.p_converter = p_converter;
        this.jc_method = new JcMethod(java_method);
        if (c_converter.getJcClass().getEfClass() != null) {
            this.jc_method.setEfMethod(c_converter.getJcClass().getEfClass().getMethod(java_method.getMethodName(), java_method.getMethodDescriptor()));
        }
    }

    public InstrContainer getInstrContainers() {
        return this.instr_containers;
    }

    public boolean isIntSupported() {
        return this.p_converter.isIntSupported();
    }

    public JcConstantPool getJcConstantPool() {
        return this.p_converter.getJcConstantPool();
    }

    public String getClassName() {
        return this.c_converter.getJavaClass().getClassName();
    }

    public String getMethodName() {
        return this.java_method.getMethodName();
    }

    public String getMethodDescriptor() {
        return this.java_method.getMethodDescriptor();
    }

    public ClassConverter getClassConverter() {
        return this.c_converter;
    }

    public PackageConverter getPackageConverter() {
        return this.p_converter;
    }

    public JMethod getJavaMethod() {
        return this.java_method;
    }

    public JcMethod getJcMethod() {
        return this.jc_method;
    }

    /*
     * Unable to fully structure code
     */
    public JcMethod convert() throws Exception {
        if ((this.java_method.isPublic() || this.java_method.isProtected()) && this.getClassConverter().getJavaClass().isPublic()) {
            this.checkMethodSignature();
        }
        if (!this.getMethodName().equals("<init>")) {
            a = true;
        }
        if (!this.p_converter.convertByteCode()) {
            return this.jc_method;
        }
        code = this.java_method.getCode();
        if (code == null) {
            this.jc_exceptions = new JcException[0];
            this.jc_method.setExceptions(this.jc_exceptions);
            this.jc_locals = new JcLocalVariable[0];
            this.jc_method.setLocalVariables(this.jc_locals);
            i = 0;
            while (i < this.jc_locals.length) {
                if ("I".equals(this.jc_locals[i].getDescriptor())) {
                    this.getPackageConverter().getJcPackage().setIntFlag(true);
                }
                ++i;
            }
            this.setNargs();
            return this.jc_method;
        }
        this.jc_locals = this.computeLocals();
        this.jc_method.setLocalVariables(this.jc_locals);
        i = 0;
        while (i < this.jc_locals.length) {
            if (this.jc_locals[i] != null && this.jc_locals[i].getDescriptor() != null && "I".equals(this.jc_locals[i].getDescriptor())) {
                this.getPackageConverter().getJcPackage().setIntFlag(true);
            }
            ++i;
        }
        this.constructInstrContainers(code);
        this.constructControlFlowGraph();
        this.jc_exceptions = this.constructExceptions();
        this.jc_method.setExceptions(this.jc_exceptions);
        done = false;
        this.instr_containers.setOperandStack(new OperandStack());
        while (!done) {
            done = true;
            cur_instr_container = this.instr_containers;
            while (cur_instr_container != null) {
                try {
                    if (cur_instr_container.isCatchFinallyBlockLeader() && cur_instr_container.getOperandStack() == null) {
                        operand_stack = new OperandStack();
                        operand_stack.push(10, null);
                        cur_instr_container.setOperandStack(operand_stack);
                    }
                    if (cur_instr_container.hasChanged()) {
                        block22: {
                            done = false;
                            cur_instr_container.reset();
                            cur_java_instr = cur_instr_container.getJInstr();
                            instr_converter = InstructionConverter.create(cur_instr_container, this);
                            try {
                                cur_jc_instr = instr_converter.convert();
                                cur_instr_container.setJcInstr(cur_jc_instr);
                                break block22;
                            }
                            catch (I2SException e) {
                                cur_instr_container.setJcInstr(e.getJcInstruction());
                                if (e.isBefore() && e.getNumInstrBack() == 0 && cur_instr_container.getJcInstr().getOpcode() != 94 && cur_instr_container.getPrevInstrContainer() != null && cur_instr_container.getPrevInstrContainer().getJcInstr().getOpcode() != 94) {
                                    this.insertI2SBefore(cur_instr_container);
                                }
                                if (e.getNumInstrBack() <= 0) break block22;
                                counter = e.getNumInstrBack();
                                tempCont = cur_instr_container;
                                ** while (counter-- > 0)
                            }
lbl-1000:
                            // 1 sources

                            {
                                tempCont = tempCont.getPrevInstrContainer();
                                continue;
                            }
lbl63:
                            // 1 sources

                            if (e.isBefore()) {
                                this.insertI2SBefore(tempCont);
                            } else {
                                this.insertI2SAfter(tempCont);
                            }
                        }
                        this.checkForcedTypeAndPromote(cur_instr_container);
                        this.propagateInfo(cur_instr_container);
                        this.setSourceLineNumber(cur_instr_container);
                        this.setJcInstrLabel(cur_instr_container);
                        cur_instr_container.setChangedFlag(false);
                        cur_instr_container.setVisited(true);
                    }
                    cur_instr_container = cur_instr_container.getNextInstrContainer();
                }
                catch (RollBackException e) {
                    tempC = cur_instr_container;
                    cur_instr_container = e.getRollBackPoint();
                    if (!e.isCastDownI2S()) {
                        cur_instr_container.setForcedType(3);
                        cur_instr_container.setChangedFlag(true);
                        if (this.local_var_converter.getDefinedLocalVariablesSize() != 0 || !((instr_converter = InstructionConverter.create(cur_instr_container, this)) instanceof InstrLoadConverter) || this.local_var_converter.getJcLocalVariable(j_index = ((InstrLoadConverter)instr_converter).getJavaLocalIndex()).isVarTypeKnown() || this.local_var_converter.getJcLocalVariable(j_index).isPromoted()) continue;
                        this.local_var_converter.updateJcLocalVariable(j_index, "I");
                        this.local_var_converter.getJcLocalVariable(j_index).setPromoted(true);
                        this.local_var_converter.recomputeUndefIndexes(j_index);
                        cur_instr_container = this.setAllToChangedAndRestart(cur_instr_container);
                        cur_instr_container.setChangedFlag(true);
                        continue;
                    }
                    this.insertI2SAfter(cur_instr_container);
                    cur_instr_container.setChangedFlag(true);
                    cur_instr_container = this.setAllToChangedAndReset(tempC, cur_instr_container);
                }
                catch (RecalculateIndexException e) {
                    cur_instr_container.setChangedFlag(true);
                    this.local_var_converter.recomputeUndefIndexes(e.getIndex());
                    cur_instr_container = this.setAllToChangedAndRestart(cur_instr_container);
                }
            }
        }
        first_jc_instr = this.linkJcInstructions();
        this.jc_method.setCode(first_jc_instr);
        this.setNargs();
        this.setMaxLocals();
        this.setMaxStack();
        return this.jc_method;
    }

    private InstrContainer setAllToChangedAndRestart(InstrContainer cur_instr_container) {
        InstrContainer temp = cur_instr_container;
        while (cur_instr_container.getPrevInstrContainer() != null) {
            if (cur_instr_container.isVisited()) {
                cur_instr_container.setChangedFlag(true);
            }
            cur_instr_container = cur_instr_container.getPrevInstrContainer();
        }
        if (cur_instr_container.isVisited()) {
            cur_instr_container.setChangedFlag(true);
        }
        while (temp.getNextInstrContainer() != null) {
            if (temp.isVisited()) {
                temp.setChangedFlag(true);
            }
            temp = temp.getNextInstrContainer();
        }
        if (temp.isVisited()) {
            temp.setChangedFlag(true);
        }
        return cur_instr_container;
    }

    private InstrContainer setAllToChangedAndReset(InstrContainer cur_instr_container, InstrContainer rollback_cont) {
        InstrContainer temp = cur_instr_container;
        temp.setChangedFlag(true);
        temp.resetStack();
        while (cur_instr_container.getPrevInstrContainer() != null) {
            if (cur_instr_container == rollback_cont) break;
            if (cur_instr_container.isVisited()) {
                cur_instr_container.setChangedFlag(true);
                cur_instr_container.resetStack();
            }
            cur_instr_container = cur_instr_container.getPrevInstrContainer();
        }
        if (cur_instr_container.isVisited()) {
            cur_instr_container.setChangedFlag(true);
            cur_instr_container.resetWorkingStack();
        }
        while (temp.getNextInstrContainer() != null) {
            if (temp.isVisited()) {
                temp.setChangedFlag(true);
                temp.resetStack();
            }
            if (temp == rollback_cont) break;
            temp = temp.getNextInstrContainer();
        }
        if (temp.isVisited()) {
            temp.setChangedFlag(true);
            temp.resetStack();
        }
        return cur_instr_container;
    }

    private void constructInstrContainers(JInstruction code) {
        InstrContainer cur_instr_container = this.instr_containers = new InstrContainer(code);
        while (code.getNextInstr() != null) {
            code = code.getNextInstr();
            InstrContainer instr_container = new InstrContainer(code);
            cur_instr_container.setNextInstrContainer(instr_container);
            instr_container.setPrevInstrContainer(cur_instr_container);
            cur_instr_container = instr_container;
        }
    }

    private void constructControlFlowGraph() {
        this.instr_containers.setLabelFlag(true);
        this.instr_containers.setControlFlowLabelFlag(true);
        this.linkExceptions();
        InstrContainer instr_container = this.instr_containers;
        while (instr_container != null) {
            InstrContainer next_instr_container;
            JInstruction java_instr = instr_container.getJInstr();
            if (java_instr instanceof JInstrShortBranch) {
                this.linkShortBranchInstr(instr_container);
            } else if (java_instr instanceof JInstrIntBranch) {
                this.linkIntBranchInstr(instr_container);
            } else if (java_instr instanceof JInstrTableSwitch || java_instr instanceof JInstrLookupSwitch) {
                this.linkSwitchInstr(instr_container);
            } else if (this.isUnconditionalBranch(java_instr)) {
                next_instr_container = instr_container.getNextInstrContainer();
                if (next_instr_container != null) {
                    next_instr_container.setLabelFlag(true);
                    next_instr_container.setControlFlowLabelFlag(true);
                }
            } else {
                next_instr_container = instr_container.getNextInstrContainer();
                if (next_instr_container != null) {
                    instr_container.link(next_instr_container);
                }
            }
            instr_container = instr_container.getNextInstrContainer();
        }
        this.linkRetInstructions();
        if (this.p_converter.getConversionProfile().debug) {
            this.setLocalVarsScope();
        }
        this.setContainerLabels();
        if (this.p_converter.getConversionProfile().debug) {
            this.setLocalVarsLabels();
        }
    }

    private void setLocalVarsScope() {
        int i = 0;
        while (i < this.jc_locals.length) {
            JcLocalVariable jc_local = this.jc_locals[i];
            while (jc_local != null) {
                this.setLocalVarScope(jc_local);
                jc_local = jc_local.getNext();
            }
            ++i;
        }
    }

    private void setLocalVarScope(JcLocalVariable jc_local) {
        JInstruction j_instr;
        int j_start_pc = jc_local.getJStartPC();
        int j_end_pc = j_start_pc + jc_local.getJLength();
        InstrContainer cur_instr_container = this.instr_containers;
        while (cur_instr_container != null) {
            j_instr = cur_instr_container.getJInstr();
            if (j_start_pc == j_instr.getPC()) {
                cur_instr_container.setLabelFlag(true);
                break;
            }
            cur_instr_container = cur_instr_container.getNextInstrContainer();
        }
        cur_instr_container = this.instr_containers;
        while (cur_instr_container != null) {
            j_instr = cur_instr_container.getJInstr();
            if (j_end_pc == j_instr.getPC()) {
                cur_instr_container.setLabelFlag(true);
                break;
            }
            cur_instr_container = cur_instr_container.getNextInstrContainer();
        }
    }

    private void setLocalVarsLabels() {
        int i = 0;
        while (i < this.jc_locals.length) {
            JcLocalVariable jc_local = this.jc_locals[i];
            while (jc_local != null) {
                this.setLocalVarLabel(jc_local);
                jc_local = jc_local.getNext();
            }
            ++i;
        }
    }

    private void setLocalVarLabel(JcLocalVariable jc_local) {
        JInstruction j_instr;
        int j_start_pc = jc_local.getJStartPC();
        int j_end_pc = j_start_pc + jc_local.getJLength();
        int start_label = -1;
        int end_label = -1;
        InstrContainer cur_instr_container = this.instr_containers;
        while (cur_instr_container != null) {
            j_instr = cur_instr_container.getJInstr();
            if (j_start_pc == j_instr.getPC()) {
                start_label = cur_instr_container.getLabel();
                break;
            }
            cur_instr_container = cur_instr_container.getNextInstrContainer();
        }
        cur_instr_container = this.instr_containers;
        while (cur_instr_container != null) {
            j_instr = cur_instr_container.getJInstr();
            if (j_end_pc == j_instr.getPC()) {
                end_label = cur_instr_container.getLabel();
                break;
            }
            cur_instr_container = cur_instr_container.getNextInstrContainer();
        }
        jc_local.setJcStartPCLabel(start_label);
        jc_local.setJcEndPCLabel(end_label);
    }

    private void linkShortBranchInstr(InstrContainer cur_instr_container) {
        JInstruction cur_java_instr = cur_instr_container.getJInstr();
        int branch_offset = ((JInstrShortBranch)cur_java_instr).getBranchOffset();
        InstrContainer target_instr_container = this.findTargetInstrContainer(cur_java_instr.getPC(), branch_offset);
        target_instr_container.setLabelFlag(true);
        target_instr_container.setControlFlowLabelFlag(true);
        cur_instr_container.link(target_instr_container);
        InstrContainer next_instr_container = cur_instr_container.getNextInstrContainer();
        if (next_instr_container != null) {
            next_instr_container.setLabelFlag(true);
            next_instr_container.setControlFlowLabelFlag(true);
            if (!this.isUnconditionalBranch(cur_java_instr)) {
                cur_instr_container.link(next_instr_container);
            }
            if (cur_java_instr.getOpcode() == 168) {
                cur_instr_container.link(next_instr_container);
            }
        }
    }

    private void linkIntBranchInstr(InstrContainer cur_instr_container) {
        JInstruction cur_java_instr = cur_instr_container.getJInstr();
        int branch_offset = ((JInstrIntBranch)cur_java_instr).getBranchOffset();
        InstrContainer target_instr_container = this.findTargetInstrContainer(cur_java_instr.getPC(), branch_offset);
        target_instr_container.setLabelFlag(true);
        target_instr_container.setControlFlowLabelFlag(true);
        cur_instr_container.link(target_instr_container);
        InstrContainer next_instr_container = cur_instr_container.getNextInstrContainer();
        if (next_instr_container != null) {
            next_instr_container.setLabelFlag(true);
            next_instr_container.setControlFlowLabelFlag(true);
            cur_instr_container.link(next_instr_container);
        }
    }

    private void linkSwitchInstr(InstrContainer cur_instr_container) {
        JInstruction cur_java_instr;
        InstrContainer next_instr_container = cur_instr_container.getNextInstrContainer();
        if (next_instr_container != null) {
            next_instr_container.setLabelFlag(true);
            next_instr_container.setControlFlowLabelFlag(true);
        }
        int default_branch_offset = (cur_java_instr = cur_instr_container.getJInstr()) instanceof JInstrTableSwitch ? ((JInstrTableSwitch)cur_java_instr).getDefaultBranchOffset() : ((JInstrLookupSwitch)cur_java_instr).getDefaultBranchOffset();
        InstrContainer target_instr_container = this.findTargetInstrContainer(cur_java_instr.getPC(), default_branch_offset);
        if (target_instr_container != null) {
            target_instr_container.setLabelFlag(true);
            target_instr_container.setControlFlowLabelFlag(true);
            cur_instr_container.link(target_instr_container);
        }
        int[] branch_offsets = cur_java_instr instanceof JInstrTableSwitch ? ((JInstrTableSwitch)cur_java_instr).getBranchOffsets() : ((JInstrLookupSwitch)cur_java_instr).getMatchOffsets();
        int i = 0;
        while (i < branch_offsets.length) {
            target_instr_container = this.findTargetInstrContainer(cur_java_instr.getPC(), branch_offsets[i]);
            if (target_instr_container != null) {
                target_instr_container.setLabelFlag(true);
                target_instr_container.setControlFlowLabelFlag(true);
                cur_instr_container.link(target_instr_container);
            }
            ++i;
        }
    }

    private void linkRetInstructions() {
        InstrContainer cur_instr_container = this.instr_containers;
        while (cur_instr_container != null) {
            JInstruction cur_java_instr = cur_instr_container.getJInstr();
            if (cur_java_instr.getOpcode() == 168) {
                InstrContainer next_jsr_instr_container;
                InstrContainer ret_instr_container = cur_instr_container.findRetInstrContainer();
                if (ret_instr_container == null) {
                    // empty if block
                }
                if ((next_jsr_instr_container = cur_instr_container.getNextInstrContainer()) == null) {
                    throw new ConverterInternalError();
                }
                if (ret_instr_container != null) {
                    ret_instr_container.link(next_jsr_instr_container);
                }
            }
            cur_instr_container = cur_instr_container.getNextInstrContainer();
        }
    }

    private void linkExceptions() {
        JCodeAttr code_attr = this.java_method.getCodeAttr();
        JExceptionRecord[] exceptions = code_attr.getExceptions();
        int i = 0;
        while (i < exceptions.length) {
            int start_pc = exceptions[i].getStartPc();
            InstrContainer target_instr_container = this.findTargetInstrContainer(0, start_pc);
            target_instr_container.setLabelFlag(true);
            target_instr_container.setControlFlowLabelFlag(true);
            int end_pc = exceptions[i].getEndPc();
            target_instr_container = this.findTargetInstrContainer(0, end_pc);
            target_instr_container.setLabelFlag(true);
            target_instr_container.setControlFlowLabelFlag(true);
            int handler_pc = exceptions[i].getHandlerPc();
            target_instr_container = this.findTargetInstrContainer(0, handler_pc);
            target_instr_container.setLabelFlag(true);
            target_instr_container.setControlFlowLabelFlag(true);
            target_instr_container.setCatchFinallyBlockLeader(true);
            ++i;
        }
    }

    private void setContainerLabels() {
        InstrContainer cur_instr_container = this.instr_containers;
        int block_num = 0;
        while (cur_instr_container != null) {
            if (cur_instr_container.hasLabel()) {
                cur_instr_container.setLabel(block_num);
                ++block_num;
            }
            cur_instr_container = cur_instr_container.getNextInstrContainer();
        }
    }

    private InstrContainer findTargetInstrContainer(int branch_offset, int brand_distance) {
        int target_pc = branch_offset + brand_distance;
        InstrContainer cur_instr_container = this.instr_containers;
        while (cur_instr_container != null) {
            if (cur_instr_container.getJInstr().getPC() == target_pc) {
                return cur_instr_container;
            }
            cur_instr_container = cur_instr_container.getNextInstrContainer();
        }
        throw new ConverterInternalError();
    }

    private JcException[] constructExceptions() {
        ExceptionTableConverter exp_converter = new ExceptionTableConverter(this);
        return exp_converter.convert();
    }

    private JcLocalVariable[] computeLocals() throws Exception {
        this.local_var_converter = LocalVariableConverter.createIt(this);
        return this.local_var_converter.convert();
    }

    public LocalVariableConverter getLocalVariableConverter() {
        return this.local_var_converter;
    }

    public void setMaxLocals() {
        JCodeAttr code_attr;
        this.max_locals = !this.isIntSupported() ? ((code_attr = this.java_method.getCodeAttr()) == null ? 0 : code_attr.getMaxLocals()) : this.local_var_converter.getDefinedLocalVariablesSize() + this.local_var_converter.getUndefinedLocalVariablesSize();
        if (this.max_locals != 0) {
            this.max_locals -= this.nargs;
        }
        this.jc_method.setMaxLocals(this.max_locals);
    }

    private void setNargs() {
        String descriptor = this.jc_method.getMethodDescriptor();
        this.nargs = MethodDescriptor.getParamSize(descriptor);
        int access_flags = this.jc_method.getAccessFlags();
        if (!Modifier.isStatic(access_flags)) {
            ++this.nargs;
        }
        this.jc_method.setNargs(this.nargs);
    }

    private void setMaxStack() throws Exception {
        int max_stack = 0;
        InstrContainer cur_instr_container = this.instr_containers;
        while (cur_instr_container != null) {
            OperandStack operand_stack = cur_instr_container.getOperandStack();
            if (operand_stack != null && max_stack < operand_stack.getMaxStackSize()) {
                max_stack = operand_stack.getMaxStackSize();
            }
            cur_instr_container = cur_instr_container.getNextInstrContainer();
        }
        if (max_stack > 255) {
            Object[] args = new String[]{this.getMethodName(), this.getClassName().replace('/', '.')};
            Notifier.error("subset.56", args);
            throw new ConversionException();
        }
        this.jc_method.setMaxStack(max_stack);
    }

    private boolean isUnconditionalBranch(JInstruction java_instr) {
        int opcode = java_instr.getOpcode();
        switch (opcode) {
            case 167: 
            case 168: 
            case 169: 
            case 172: 
            case 176: 
            case 177: 
            case 191: {
                return true;
            }
        }
        return false;
    }

    private void checkForcedTypeAndPromote(InstrContainer instr_container) {
        if (instr_container.getForcedType() != 3) {
            return;
        }
        OperandStack operand_stack = instr_container.getOperandStack();
        OperandStackEntry value_entry = operand_stack.peek(1);
        if (value_entry.getType() == 3) {
            return;
        }
        JcInstruction jc_instr = instr_container.getJcInstr();
        if (jc_instr == null) {
            if (value_entry.getType() == 2 || value_entry.getType() == 1) {
                JcInstrNoOperands promote_instr = new JcInstrNoOperands(92);
                instr_container.setJcInstr(promote_instr);
                operand_stack.promote(1);
                return;
            }
            throw new ConverterInternalError();
        }
        switch (jc_instr.getOpcode()) {
            case 2: {
                jc_instr.setOpcode(9);
                break;
            }
            case 3: {
                jc_instr.setOpcode(10);
                break;
            }
            case 4: {
                jc_instr.setOpcode(11);
                break;
            }
            case 5: {
                jc_instr.setOpcode(12);
                break;
            }
            case 6: {
                jc_instr.setOpcode(13);
                break;
            }
            case 7: {
                jc_instr.setOpcode(14);
                break;
            }
            case 8: {
                jc_instr.setOpcode(15);
                break;
            }
            case 16: {
                jc_instr.setOpcode(18);
                break;
            }
            case 17: {
                jc_instr.setOpcode(19);
                break;
            }
            default: {
                JcInstrNoOperands promote_instr = new JcInstrNoOperands(92);
                if (jc_instr == null) {
                    jc_instr = promote_instr;
                    instr_container.setJcInstr(jc_instr);
                    break;
                }
                jc_instr.setNextInstr(promote_instr);
                promote_instr.setPrevInstr(jc_instr);
            }
        }
        operand_stack.promote(1);
    }

    private void propagateInfo(InstrContainer cur_instr_container) {
        InstrContainer[] out_instr_containers = cur_instr_container.getOutInstrContainers();
        OperandStack operand_stack = cur_instr_container.getOperandStack();
        int i = 0;
        while (i < out_instr_containers.length) {
            if (!out_instr_containers[i].isCatchFinallyBlockLeader()) {
                try {
                    if (cur_instr_container.getJInstr().getOpcode() == 168 && cur_instr_container.getNextInstrContainer().getJInstr().getPC() == out_instr_containers[i].getJInstr().getPC() && out_instr_containers.length > 1) {
                        OperandStack clone = (OperandStack)operand_stack.clone();
                        clone.pop();
                        out_instr_containers[i].setOperandStack(clone);
                    } else {
                        out_instr_containers[i].setOperandStack((OperandStack)operand_stack.clone());
                    }
                }
                catch (RollBackException e) {
                    RollBackException aaa = e;
                    InstrContainer prev = out_instr_containers[i].getPrevInstrContainer();
                    int pc_curr = cur_instr_container.getJInstr().getPC();
                    int pc_roll = e.getRollBackPoint().getJInstr().getPC();
                    int pc_prev = prev.getJInstr().getPC();
                    if (prev != null && pc_curr != pc_roll && pc_curr != pc_prev) {
                        prev.setForcedType(3);
                        prev.setChangedFlag(true);
                    }
                    throw e;
                }
            }
            ++i;
        }
    }

    private void setSourceLineNumber(InstrContainer instr_container) {
        int line_num = instr_container.getJInstr().getSourceLineNumber();
        JcInstruction jc_instr = instr_container.getJcInstr();
        while (jc_instr != null) {
            jc_instr.setSourceLineNumber(line_num);
            jc_instr = jc_instr.getNextInstr();
        }
    }

    private void setJcInstrLabel(InstrContainer instr_container) {
        int block_num = instr_container.getLabel();
        if (block_num == -1) {
            return;
        }
        JcInstruction jc_instr = instr_container.getJcInstr();
        if (jc_instr != null) {
            jc_instr.setLabel(block_num);
        }
    }

    private JcInstruction linkJcInstructions() {
        InstrContainer cur_instr_container = this.instr_containers;
        JcInstruction first_jc_instr = null;
        JcInstruction cur_jc_instr = null;
        while (cur_instr_container != null) {
            JcInstruction jc_instr = cur_instr_container.getJcInstr();
            if (jc_instr != null) {
                if (!cur_instr_container.hasLabel()) {
                    InstrContainer prev_instr_container = cur_instr_container.getPrevInstrContainer();
                    while (prev_instr_container.getJcInstr() == null) {
                        if (prev_instr_container.hasLabel()) {
                            jc_instr.setLabel(prev_instr_container.getLabel());
                            break;
                        }
                        prev_instr_container = prev_instr_container.getPrevInstrContainer();
                    }
                }
                if (first_jc_instr == null) {
                    first_jc_instr = jc_instr;
                    cur_jc_instr = jc_instr;
                } else {
                    cur_jc_instr.setNextInstr(jc_instr);
                    jc_instr.setPrevInstr(cur_jc_instr);
                }
                cur_jc_instr = jc_instr;
                while (cur_jc_instr.getNextInstr() != null) {
                    cur_jc_instr = cur_jc_instr.getNextInstr();
                }
            }
            cur_instr_container = cur_instr_container.getNextInstrContainer();
        }
        return first_jc_instr;
    }

    private void checkMethodSignature() throws Exception {
        Vector classes = this.getClassesFromSignature();
        JPackage jp = this.getPackageConverter().getJavaPackage();
        int i = 0;
        while (i < classes.size()) {
            String clName = classes.elementAt(i).toString();
            JClassFile jc = jp.getClass(clName);
            if (jc != null && !jc.isPublic()) {
                Object[] args = new String[]{this.getMethodName(), this.getClassName().replace('/', '.'), clName.replace('/', '.')};
                Notifier.error("subset.55", args);
                throw new ConversionException();
            }
            ++i;
        }
    }

    private Vector getClassesFromSignature() {
        int l;
        Vector<String> res = new Vector<String>();
        String sig = this.getMethodDescriptor();
        while ((l = sig.indexOf(76)) != -1) {
            int semicolon = sig.indexOf(59, l);
            if (l == -1) break;
            String className = sig.substring(l + 1, semicolon);
            sig = sig.substring(semicolon + 1);
            res.add(className);
        }
        return res;
    }

    private void insertI2SBefore(InstrContainer curr_container) {
        InstrContainer prev_container = curr_container.getPrevInstrContainer();
        JInstrNoOperands ji = new JInstrNoOperands(null, 0, 147);
        InstrContainer i2s_container = new InstrContainer(ji);
        JcInstrNoOperands jc_i2s = new JcInstrNoOperands(94);
        i2s_container.setJcInstr(jc_i2s);
        i2s_container.setNextInstrContainer(curr_container);
        i2s_container.setPrevInstrContainer(prev_container);
        prev_container.setNextInstrContainer(i2s_container);
        curr_container.setPrevInstrContainer(i2s_container);
        prev_container.relink(curr_container, i2s_container);
        i2s_container.link(curr_container);
    }

    private void insertI2SAfter(InstrContainer curr_container) {
        InstrContainer next_container = curr_container.getNextInstrContainer();
        JInstrNoOperands ji = new JInstrNoOperands(null, 0, 147);
        InstrContainer i2s_container = new InstrContainer(ji);
        i2s_container.setInserted(true);
        JcInstrNoOperands jc_i2s = new JcInstrNoOperands(94);
        i2s_container.setJcInstr(jc_i2s);
        i2s_container.setNextInstrContainer(next_container);
        i2s_container.setPrevInstrContainer(curr_container);
        next_container.setPrevInstrContainer(i2s_container);
        curr_container.setNextInstrContainer(i2s_container);
        curr_container.relink(next_container, i2s_container);
        i2s_container.link(next_container);
    }
}

