/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.jcasm.Assert;
import com.sun.javacard.jcasm.ExceptionTable;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.cap.Component;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;

public class MethodComponent
extends Component {
    public static final int ACC_EXTENDED = 8;
    public static final int ACC_ABSTRACT = 4;
    protected Vector methodVector = new Vector();
    protected Vector exceptionVector = new Vector();
    protected int handlerCount;

    public MethodComponent(JCPackage p) {
        super(p);
    }

    public int dataSize() {
        int size = 1;
        Enumeration e = this.exceptionVector.elements();
        while (e.hasMoreElements()) {
            ExceptionTable tbl = (ExceptionTable)e.nextElement();
            size += tbl.size();
        }
        Enumeration e2 = this.methodVector.elements();
        while (e2.hasMoreElements()) {
            JCMethod m = (JCMethod)e2.nextElement();
            size += m.size();
        }
        return size;
    }

    public void add(JCClass c) {
        if (Modifier.isInterface(c.getAttributes())) {
            return;
        }
        Enumeration g = c.methodElements();
        while (g.hasMoreElements()) {
            JCMethod method = (JCMethod)g.nextElement();
            this.methodVector.addElement(method);
            ExceptionTable e = method.getExceptionTable();
            if (e == null) continue;
            this.exceptionVector.addElement(e);
            this.handlerCount += e.count();
            if (this.handlerCount <= 255) continue;
            Msg.error(Msg.getMessage("package.5"));
            return;
        }
    }

    void assignAddresses() {
        int address = 1;
        Enumeration e = this.exceptionVector.elements();
        while (e.hasMoreElements()) {
            ExceptionTable tbl = (ExceptionTable)e.nextElement();
            tbl.relocate(address);
            address += tbl.size();
        }
        Enumeration e2 = this.methodVector.elements();
        while (e2.hasMoreElements()) {
            JCMethod m = (JCMethod)e2.nextElement();
            m.relocate(address);
            address += m.size();
        }
    }

    protected byte[] toByteArray() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            byte[] header = super.toByteArray();
            dos.write(header, 0, header.length);
            dos.writeByte(this.handlerCount);
            Enumeration e = this.exceptionVector.elements();
            while (e.hasMoreElements()) {
                ExceptionTable tbl = (ExceptionTable)e.nextElement();
                byte[] array = tbl.toByteArray();
                dos.write(array, 0, array.length);
            }
            Enumeration e2 = this.methodVector.elements();
            while (e2.hasMoreElements()) {
                JCMethod m = (JCMethod)e2.nextElement();
                byte[] array = m.toByteArray();
                dos.write(array, 0, array.length);
            }
            dos.flush();
        }
        catch (IOException e) {
            return null;
        }
        Assert.PostCondition(this.size() == bos.size(), "size() != bos.size()");
        return bos.toByteArray();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append("Handler count: " + this.handlerCount + Msg.eol);
        Enumeration e = this.exceptionVector.elements();
        while (e.hasMoreElements()) {
            ExceptionTable tbl = (ExceptionTable)e.nextElement();
            sb.append(tbl.toString() + Msg.eol);
        }
        Enumeration e2 = this.methodVector.elements();
        while (e2.hasMoreElements()) {
            JCMethod me = (JCMethod)e2.nextElement();
            sb.append(me.toString());
        }
        return sb.toString();
    }

    protected void getDebugOffsets(Map offsets) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            dos.writeByte(this.handlerCount);
            Enumeration e = this.exceptionVector.elements();
            while (e.hasMoreElements()) {
                ExceptionTable tbl = (ExceptionTable)e.nextElement();
                byte[] array = tbl.toByteArray();
                dos.write(array, 0, array.length);
            }
            Enumeration e2 = this.methodVector.elements();
            while (e2.hasMoreElements()) {
                JCMethod m = (JCMethod)e2.nextElement();
                byte[] array = m.toByteArray();
                offsets.put(m.getName(), new Integer(dos.size()));
                dos.write(array, 0, array.length);
            }
        }
        catch (IOException e) {
            return;
        }
    }
}

