/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.mask;

import com.sun.javacard.jcasm.AppletDeclarator;
import com.sun.javacard.jcasm.ExceptionTable;
import com.sun.javacard.jcasm.ExceptionTableEntry;
import com.sun.javacard.jcasm.Field;
import com.sun.javacard.jcasm.FieldDescriptor;
import com.sun.javacard.jcasm.Info;
import com.sun.javacard.jcasm.Instruction;
import com.sun.javacard.jcasm.InterfaceTable;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.MethodIdentifier;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.Operand;
import com.sun.javacard.jcasm.PackageIdentifier;
import com.sun.javacard.jcasm.Statement;
import com.sun.javacard.jcasm.StaticFieldInitializer;
import com.sun.javacard.jcasm.SuperInterface;
import com.sun.javacard.jcasm.cap.ExportComponent;
import com.sun.javacard.jcasm.mask.OutputFormatter;
import com.sun.javacard.jcasm.mask.PackageDirectory;
import com.sun.javacard.jcasm.mask.RomMask;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import java.util.Enumeration;

public class A51OutputFormatter
extends OutputFormatter {
    protected StringBuffer preamble;
    protected StringBuffer rom;
    protected StringBuffer staticFields;
    protected StringBuffer staticInit;
    protected StringBuffer applets;
    protected StringBuffer packages;
    protected StringBuffer exceptionTable;
    protected StringBuffer exportComponent;
    protected int exportComponentLength;
    protected int nExceptionEntries;
    protected StringBuffer defineList;
    protected PackageDirectory packageDirectory;
    private int relocPc;
    private int relocFieldPc;
    private int romBase = 0;
    private int e2Base = 33024;

    public A51OutputFormatter(BufferedReader configFile) throws IOException {
        super(configFile);
        try {
            String strRomBase = this.getMapEntry("ROMBASE");
            if (strRomBase != null) {
                this.romBase = Integer.decode(strRomBase);
            }
        }
        catch (NumberFormatException e) {
            Msg.error("cref.0", null);
        }
        try {
            String strE2Base = this.getMapEntry("E2BASE");
            if (strE2Base != null) {
                this.e2Base = Integer.decode(strE2Base);
            }
        }
        catch (NumberFormatException e) {
            Msg.error("cref.1", null);
        }
        this.preamble = new StringBuffer();
        this.preamble.append("$SAVE" + Msg.eol);
        this.preamble.append("$NOLIST" + Msg.eol);
        this.preamble.append("$INCLUDE (opcode.inc)" + Msg.eol);
        this.preamble.append("$INCLUDE (mask.inc)" + Msg.eol);
        this.preamble.append("$RESTORE" + Msg.eol + Msg.eol);
        this.preamble.append("BYTECODE     SEGMENT CODE  AT " + Integer.toHexString(this.romBase) + "H" + Msg.eol);
        this.preamble.append("STATICFIELDS SEGMENT XDATA AT " + Integer.toHexString(this.e2Base) + "H" + Msg.eol);
        this.preamble.append("STATICINIT   SEGMENT CODE" + Msg.eol);
        this.preamble.append("EXCEPTIONTBL SEGMENT CODE" + Msg.eol);
        this.preamble.append("PACKAGETBL   SEGMENT CODE" + Msg.eol);
        this.preamble.append("APPLETTBL    SEGMENT CODE" + Msg.eol);
        this.preamble.append("EXPORTCOMP   SEGMENT CODE" + Msg.eol);
        this.rom = new StringBuffer();
        this.rom.append("RSEG BYTECODE" + Msg.eol);
        this.rom.append("PUBLIC ROM_MASK" + Msg.eol);
        this.rom.append("ROM_MASK:" + Msg.eol);
        this.staticFields = new StringBuffer();
        this.staticFields.append("RSEG STATICFIELDS" + Msg.eol);
        this.staticFields.append("PUBLIC STATIC_FIELDS" + Msg.eol);
        this.staticFields.append("STATIC_FIELDS:" + Msg.eol);
        this.staticInit = new StringBuffer();
        this.staticInit.append("RSEG STATICINIT" + Msg.eol);
        this.staticInit.append("PUBLIC STATIC_INIT" + Msg.eol);
        this.staticInit.append("STATIC_INIT:" + Msg.eol);
        this.applets = new StringBuffer();
        this.applets.append("RSEG APPLETTBL" + Msg.eol);
        this.applets.append("PUBLIC APPLET_TABLE" + Msg.eol);
        this.applets.append("APPLET_TABLE:" + Msg.eol);
        this.packages = new StringBuffer();
        this.packages.append("RSEG PACKAGETBL" + Msg.eol);
        this.packages.append("PUBLIC PACKAGE_TABLE" + Msg.eol);
        this.packages.append("PACKAGE_TABLE:" + Msg.eol);
        this.exceptionTable = new StringBuffer();
        this.exceptionTable.append("RSEG EXCEPTIONTBL" + Msg.eol);
        this.exceptionTable.append("PUBLIC EXCEPTION_TABLE" + Msg.eol);
        this.exceptionTable.append("EXCEPTION_TABLE:" + Msg.eol);
        this.exportComponent = new StringBuffer();
        this.exportComponent.append("RSEG EXPORTCOMP" + Msg.eol);
        this.exportComponent.append("PUBLIC EXPORT_COMPONENT" + Msg.eol);
        this.exportComponent.append("EXPORT_COMPONENT:" + Msg.eol);
        this.defineList = new StringBuffer();
        this.packageDirectory = new PackageDirectory();
    }

    public void format(RomMask r) {
        this.pass1(r);
        this.pass2(r);
    }

    protected void pass1(RomMask r) {
        Enumeration e = r.packageElements();
        while (e.hasMoreElements()) {
            JCPackage p = (JCPackage)e.nextElement();
            Enumeration f = p.classElements();
            while (f.hasMoreElements()) {
                JCClass c = (JCClass)f.nextElement();
                c.relocate(this.relocPc);
                this.relocPc += c.size();
                if (Modifier.isInterface(c.getAttributes())) continue;
                Enumeration g = c.fieldElements();
                while (g.hasMoreElements()) {
                    Field field = (Field)g.nextElement();
                    if (!Modifier.isStatic(field.getAttributes())) continue;
                    FieldDescriptor descriptor = field.getDescriptor();
                    if (Modifier.isFinal(field.getAttributes()) && descriptor.isPrimitive()) continue;
                    field.relocate(this.relocFieldPc);
                    this.relocFieldPc += field.size();
                    StaticFieldInitializer init = field.getFieldInitializer();
                    if (init != null && init.isPrimitive()) {
                        int data = init.getPrimitiveData();
                        switch (field.size()) {
                            case 1: {
                                this.staticInit.append("DB " + this.byteHexString(data));
                                break;
                            }
                            case 2: {
                                this.staticInit.append("DW " + this.shortHexString(data));
                                break;
                            }
                            case 4: {
                                this.staticInit.append("DW " + this.shortHexString(data >> 16) + ", ");
                                this.staticInit.append(this.shortHexString(data));
                                break;
                            }
                            default: {
                                throw new InternalError();
                            }
                        }
                    } else {
                        switch (field.size()) {
                            case 1: {
                                this.staticInit.append("DB 00h");
                                break;
                            }
                            case 2: {
                                this.staticInit.append("DW 0000h");
                                break;
                            }
                            case 4: {
                                this.staticInit.append("DW 0000h, 0000h");
                                break;
                            }
                            default: {
                                throw new InternalError();
                            }
                        }
                    }
                    this.staticInit.append("\t; " + field.getName() + Msg.eol);
                }
                Enumeration g2 = c.methodElements();
                while (g2.hasMoreElements()) {
                    JCMethod m = (JCMethod)g2.nextElement();
                    if (Modifier.isNative(m.getAttributes())) {
                        m.relocate(0);
                        continue;
                    }
                    m.relocate(this.relocPc);
                    this.relocPc += m.size();
                }
            }
        }
    }

    protected void pass2(RomMask r) {
        Enumeration e = r.packageElements();
        while (e.hasMoreElements()) {
            JCPackage p = (JCPackage)e.nextElement();
            ExportComponent export = new ExportComponent(p);
            PackageIdentifier pid = p.getIdentifier();
            this.packageDirectory.addPackage(pid);
            byte[] aid = pid.getAid().toByteArray();
            this.packages.append("DB " + aid.length + ", ");
            int i = 0;
            while (i < aid.length) {
                this.packages.append(this.byteHexString(aid[i]) + ", ");
                ++i;
            }
            this.packages.append(pid.getMajorVersion() + ", " + pid.getMinorVersion() + ", " + this.exportComponentLength + Msg.eol);
            Enumeration f = p.appletElements();
            while (f.hasMoreElements()) {
                AppletDeclarator applet = (AppletDeclarator)f.nextElement();
                byte[] appletAid = applet.getAid().toByteArray();
                int addr = applet.resolve().getRelocAddr();
                this.applets.append("DB " + this.packageDirectory.indexOf(pid) + ", " + appletAid.length + ", ");
                int i2 = 0;
                while (i2 < appletAid.length) {
                    this.applets.append(this.byteHexString(appletAid[i2]) + ", ");
                    ++i2;
                }
                this.applets.append(", " + this.shortHexString(addr + this.romBase) + Msg.eol);
            }
            Enumeration f2 = p.classElements();
            while (f2.hasMoreElements()) {
                Enumeration g;
                int flags;
                JCClass c = (JCClass)f2.nextElement();
                export.add(c);
                this.rom.append(Msg.eol + "; class@" + this.shortHexString(c.getRelocAddr()) + ": " + Modifier.toString(c.getAttributes()) + " " + c.getName() + Msg.eol);
                String mapTo = this.getMapEntry(c.getName());
                if (mapTo != null) {
                    this.defineList.append("#define " + mapTo + " " + (c.getRelocAddr() + this.romBase) + "\t/* " + c.getName() + " */" + Msg.eol);
                }
                int n = flags = c.isShareable() ? 64 : 0;
                if (Modifier.isInterface(c.getAttributes())) {
                    int superCount = c.superInterfaceVector.size();
                    this.rom.append("DB " + this.byteHexString((flags |= 0x80) | superCount & 0xF) + ", ");
                    g = c.superInterfaceVector.elements();
                    while (g.hasMoreElements()) {
                        SuperInterface si = (SuperInterface)g.nextElement();
                        int addr = si.resolve().getRelocAddr();
                        this.rom.append("HIGH(" + this.shortHexString(addr + this.romBase) + "), ");
                        this.rom.append("LOW(" + this.shortHexString(addr + this.romBase) + "), ");
                        this.rom.append(Msg.eol);
                    }
                    continue;
                }
                this.rom.append("DB " + this.byteHexString(flags | c.interfaceVector.size() & 0xF) + ", ");
                JCClass superClass = c.getSuperClass();
                if (superClass == null) {
                    this.rom.append(this.byteHexString(255) + ", ");
                    this.rom.append(this.byteHexString(255) + ", ");
                } else {
                    this.rom.append("HIGH(" + this.shortHexString(superClass.getRelocAddr() + this.romBase) + "), ");
                    this.rom.append("LOW(" + this.shortHexString(superClass.getRelocAddr() + this.romBase) + "), ");
                }
                JCClass currentClass = c;
                int instanceSize = 0;
                while (currentClass != null) {
                    instanceSize += currentClass.getInstanceSize();
                    currentClass = currentClass.getSuperClass();
                }
                this.rom.append(this.byteHexString(instanceSize) + ", ");
                this.rom.append(this.byteHexString(c.getFirstReferenceToken()) + ", ");
                this.rom.append(this.byteHexString(c.getReferenceCount()) + ", ");
                this.rom.append(this.byteHexString(c.publicMethodTable.getBase()) + ", ");
                this.rom.append(this.byteHexString(c.publicMethodTable.getCount()) + ", ");
                this.rom.append(this.byteHexString(c.packageMethodTable.getBase()) + ", ");
                this.rom.append(this.byteHexString(c.packageMethodTable.getCount()) + ", ");
                this.rom.append(Msg.eol);
                Enumeration g2 = c.publicMethodTable.elements();
                while (g2.hasMoreElements()) {
                    JCMethod m = (JCMethod)g2.nextElement();
                    this.rom.append("DB HIGH(" + this.shortHexString(m.getRelocAddr() + this.romBase) + "), ");
                    this.rom.append("LOW(" + this.shortHexString(m.getRelocAddr() + this.romBase) + "),\t\t; " + m.getName() + Msg.eol);
                }
                Enumeration g3 = c.packageMethodTable.elements();
                while (g3.hasMoreElements()) {
                    JCMethod m = (JCMethod)g3.nextElement();
                    this.rom.append("DB HIGH(" + this.shortHexString(m.getRelocAddr() + this.romBase) + "), ");
                    this.rom.append("LOW(" + this.shortHexString(m.getRelocAddr() + this.romBase) + "),\t\t; " + m.getName() + Msg.eol);
                }
                Enumeration g4 = c.interfaceVector.elements();
                while (g4.hasMoreElements()) {
                    InterfaceTable itbl = (InterfaceTable)g4.nextElement();
                    byte[] table = itbl.toByteArray();
                    int addr = itbl.resolve().getRelocAddr();
                    this.rom.append("DB HIGH(" + this.shortHexString(addr + this.romBase) + "), ");
                    this.rom.append("LOW(" + this.shortHexString(addr + this.romBase) + "), ");
                    int i3 = 2;
                    while (i3 < table.length) {
                        this.rom.append(table[i3] + ", ");
                        ++i3;
                    }
                    this.rom.append(Msg.eol);
                }
                Enumeration g5 = c.fieldElements();
                while (g5.hasMoreElements()) {
                    Field field = (Field)g5.nextElement();
                    int mod = field.getAttributes();
                    if (!Modifier.isStatic(mod) || Modifier.isFinal(mod) || (mapTo = this.getMapEntry(field.getName())) == null) continue;
                    this.defineList.append("#define " + mapTo + " " + (field.getRelocAddr() + this.e2Base) + "\t/* " + field.getName() + " */" + Msg.eol);
                }
                g = c.methodElements();
                while (g.hasMoreElements()) {
                    JCMethod m = (JCMethod)g.nextElement();
                    if (Modifier.isNative(m.getAttributes())) continue;
                    mapTo = this.getMapEntry(m.getName());
                    if (mapTo != null) {
                        this.defineList.append("#define " + mapTo + " " + (m.getRelocAddr() + this.romBase) + "\t/* " + m.getName() + " */" + Msg.eol);
                    }
                    this.rom.append(Msg.eol + "; method@" + this.shortHexString(m.getRelocAddr()) + ": " + Modifier.toString(m.getAttributes()) + " " + m.getName() + Msg.eol);
                    byte[] header = m.getMethodHeader();
                    this.rom.append("DB ");
                    int i4 = 0;
                    while (i4 < header.length) {
                        this.rom.append(this.byteHexString(header[i4] & 0xFF) + ", ");
                        ++i4;
                    }
                    this.rom.append(Msg.eol);
                    if (Modifier.isAbstract(m.getAttributes())) continue;
                    Enumeration h = m.statementElements();
                    while (h.hasMoreElements()) {
                        Statement s = (Statement)h.nextElement();
                        this.format(s);
                        this.rom.append(", " + Msg.eol);
                    }
                    ExceptionTable exTbl = m.getExceptionTable();
                    if (exTbl == null) continue;
                    Enumeration h2 = exTbl.elements();
                    while (h2.hasMoreElements()) {
                        ExceptionTableEntry entry = (ExceptionTableEntry)h2.nextElement();
                        this.exceptionTable.append("{ ");
                        this.exceptionTable.append(this.shortHexString(entry.getStartOffset() + this.romBase) + ", ");
                        int active_length = entry.getActiveLength();
                        if (entry.isOuterMost()) {
                            active_length |= 0x8000;
                        }
                        this.exceptionTable.append(this.shortHexString(active_length) + ", ");
                        this.exceptionTable.append(this.shortHexString(entry.getHandlerOffset() + this.romBase) + ", ");
                        this.exceptionTable.append(this.shortHexString(entry.getCatchIndex() + this.romBase) + ", ");
                        this.exceptionTable.append(" }," + Msg.eol);
                        ++this.nExceptionEntries;
                    }
                }
            }
            byte[] exportComponentByteArray = export.toByteArray();
            this.exportComponent.append("; " + p.getName() + Msg.eol + "DB ");
            int i5 = 0;
            while (i5 < exportComponentByteArray.length) {
                this.exportComponent.append(this.byteHexString(exportComponentByteArray[i5]) + ", ");
                if (i5 % 8 == 7) {
                    this.exportComponent.append(Msg.eol);
                    if (i5 < exportComponentByteArray.length) {
                        this.exportComponent.append("DB ");
                    }
                }
                ++i5;
            }
            this.exportComponent.append(Msg.eol);
            this.exportComponentLength += exportComponentByteArray.length;
        }
    }

    protected void format(Statement s) {
        if (s.getInstruction() == null) {
            return;
        }
        this.format(s.getInstruction());
    }

    protected void format(Instruction i) {
        this.rom.append("DB _" + i.getMnemonic().toUpperCase());
        Enumeration e = i.operandElements();
        while (e.hasMoreElements()) {
            Operand o = (Operand)e.nextElement();
            this.format(o);
        }
    }

    protected void format(Operand o) {
        if (o.getType() == 8) {
            Info info = o.resolve();
            switch (info.getType()) {
                case 1: 
                case 4: 
                case 6: {
                    int addr = info.resolve().getRelocAddr();
                    this.rom.append(", HIGH(" + this.shortHexString(addr + this.romBase) + "), LOW(" + this.shortHexString(addr + this.romBase) + ")");
                    break;
                }
                case 5: {
                    int addr = info.resolve().getRelocAddr();
                    this.rom.append(", HIGH(" + this.shortHexString(addr + this.e2Base) + "), LOW(" + this.shortHexString(addr + this.e2Base) + ")");
                    break;
                }
                case 3: {
                    JCMethod m = (JCMethod)info.resolve();
                    MethodIdentifier mid = m.getMethodIdentifier();
                    int token = mid.getMethodToken();
                    int params = m.getParams();
                    this.rom.append(", " + this.byteHexString(params) + ", " + this.byteHexString(token));
                    break;
                }
                case 2: {
                    Field f = (Field)info.resolve();
                    JCClass c = f.getParentClass();
                    int fToken = f.getFieldIdentifier().getFieldToken();
                    int offset = fToken + c.getInstanceBase();
                    this.rom.append(", " + this.byteHexString(offset >> 8) + ", " + this.byteHexString(offset & 0xFF));
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        } else if (o.getType() == 7) {
            Info info = o.resolve();
            switch (info.getType()) {
                case 2: {
                    Field f = (Field)info.resolve();
                    JCClass c = f.getParentClass();
                    int fToken = f.getFieldIdentifier().getFieldToken();
                    int offset = fToken + c.getInstanceBase();
                    this.rom.append(", " + this.byteHexString(offset));
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        } else if (o.size() == 1) {
            this.rom.append(", " + o.getValue());
        } else if (o.size() == 2) {
            this.rom.append(", " + (o.getValue() >> 8 & 0xFF) + ", " + (o.getValue() & 0xFF));
        } else if (o.size() == 4) {
            this.rom.append(", " + (o.getValue() >> 24 & 0xFF) + ", " + (o.getValue() >> 16 & 0xFF));
            this.rom.append(", " + (o.getValue() >> 8 & 0xFF) + ", " + (o.getValue() & 0xFF));
        }
    }

    public void write(OutputStream os) {
        PrintWriter pw = new PrintWriter(os);
        pw.println(this.preamble.toString());
        pw.println(this.rom.toString());
        pw.println(this.exceptionTable.toString());
        pw.println("EXTBL_LENGTH EQU $ - EXCEPTION_TABLE" + Msg.eol);
        pw.print(this.staticFields.toString());
        pw.println("DS " + this.relocFieldPc + Msg.eol);
        pw.println(this.staticInit.toString());
        pw.println("STATIC_INIT_LENGTH EQU $ - STATIC_INIT" + Msg.eol);
        pw.println(this.applets.toString());
        pw.println("APPLET_TBL_LENGTH EQU $ - APPLET_TABLE" + Msg.eol);
        pw.println("$IF (POST_ISSUANCE_INSTALL = 1)");
        pw.print(this.packages.toString());
        pw.println("PACKAGE_TBL_LENGTH EQU $ - PACKAGE_TABLE" + Msg.eol);
        pw.print(this.exportComponent.toString());
        pw.println("EXPORT_COMP_LENGTH EQU $ - EXPORT_COPMPONENT" + Msg.eol);
        pw.println("$ENDIF\t;POST_ISSUANCE_INSTALL");
        pw.flush();
    }

    private String byteHexString(int data) {
        StringBuffer sb = new StringBuffer();
        sb.append(Integer.toHexString(data &= 0xFF) + "h");
        if (sb.length() == 2) {
            sb.insert(0, '0');
        } else {
            switch (sb.charAt(0)) {
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    sb.insert(0, '0');
                }
            }
        }
        return sb.toString();
    }

    private String shortHexString(int data) {
        StringBuffer sb = new StringBuffer();
        sb.append(Integer.toHexString(data &= 0xFFFF) + "h");
        switch (sb.charAt(0)) {
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                sb.insert(0, '0');
            }
        }
        return sb.toString();
    }
}

