/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javacard.jcdebugproxy;

import com.oracle.javacard.jcdebugproxy.ClassFileTokens;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ExportFileParser {
    private static <T extends ClassFileTokens.MemberDebugInfo> T readMember(T member, CPEntry[] cp, InputStream in) throws IOException {
        member.token = in.read();
        int access_flags = ExportFileParser.readShort(in);
        member.init(ExportFileParser.getString(cp, ExportFileParser.readShort(in)), ExportFileParser.getString(cp, ExportFileParser.readShort(in)), access_flags);
        return member;
    }

    private static CPEntry readCP(InputStream in) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        CPEntry retVal = new CPEntry();
        retVal.tag = in.read();
        switch (retVal.tag) {
            case 13: {
                map.put("flags", in.read());
                map.put("name_index", ExportFileParser.readShort(in));
                map.put("version", ExportFileParser.readShort(in));
                byte[] aid = new byte[in.read()];
                if (in.read(aid) == -1) {
                    throw new IOException("Read failed");
                }
                map.put("aid", aid);
                retVal.value = map;
                break;
            }
            case 7: {
                retVal.value = ExportFileParser.readShort(in);
                break;
            }
            case 3: {
                retVal.value = ExportFileParser.readShort(in) << 16 | ExportFileParser.readShort(in);
                break;
            }
            case 1: {
                retVal.value = ClassFileTokens.readUTF(in, ExportFileParser.readShort(in));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown CP entry:" + retVal.tag);
            }
        }
        return retVal;
    }

    static String getString(CPEntry[] pool, int index) {
        CPEntry cp = pool[index];
        if (cp.tag == 7) {
            return ExportFileParser.getString(pool, (Integer)cp.value);
        }
        return (String)pool[index].value;
    }

    public static ClassFileTokens.ClassDebugInfoImpl createDummyClass() {
        ClassFileTokens.ClassDebugInfoImpl cl = new ClassFileTokens.ClassDebugInfoImpl(255);
        cl.setPackageID((short)255);
        cl.name = "SystemClass";
        cl.superClasses = new String[]{"java/lang/Object"};
        cl.superclass_name = "java/lang/Object";
        cl.interface_names = new String[0];
        cl.fields = new ClassFileTokens.FieldDebugInfoImpl[0];
        cl.source_file = "SystemClass";
        ClassFileTokens.MethodDebugInfoImpl dummyMethod = new ClassFileTokens.MethodDebugInfoImpl(cl, 0, "SystemCode", "()");
        dummyMethod.access_flags = 8;
        cl.methods = new ClassFileTokens.MethodDebugInfoImpl[]{dummyMethod};
        cl.classId = 0x100FFFF;
        return cl;
    }

    private static ClassFileTokens.ClassDebugInfoImpl readClassDescr(InputStream in, int index, CPEntry[] cp) throws IOException {
        int i;
        ClassFileTokens.ClassDebugInfoImpl cl = new ClassFileTokens.ClassDebugInfoImpl(index);
        cl.token = in.read();
        cl.access_flags = ExportFileParser.readShort(in);
        cl.name = ExportFileParser.getString(cp, ExportFileParser.readShort(in));
        cl.superClasses = new String[ExportFileParser.readShort(in)];
        for (i = 0; i < cl.superClasses.length; ++i) {
            cl.superClasses[i] = ExportFileParser.getString(cp, ExportFileParser.readShort(in));
        }
        cl.interface_names = new String[in.read()];
        for (i = 0; i < cl.interface_names.length; ++i) {
            cl.interface_names[i] = ExportFileParser.getString(cp, ExportFileParser.readShort(in));
        }
        cl.fields = new ClassFileTokens.FieldDebugInfoImpl[ExportFileParser.readShort(in)];
        for (i = 0; i < cl.fields.length; ++i) {
            cl.fields[i] = ExportFileParser.readMember(new ClassFileTokens.FieldDebugInfoImpl(), cp, in);
            int attrLength = ExportFileParser.readShort(in);
            if (attrLength <= 0) continue;
            if (in.skip(6L) != 6L) {
                throw new IOException("Skip failed");
            }
            int constantValueIndex = ExportFileParser.readShort(in);
            cl.fields[i].contents = (Integer)cp[constantValueIndex].value;
            int toSkip = (attrLength - 1) * 8;
            if (in.skip(toSkip) == (long)toSkip) continue;
            throw new IOException("Skip failed");
        }
        cl.methods = new ClassFileTokens.MethodDebugInfoImpl[ExportFileParser.readShort(in)];
        for (i = 0; i < cl.methods.length; ++i) {
            cl.methods[i] = ExportFileParser.readMember(new ClassFileTokens.MethodDebugInfoImpl(cl, i), cp, in);
        }
        return cl;
    }

    public static ClassFileTokens parse(InputStream in) throws IOException {
        ArrayList<ClassFileTokens.ClassDebugInfoImpl> list = new ArrayList<ClassFileTokens.ClassDebugInfoImpl>();
        int magic = ExportFileParser.readShort(in) << 16 | ExportFileParser.readShort(in);
        if (magic != 16435934) {
            throw new IllegalArgumentException("is not an export file");
        }
        if (ExportFileParser.readShort(in) == -1) {
            throw new IOException("Read failed");
        }
        CPEntry[] cp = new CPEntry[ExportFileParser.readShort(in)];
        for (int i = 0; i < cp.length; ++i) {
            cp[i] = ExportFileParser.readCP(in);
        }
        int this_package = ExportFileParser.readShort(in);
        int export_class_count = in.read();
        for (int i = 0; i < export_class_count; ++i) {
            list.add(ExportFileParser.readClassDescr(in, i, cp));
        }
        byte[] aid = (byte[])((Map)cp[this_package].value).get("aid");
        return new ClassFileTokens(false, aid, list.toArray(new ClassFileTokens.ClassDebugInfoImpl[list.size()]));
    }

    static int readShort(InputStream in) throws IOException {
        return in.read() << 8 | in.read();
    }

    public static void main(String[] args) throws IOException {
        for (String name : args) {
            System.out.println("--------> " + name);
            System.out.println(ExportFileParser.parse(new FileInputStream(name)));
        }
    }

    private static class CPEntry {
        int tag;
        Object value;

        private CPEntry() {
        }

        public String toString() {
            return "CPEntry{tag=" + this.tag + ", value=" + this.value + '}';
        }
    }
}

