/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javacard.jcdebugproxy;

import com.oracle.javacard.jcdebugproxy.ClassFileTokens;
import com.oracle.javacard.jcdebugproxy.DebugComponentMissingException;
import com.oracle.javacard.jcdebugproxy.DebugProxyMain;
import com.oracle.javacard.jcdebugproxy.ExportFileParser;
import com.oracle.tee.tools.util.CapFile;
import com.oracle.tee.tools.util.FileUtils;
import com.oracle.tee.tools.util.RecursiveIterator;
import com.oracle.tee.tools.util.Utils;
import com.oracle.tee.tools.util.ZipFileSystem;
import com.sun.javacard.debugproxy.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IDEClassPath {
    private final HashMap<String, ClassFileTokens> packages = new HashMap();
    private final ArrayList<ClassFileTokens> packagesByIDEClassPathOrder = new ArrayList();
    private static final List<WeakReference<File>> tmpFiles = Collections.synchronizedList(new LinkedList());
    private static final List<WeakReference<CapFile>> capFiles = Collections.synchronizedList(new LinkedList());
    private String trustletInstallAID;

    public void addFiles(String ... list) {
        ArrayList<File> files = new ArrayList<File>();
        for (String path : list) {
            files.add(new File(path));
        }
        this.setFileList(files, "*");
    }

    public void setPath(String pathList) throws IOException {
        boolean parseSystemClasses;
        Log.LOG(3, "setPath:" + pathList);
        this.packages.clear();
        this.packagesByIDEClassPathOrder.clear();
        if (pathList == null) {
            return;
        }
        String[] list = pathList.split(File.pathSeparator);
        if (!DebugProxyMain.isGenerateDebugInfo()) {
            this.setFileList(FileUtils.find(new RecursiveIterator.ExtensionFilter(".cap"), list), "cap");
        }
        boolean bl = parseSystemClasses = !DebugProxyMain.hasDebugInfo();
        if (parseSystemClasses) {
            if (!DebugProxyMain.isInSystemClassesDebuggingMode()) {
                this.setFileList(FileUtils.find(new RecursiveIterator.ExtensionFilter(".exp"), list), "exp");
            }
        } else {
            Log.LOG(3, "'IDEClassPath' skipping parsing system classes. 'VMClassPool' will self-initialize from debug-info file");
        }
    }

    private CapFile[] getOrderedLibrariesCapFiles(CapFile cap) throws IOException {
        LinkedList<CapFile> l = new LinkedList<CapFile>();
        for (String path : cap.listAllFiles()) {
            if (!path.startsWith("lib/")) continue;
            Log.LOG(3, "found lib: " + path);
            String libTapName = path.substring(path.lastIndexOf(47) + 1);
            File tmpDir = new File(System.getProperty("java.io.tmpdir") + File.separator + "JavaCard");
            if (!tmpDir.exists() && !tmpDir.mkdirs()) {
                throw new IOException("Failed to create " + tmpDir);
            }
            File tmpFile = File.createTempFile("javacard.lib.", libTapName, tmpDir);
            tmpFiles.add(new WeakReference<File>(tmpFile));
            tmpFile.deleteOnExit();
            try (FileOutputStream fos = new FileOutputStream(tmpFile);
                 InputStream in = cap.openToRead(path);){
                byte[] buffer = new byte[256];
                int read = in.read(buffer);
                while (read > 0) {
                    fos.write(buffer);
                    fos.flush();
                    read = in.read(buffer);
                }
            }
            Log.LOG(3, "copied lib: " + tmpFile);
            try {
                CapFile libCapFile = new CapFile(tmpFile);
                capFiles.add(new WeakReference<CapFile>(libCapFile));
                l.add(libCapFile);
            }
            catch (IOException e) {
                Log.LOG(1, "Error in parsing lib " + libTapName + " (" + e.getMessage() + "). This may impact debugging. Please check " + libTapName);
            }
        }
        return l.toArray(new CapFile[l.size()]);
    }

    private void setFileList(Iterable<File> list, String ext) {
        Log.LOG(3, "*setFileList ext:" + ext);
        for (File file : list) {
            try {
                ClassFileTokens cft;
                Log.LOG(3, "parse ClassFileTokens from - " + ext + " file - :" + file.getAbsolutePath());
                String path = file.getAbsolutePath().toLowerCase(Locale.getDefault());
                CapFile[] libs = null;
                if (path.endsWith(".exp")) {
                    cft = ExportFileParser.parse(new FileInputStream(file));
                } else {
                    CapFile cap = new CapFile(file);
                    libs = this.getOrderedLibrariesCapFiles(cap);
                    cft = new ClassFileTokens(cap);
                }
                if (this.handleSpecialSCDCases(cft, file)) continue;
                if (libs != null) {
                    for (CapFile lib : libs) {
                        ClassFileTokens libcft = new ClassFileTokens(lib);
                        this.addNewPackage(libcft);
                    }
                }
                this.addNewPackage(cft);
            }
            catch (IOException ex) {
                Log.LOG(3, "caught:" + ex);
            }
            catch (DebugComponentMissingException dcme) {
                Log.LOG(3, dcme.getMessage());
                Log.LOG(3, "NOTE: can ignore the above warning, if this is just one specific file. if many files, and trying to use SCD, please rebuild trunk with SCD enabled.");
            }
        }
        System.out.println("num of debuggable packages: " + this.packages.size());
    }

    void readTrustletAID(File tapFile) throws IOException {
        System.out.println("trustletInstallAID: " + this.trustletInstallAID);
    }

    private void addNewPackage(ClassFileTokens cft) {
        String aid = Utils.canonize(cft.getPackageAID());
        if (cft.hasDebugInfo()) {
            System.out.println("debuggable package: " + cft.getPackageName() + " aid: " + aid);
        } else {
            System.out.println("un-debuggable package: " + cft.getPackageName() + " aid: " + aid);
        }
        if (this.packages.containsKey(aid)) {
            Log.LOG(3, "AID already contained");
        } else {
            this.packages.put(aid, cft);
            this.packagesByIDEClassPathOrder.add(cft);
        }
    }

    private boolean handleSpecialSCDCases(ClassFileTokens cft, File file) {
        if ("com/jnet/util".equals(cft.getPackageName())) {
            Log.LOG(2, "package:" + cft.getPackageName() + " hasDebugInfo: " + cft.hasDebugInfo());
            Log.LOG(2, "SCD Warning: ****** IGNORING com/jnet/util CAP file *******");
            return true;
        }
        if (DebugProxyMain.isInSystemClassesDebuggingMode() && cft.getPackageName() == null) {
            Log.LOG(2, "package:" + cft.getPackageName() + " hasDebugInfo: " + cft.hasDebugInfo());
            Log.LOG(2, "SCD Warning: THIS MIGHT BREAK NB DEBUGGING! " + file.getAbsolutePath());
            if (file.getName().equals("security.jar") || file.getName().equals("security.exp")) {
                Log.LOG(2, "SCD Warning: ****** add package name to " + file.getName() + " *******");
                Log.LOG(2, "SCD Warning: cap.setPackageName() called for cap w\\o package name: " + cft.getClasses()[0].getClassName());
                cft.setPackageName("javacard/security");
            }
        }
        return false;
    }

    public int getIDEClassPathPackagesNum() {
        return this.packages.size();
    }

    public boolean doesPackageExist(String prefix, String id, String aid) {
        ClassFileTokens cft = this.packages.get(aid);
        if (cft == null) {
            Log.LOG(2, prefix + " > package (" + id + ") aid: " + aid + " does not exist in IDEClassPath");
            return false;
        }
        return true;
    }

    public ClassFileTokens getByAID(String aid) {
        return this.packages.get(aid);
    }

    public ArrayList<ClassFileTokens> getByIDEClassPathOrder() {
        return this.packagesByIDEClassPathOrder;
    }

    public String getTrustletInstallAID() {
        return this.trustletInstallAID;
    }

    public void printIDEClassPathInfo() {
        Log.LOG(3, "IDEClassPath.printInfo: size: " + this.packages.size());
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object f;
                List list = capFiles;
                synchronized (list) {
                    for (WeakReference rf : capFiles) {
                        f = (CapFile)rf.get();
                        if (f == null) continue;
                        try {
                            ((ZipFileSystem)f).close();
                        }
                        catch (IOException ex) {
                            Logger.getLogger(IDEClassPath.class.getName()).log(Level.SEVERE, "Could not close {0}", f);
                        }
                    }
                }
                list = tmpFiles;
                synchronized (list) {
                    for (WeakReference rf : tmpFiles) {
                        f = (File)rf.get();
                        if (f == null || ((File)f).delete()) continue;
                        Logger.getLogger(IDEClassPath.class.getName()).log(Level.SEVERE, "Could not delete {0}", f);
                    }
                }
            }
        }));
    }
}

