/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javacard.jcdebugproxy.events;

import com.oracle.javacard.jcdebugproxy.events.BreakPointsPool;
import com.oracle.javacard.jcdebugproxy.events.EventFilter;
import com.sun.javacard.debugproxy.classic.VmState;
import com.sun.javacard.debugproxy.classparser.ClassDebugInfo;
import com.sun.javacard.debugproxy.classparser.MethodDebugInfo;
import com.sun.javacard.debugproxy.types.Location;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;

public class EncodingUtils {
    public static final byte BREAKPOINTS_TYPE = 1;
    public static final byte STEPPING_TYPE = 2;
    private static EncodingUtils instance = new EncodingUtils();

    public static EncodingUtils getInstance() {
        return instance;
    }

    public int encodeStepRequest(DataOutputStream toVm, VmState state, EventFilter filter) throws IOException {
        if (state.getState() != VmState.State.SUSPENDED) {
            throw new IllegalArgumentException("Can step from suspended state only");
        }
        toVm.write(2);
        EventFilter.StepModifier step = (EventFilter.StepModifier)filter.getModifier(10);
        step.writeForVM(toVm, state.findNextLineLocation());
        toVm.writeShort((short)filter.getID());
        return filter.getID();
    }

    public int encodeBreakPointRequest(DataOutputStream toVm, Location location) throws IOException {
        int id = BreakPointsPool.locationToId(location);
        toVm.write(1);
        toVm.write(id >> 16);
        toVm.writeShort((short)id);
        return id;
    }

    public int encodeBreakPointRequest(DataOutputStream toVm, EventFilter filter) throws IOException {
        EventFilter.LocationModifier loc = (EventFilter.LocationModifier)filter.getModifier(7);
        int id = this.encodeBreakPointRequest(toVm, loc.location);
        filter.setID(id);
        return id;
    }

    public void encodeClearStepRequest(DataOutputStream toVm, int id) throws IOException {
        toVm.write(2);
        toVm.writeShort((short)id);
    }

    public void encodeBreakPoint(DataOutputStream toVm, int id) throws IOException {
        toVm.write(1);
        toVm.write((byte)(id >> 16));
        toVm.writeShort((short)id);
    }

    public void encodeBreakPoints(DataOutputStream toVm, List<Location> toRm, int offset, int length) throws IOException {
        toVm.write(1);
        int upper = offset + length;
        for (int i = offset; i < upper; ++i) {
            int id = BreakPointsPool.locationToId(toRm.get(i));
            toVm.write((byte)(id >> 16));
            toVm.writeShort((short)id);
        }
    }

    public static Location createLocation(ClassDebugInfo cl, MethodDebugInfo meth, long offset) {
        Location location = new Location();
        location.typeTag = 1;
        location.cl = cl;
        location.classId = cl.getClassID();
        location.meth = meth;
        location.methodId = meth.getID();
        location.offset = offset;
        return location;
    }
}

