/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javacard.jcdebugproxy.events;

import com.oracle.javacard.jcdebugproxy.events.EventFilter;
import com.oracle.javacard.jcdebugproxy.events.EventHandlerImpl;
import com.oracle.javacard.jcdebugproxy.events.JDWPEvent;
import com.oracle.javacard.jcdebugproxy.events.OnCardEvent;
import com.sun.javacard.debugproxy.classic.ClassicPacketHandler;
import com.sun.javacard.debugproxy.classic.HandlerState;
import com.sun.javacard.debugproxy.classic.VmState;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;

public class StateEventHandler
extends EventHandlerImpl {
    private final byte kind;
    private final LinkedHashMap<Integer, EventFilter> requests = new LinkedHashMap();

    public StateEventHandler(byte vmKind) {
        this.kind = vmKind;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassicPacketHandler.DeliveryType handleClearEventRequest(int id, HandlerState state, DataOutputStream toVM) throws Exception {
        boolean isEmpty;
        EventFilter filter;
        LinkedHashMap<Integer, EventFilter> linkedHashMap = this.requests;
        synchronized (linkedHashMap) {
            filter = (EventFilter)this.requests.remove(id);
            if (filter != null) {
                filter.state = EventFilter.State.Disabled;
            }
            isEmpty = this.cleared(filter);
        }
        if (isEmpty) {
            toVM.writeByte(this.kind);
            this.writeClearArguments(toVM, filter);
            return ClassicPacketHandler.DeliveryType.NORMAL;
        }
        return super.handleClearEventRequest(id, state, toVM);
    }

    protected boolean cleared(EventFilter filter) {
        return this.requests.isEmpty();
    }

    @Override
    public void handleEventFromCard(OnCardEvent event) throws Exception {
        Collection<JDWPEvent> reported = JDWPEvent.convertEvent(event, this.requests);
        if (reported.isEmpty()) {
            this.proxy.requestVMStateChange(VmState.State.RUNNING);
        }
        this.proxy.sendEventsToIDE((byte)2, reported);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addRequest(EventFilter filter) {
        boolean wasEmpty;
        LinkedHashMap<Integer, EventFilter> linkedHashMap = this.requests;
        synchronized (linkedHashMap) {
            wasEmpty = this.requests.isEmpty();
            this.requests.put(filter.getID(), filter);
        }
        return wasEmpty;
    }

    protected void writeClearArguments(DataOutputStream toVm, EventFilter filter) throws IOException {
    }

    protected void writeArguments(DataOutputStream toVm, EventFilter filter) throws IOException {
    }

    @Override
    public ClassicPacketHandler.DeliveryType handleSetEventRequest(EventFilter filter, HandlerState state, DataOutputStream toVm) throws Exception {
        if (this.addRequest(filter)) {
            toVm.writeByte(this.kind);
            this.writeArguments(toVm, filter);
            return ClassicPacketHandler.DeliveryType.NORMAL;
        }
        return ClassicPacketHandler.DeliveryType.NONE;
    }
}

