/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugproxy.classic;

import com.oracle.javacard.jcdebugproxy.ClassFileTokens;
import com.oracle.javacard.jcdebugproxy.DebugProxyMain;
import com.oracle.javacard.jcdebugproxy.IDEClassPath;
import com.oracle.javacard.jcdebugproxy.events.EventManager;
import com.oracle.tee.tools.util.Closables;
import com.oracle.tee.tools.util.Utils;
import com.sun.javacard.debugproxy.JDWPListener;
import com.sun.javacard.debugproxy.Log;
import com.sun.javacard.debugproxy.classic.ArrayReferenceConverters;
import com.sun.javacard.debugproxy.classic.ArrayTypeConverters;
import com.sun.javacard.debugproxy.classic.ClassTypeConverters;
import com.sun.javacard.debugproxy.classic.ClassicPacketHandler;
import com.sun.javacard.debugproxy.classic.HandlerState;
import com.sun.javacard.debugproxy.classic.InvalidRequestException;
import com.sun.javacard.debugproxy.classic.MethodConverters;
import com.sun.javacard.debugproxy.classic.ObjectReferenceConverters;
import com.sun.javacard.debugproxy.classic.ReferenceTypeConverters;
import com.sun.javacard.debugproxy.classic.StackFrameConverters;
import com.sun.javacard.debugproxy.classic.StringReferenceConverters;
import com.sun.javacard.debugproxy.classic.ThreadConverters;
import com.sun.javacard.debugproxy.classic.VMPacketHandler;
import com.sun.javacard.debugproxy.classic.VirtualMachineConverter;
import com.sun.javacard.debugproxy.classic.VmState;
import com.sun.javacard.debugproxy.classic.handlers.UnsupportedOperationHandler;
import com.sun.javacard.debugproxy.classparser.VMClassPool;
import com.sun.javacard.debugproxy.comm.ByteArrayDataOutputStream;
import com.sun.javacard.debugproxy.comm.ClassicVMConnection;
import com.sun.javacard.debugproxy.comm.CommConnection;
import com.sun.javacard.debugproxy.comm.CommListener;
import com.sun.javacard.debugproxy.comm.Packet;
import com.sun.javacard.debugproxy.comm.SocketConnection;
import com.sun.javacard.debugproxy.types.PacketElement;
import com.sun.javacard.debugproxy.types.RawDataPacketElement;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.ServerSocket;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClassicProxyProtocol
implements CommListener,
JDWPListener,
Runnable {
    static final byte[] JDWP_HANDSHAKE = "JDWP-Handshake".getBytes(StandardCharsets.UTF_8);
    public static final int MAX_PACKET_LENGTH = 255;
    public static final short STATUS_CHANGE_ID = -1;
    public static final int RESPONSE_ID_MASK = Short.MAX_VALUE;
    private static final int MAX_HISTORY_LENGTH = 10;
    private CommConnection toIde;
    private ClassicVMConnection toVM;
    private static short packetCounter = 0;
    private final Map<Integer, HandlerState> sendingPackets = Collections.synchronizedMap(new HashMap());
    private Map<String, ClassFileTokens> map;
    private ClassicPacketHandler[][] converters = null;
    private final VmState state;
    public EventManager events;
    Closables manager = new Closables();
    public static final DataInputStream EMPTY = new DataInputStream(new ByteArrayInputStream(new byte[0]));
    public static final byte[] EMPTY_DATA = new byte[0];
    public boolean isTerminated = false;
    private ConnectionState connState;
    private final int serverPort;
    private File restoreDir;
    private ArrayList<ProxyStateChangeListener> listeners = new ArrayList();
    private final IDEClassPath idePath;
    private File initImage;
    byte[] session_id;
    private boolean isClosed = false;
    private final ExecutorService executor = Utils.newCachedThreadPool("ClassicProxyProtocol");

    public boolean isConnectedToIde() {
        return this.connState != ConnectionState.DISCONNECTED;
    }

    public IDEClassPath getIDEClassPath() {
        return this.idePath;
    }

    public void detach() throws Exception {
        this.toIde.stop();
    }

    public ClassicProxyProtocol(int port, IDEClassPath path) {
        this.serverPort = port;
        this.idePath = path;
        this.state = new VmState(new VMClassPool());
        this.events = new EventManager(this);
        this.connState = ConnectionState.NOT_RUNNING;
    }

    public void startHandshakeWithVM() {
        Log.LOG(3, "ClassicProxyProtocol.startHandshakeWithVM");
        ByteArrayDataOutputStream out = null;
        FileInputStream fis = null;
        try {
            out = new ByteArrayDataOutputStream();
            out.write((byte)VMPacketHandler.CommandCode.START.getTag());
            out.write(0);
            out.writeInt(-889275714);
            String[] names = this.list(this.restoreDir);
            Log.LOG(3, "names in restoreDir:" + names.length);
            out.write(names.length + 1);
            for (String name : names) {
                out.write(16);
                out.write(Utils.parse(name));
                Log.LOG(3, "names: " + name);
            }
            out.write(-112);
            this.session_id = this.createSessionID();
            out.write(this.session_id);
            byte[] data = out.toByteArray();
            data[1] = (byte)(data.length - 2);
            Log.LOG(3, "send handshake to VM...");
            DataInputStream response = this.sendToVmSync(data);
            int id = response.read();
            Log.LOG(3, "handshake response received. id:" + id);
            if (id >= 0 && id < names.length) {
                Log.LOG(1, "THIS SHOULD NOT HAPPEN: session id: " + Arrays.toString(this.session_id));
                this.session_id = Utils.parse(names[id]);
                Log.LOG(2, "session_id:" + Arrays.toString(this.session_id));
                File file = new File(this.restoreDir, names[id]);
                Log.LOG(2, "reading restored session debug-info: " + file.getAbsolutePath());
                fis = new FileInputStream(file);
                this.state.classes().restore(fis);
            } else if (this.initImage != null) {
                Log.LOG(4, "initializing VMClassPool from file:" + this.initImage.getAbsolutePath());
                this.state.classes().restore(new FileInputStream(this.initImage));
                this.state.classes().printClassPoolInfo();
                this.state.classes().sendDebugInfo(this);
            } else if (DebugProxyMain.isInSystemClassesDebuggingMode()) {
                Log.LOG(4, "inject SCD packages from IDEClassPath into VMClassPool:");
                this.idePath.printIDEClassPathInfo();
                this.state.classes().printClassPoolInfo();
                for (ClassFileTokens cap : this.idePath.getByIDEClassPathOrder()) {
                    this.state.classes().addSCDPackage(cap);
                }
                this.state.classes().printClassPoolInfo();
                Log.LOG(3, "sending debug info from parsed system classes cap files..");
                this.state.classes().sendDebugInfo(this);
            }
            Log.LOG(3, "-- setting VM state as SUSPENDED\\RUNNING (hardcoded!!) --");
            this.state().setState(VmState.State.SUSPENDED);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Handshake failed", ex);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private String[] list(File file) {
        if (file == null || !file.isDirectory()) {
            return new String[0];
        }
        Object[] names = file.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.length() == 32 && Utils.isHexString(name);
            }
        });
        if (names != null && names.length > 10) {
            Arrays.sort(names);
            String[] subset = new String[10];
            System.arraycopy(names, names.length - 10, subset, 0, 10);
            int upTo = names.length - 10;
            for (int i = 0; i < upTo; ++i) {
                new File(file, (String)names[i]).delete();
            }
            return subset;
        }
        return names;
    }

    private byte[] createSessionID() {
        long time = System.currentTimeMillis();
        long salt = ClassicProxyProtocol.getSecureRandom().nextLong();
        return new byte[]{(byte)(time >> 56), (byte)(time >> 48), (byte)(time >> 40), (byte)(time >> 32), (byte)(time >> 24), (byte)(time >> 16), (byte)(time >> 8), (byte)time, (byte)(salt >> 56), (byte)(salt >> 48), (byte)(salt >> 40), (byte)(salt >> 32), (byte)(salt >> 24), (byte)(salt >> 16), (byte)(salt >> 8), (byte)salt};
    }

    private static SecureRandom getSecureRandom() {
        SecureRandom sr;
        try {
            try {
                sr = SecureRandom.getInstance("SHA1PRNG", "SUN");
            }
            catch (NoSuchProviderException ex) {
                sr = SecureRandom.getInstance("SHA1PRNG");
            }
        }
        catch (NoSuchAlgorithmException ex) {
            sr = new SecureRandom();
        }
        sr.nextBytes(new byte[8]);
        return sr;
    }

    public boolean start() {
        this.setConnectionState(ConnectionState.RUNNING);
        try {
            this.init();
            new Thread((Runnable)this, "ClassicProxyProtocol.run").start();
            this.waitingState(ConnectionState.VM_CONNECTED);
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ServerSocket server = null;
        try {
            new Thread((Runnable)this.toVM, "StreamVMConnection.run").start();
            this.startHandshakeWithVM();
            this.setConnectionState(ConnectionState.VM_CONNECTED);
            while (this.connState != ConnectionState.TERMINATED) {
                Log.LOG(3, "waiting for IDE on open server socket on port: " + this.serverPort);
                server = new ServerSocket(this.serverPort);
                this.manager.add(server);
                this.startProxy(server);
                this.setConnectionState(ConnectionState.DB_CONNECTED);
                this.waitingState(ConnectionState.DISCONNECTED, ConnectionState.TERMINATED);
            }
        }
        catch (Exception ex) {
            Log.LOG(3, "Closing debugger session: " + ex.getMessage());
        }
        finally {
            if (server != null) {
                try {
                    server.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void startProxy(ServerSocket server) throws Exception {
        boolean connected = false;
        while (!connected) {
            SocketConnection conn = new SocketConnection(server.accept());
            byte b = conn.receiveByte();
            if (b < 0) continue;
            Log.LOG(3, "new debugger connection!");
            this.setIde(conn);
            server.close();
            this.state.classes().init();
            try {
                for (int i = 1; i < JDWP_HANDSHAKE.length; ++i) {
                    conn.receiveByte();
                }
                connected = true;
                for (byte element : JDWP_HANDSHAKE) {
                    conn.sendByte(element);
                }
                byte[] data = new byte[]{90, 0, 0, 0, 0, -1, -1, -1, -31};
                RawDataPacketElement packet = new RawDataPacketElement(data);
                this.sendEventsToIDE((byte)2, Collections.singletonList(packet));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            new Thread((Runnable)conn, "SocketConnection.run").start();
        }
    }

    public void requestVMStateChange(VmState.State state) throws IOException {
        short id = (short)this.state().getNextRequestCounter();
        byte[] data = new byte[]{(byte)VMPacketHandler.CommandCode.SET_STATE.getTag(), 3, state.getCode(), (byte)(id >> 8), (byte)id};
        this.sendToVm(data, null);
    }

    public void sendPackageInfo(byte[] debuggable, byte[] nonDebuggable) throws Exception {
        byte[] data = new byte[debuggable.length + 4 + nonDebuggable.length];
        int pos = 0;
        data[pos++] = (byte)VMPacketHandler.CommandCode.SET_PACKAGES_INFO.getTag();
        data[pos++] = (byte)(data.length - 2);
        data[pos++] = (byte)debuggable.length;
        System.arraycopy(debuggable, 0, data, pos, debuggable.length);
        pos += debuggable.length;
        data[pos++] = (byte)nonDebuggable.length;
        System.arraycopy(nonDebuggable, 0, data, pos, nonDebuggable.length);
        this.sendToVm(data, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitingState(ConnectionState ... states) throws InterruptedException {
        ClassicProxyProtocol classicProxyProtocol = this;
        synchronized (classicProxyProtocol) {
            while (!this.isInState(states)) {
                this.wait();
            }
        }
    }

    private boolean isInState(ConnectionState ... states) {
        for (ConnectionState s : states) {
            if (this.connState != s) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setConnectionState(final ConnectionState state) {
        ClassicProxyProtocol classicProxyProtocol = this;
        synchronized (classicProxyProtocol) {
            this.connState = state;
            this.notifyAll();
        }
        if (state == ConnectionState.TERMINATED) {
            try {
                this.close();
            }
            catch (Exception ex) {
                Logger.getLogger(ClassicProxyProtocol.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        final ArrayList<ProxyStateChangeListener> list = this.listeners;
        this.executor.submit(new Thread("setConnectionState"){

            @Override
            public void run() {
                for (ProxyStateChangeListener listener : list) {
                    listener.stateChanged(state);
                }
            }
        });
    }

    public synchronized void addProxyStateChangeListener(ProxyStateChangeListener listener) {
        ArrayList<ProxyStateChangeListener> updated = new ArrayList<ProxyStateChangeListener>();
        updated.addAll(this.listeners);
        updated.add(listener);
        this.listeners = updated;
    }

    @Override
    public synchronized void detached() {
        if (this.connState != ConnectionState.TERMINATED) {
            this.setConnectionState(ConnectionState.DISCONNECTED);
            this.events.clearAll();
        }
    }

    public VmState state() {
        return this.state;
    }

    public void setCapFileMap(Map<String, ClassFileTokens> map) {
        this.map = map;
    }

    public void setRestoreDir(File dir) {
        this.restoreDir = dir;
    }

    public void setInitImage(File file) {
        this.initImage = file;
    }

    @Override
    public void vmConnected() {
    }

    @Override
    public void vmDisconnected() {
        this.setConnectionState(ConnectionState.TERMINATED);
        try {
            if (this.toIde != null) {
                this.toIde.close();
            }
            this.executor.shutdownNow();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public synchronized void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.manager.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void genDebugInfo(String dstFilePath) throws IOException {
        Log.LOGN(2, "Generating debug-info...");
        if (this.restoreDir == null) {
            String name = System.getProperty("user.home");
            if (name == null) {
                return;
            }
            this.restoreDir = new File(new File(name), ".jc-debug-proxy");
        }
        this.restoreDir.mkdirs();
        if (this.restoreDir.isDirectory()) {
            File file = new File(this.restoreDir, Utils.canonize(this.session_id));
            File logFile = new File(this.restoreDir, Utils.canonize(this.session_id) + ".log");
            try (FileOutputStream fos = null;){
                Log.LOGN(2, "writing debug-info to " + file.getAbsolutePath());
                Log.LOGN(2, "writing debug-info log to " + logFile.getAbsolutePath());
                fos = new FileOutputStream(file);
                this.state.classes().store(fos);
                this.state.classes().dumpHumanReadableLog(logFile);
                Files.copy(Paths.get(file.getAbsolutePath(), new String[0]), Paths.get(dstFilePath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    public String getAbsoluteDebugInfoPath() {
        return this.restoreDir + "\\" + Utils.canonize(this.session_id);
    }

    public void handlePacketFromIDE(final HandlerState state) throws Exception {
        this.executor.submit(new Thread("ClassicProxyProtocol.handlePacketFromIDE.run"){

            @Override
            public void run() {
                try {
                    ByteArrayDataOutputStream out = new ByteArrayDataOutputStream();
                    out.writeShort(0);
                    state.receipt = ((ClassicPacketHandler)state.handler).handleRequest(state, out);
                    if (state.receipt != ClassicPacketHandler.DeliveryType.NONE) {
                        byte[] data = out.toByteArray();
                        data[0] = (byte)state.handler.getCode().getTag();
                        data[1] = (byte)(data.length - 2);
                        if (data.length - 2 > 255) {
                            throw new IllegalArgumentException();
                        }
                        ClassicProxyProtocol.this.sendToVm(data, state);
                    } else {
                        ClassicProxyProtocol.this.processResponseData(state, EMPTY, 0);
                    }
                }
                catch (Exception e) {
                    ClassicProxyProtocol.this.processException(state.idFromIde, e);
                }
            }
        });
    }

    private void processResponseData(final HandlerState state, final DataInputStream in, final int length) throws Exception {
        this.executor.submit(new Thread("ClassicProxyProtocol.processResponseData.run"){

            @Override
            public void run() {
                try {
                    try {
                        state.handler.processResponseData(state, in, length);
                    }
                    catch (Exception e) {
                        ClassicProxyProtocol.this.processException(state.idFromIde, e);
                    }
                    if (state.receipt == ClassicPacketHandler.DeliveryType.NOT_COMPLETED) {
                        ClassicProxyProtocol.this.handlePacketFromIDE(state);
                    } else if (state.idFromIde != -1) {
                        ClassicProxyProtocol.this.toIde.send(new Packet(state.idFromIde, 128, 0, state.out.toByteArray()));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void processException(int id, Exception e) {
        if (Log.level > 2) {
            e.printStackTrace();
        }
        short code = e instanceof InvalidRequestException ? (short)((InvalidRequestException)e).getCode() : (short)41;
        this.processErrorStatus(id, code);
    }

    public void processErrorStatus(int id, short errorCode) {
        try {
            this.toIde.send(new Packet(id, 128, errorCode, EMPTY_DATA));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public DataInputStream sendToVmSync(byte[] data) throws IOException, InterruptedException {
        Sync sync = new Sync();
        HandlerState hs = new HandlerState(-1, null, sync);
        this.sendToVm(data, hs);
        sync.lock.await();
        return sync.response;
    }

    public synchronized void sendToVm(byte[] data, HandlerState state) throws IOException {
        short id = ClassicProxyProtocol.nextPacketID();
        if (state != null) {
            this.sendingPackets.put(Integer.valueOf(id), state);
        }
        this.toVM.send(id, data);
    }

    public <T extends PacketElement> boolean sendEventsToIDE(byte suspendPolicy, Collection<T> events) {
        ByteArrayDataOutputStream out = new ByteArrayDataOutputStream();
        if (events.isEmpty()) {
            return true;
        }
        try {
            out.writeByte(suspendPolicy);
            out.writeInt(events.size());
            for (PacketElement elem : events) {
                elem.write(out);
            }
            this.toIde.send(new Packet(64, 100, out.toByteArray()));
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    private static synchronized short nextPacketID() {
        packetCounter = (short)(packetCounter + 1);
        return packetCounter;
    }

    public void setIde(CommConnection toIde) {
        this.toIde = toIde;
        toIde.setProxyListener(this);
        this.manager.add(toIde);
    }

    public void setVm(ClassicVMConnection toVm) {
        this.toVM = toVm;
        toVm.setListener(this);
        this.manager.add(toVm);
    }

    public void init() {
        this.registerConverters();
        ClassicPacketHandler[][] arr$ = this.converters;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            ClassicPacketHandler[] row;
            for (ClassicPacketHandler handler : row = arr$[i$]) {
                if (handler == null) continue;
                handler.init(this);
            }
        }
    }

    public void quit() {
    }

    @Override
    public void packetReceived(Packet packet) {
        ClassicPacketHandler handler = this.getHandler(packet);
        if (handler == null) {
            Log.LOG(3, "Handler is null for " + packet);
            this.reportError(packet.getId());
        } else {
            try {
                DataInputStream in = new DataInputStream(new ByteArrayInputStream(packet.getData()));
                HandlerState hState = new HandlerState(packet.getId(), in, handler);
                this.handlePacketFromIDE(hState);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.reportError(packet.getId());
            }
        }
    }

    private void reportError(int id) {
        try {
            this.toIde.send(new Packet(id, 128, 0, EMPTY_DATA));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private ClassicPacketHandler getHandler(Packet packet) {
        ClassicPacketHandler[] list;
        int set = packet.commandSet - 1;
        int cmd = packet.command - 1;
        if (set < 0 || cmd < 0) {
            Log.LOG(3, "no handler found");
            return null;
        }
        if (set < this.converters.length && (list = this.converters[set]) != null && cmd < list.length) {
            return list[cmd];
        }
        Log.LOG(3, "no handler found");
        return null;
    }

    public static boolean isResponse(int id) {
        return id != 65535 && (id & Short.MAX_VALUE) != 0;
    }

    @Override
    public void packetFromVMReceived(int id, byte[] data) throws Exception {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
        if (!ClassicProxyProtocol.isResponse(id)) {
            this.parsePacketFromCard(in);
            return;
        }
        Integer key = id &= Short.MAX_VALUE;
        HandlerState bundle = this.sendingPackets.get(key);
        if (bundle == null) {
            return;
        }
        in.readByte();
        int length = in.readByte() & 0xFF;
        short errorCode = in.readShort();
        if (errorCode != 0) {
            Log.LOG(3, "GOT-ERROR_CODE:" + errorCode);
            this.processErrorStatus(bundle.idFromIde, errorCode);
        } else {
            this.processResponseData(bundle, in, length - 2);
        }
    }

    private void parsePacketFromCard(DataInputStream packet) throws Exception {
        VMPacketHandler.CommandCode command = VMPacketHandler.CommandCode.findCommandCodeByTag(packet.read());
        switch (command) {
            case STATE_CHANGED: 
            case GET_STACK: {
                this.events.parsePacketFromCard(command, packet);
                break;
            }
            default: {
                Log.LOG(3, "ERROR: UNKNOWN:" + (Object)((Object)command));
            }
        }
    }

    void addConverter(int set, int cmd, ClassicPacketHandler handler) {
        this.converters[set - 1][cmd - 1] = handler;
        if (handler != null) {
            handler.init(this);
        }
    }

    private static ClassicPacketHandler[][] createEmptyHandlers() {
        ClassicPacketHandler[][] retVal = new ClassicPacketHandler[][]{new ClassicPacketHandler[19], new ClassicPacketHandler[12], new ClassicPacketHandler[4], new ClassicPacketHandler[1], new ClassicPacketHandler[0], new ClassicPacketHandler[4], new ClassicPacketHandler[0], new ClassicPacketHandler[0], new ClassicPacketHandler[9], new ClassicPacketHandler[1], new ClassicPacketHandler[12], new ClassicPacketHandler[3], new ClassicPacketHandler[3], new ClassicPacketHandler[1], new ClassicPacketHandler[3], new ClassicPacketHandler[4], new ClassicPacketHandler[1]};
        return retVal;
    }

    private void registerConverters() {
        if (this.converters == null) {
            this.converters = ClassicProxyProtocol.createEmptyHandlers();
        }
        VirtualMachineConverter.registerConverters(this, this.map);
        ReferenceTypeConverters.registerReferenceTypeConverters(this);
        StringReferenceConverters.registerStringReferenceConverters(this);
        ClassTypeConverters.registerClassTypeConverters(this);
        MethodConverters.registerMethodConverters(this);
        ObjectReferenceConverters.registerObjectReferenceConverters(this);
        ReferenceTypeConverters.registerClassObjectReferenceConverters(this);
        ArrayReferenceConverters.registerArrayReferenceConverters(this);
        ArrayTypeConverters.registerArrayTypeConverters(this);
        ThreadConverters.registerThreadGroupConverters(this);
        StackFrameConverters.registerStackFrameConverters(this);
        this.addConverter(14, 1, new UnsupportedOperationHandler(507));
        this.addConverter(15, 1, this.events);
        this.addConverter(15, 2, this.events.getClearHandler());
        this.addConverter(15, 3, this.events.getClearAllBreakpointsHandler());
    }

    private static class Sync
    implements VMPacketHandler {
        public final CountDownLatch lock = new CountDownLatch(1);
        public DataInputStream response;

        private Sync() {
        }

        @Override
        public VMPacketHandler.CommandCode getCode() {
            return VMPacketHandler.CommandCode.NONE;
        }

        @Override
        public void processResponseData(HandlerState state, DataInputStream fromVm, int length) throws Exception {
            this.response = fromVm;
            this.lock.countDown();
        }
    }

    public static enum ConnectionState {
        NOT_RUNNING,
        RUNNING,
        VM_CONNECTED,
        DB_CONNECTED,
        DISCONNECTED,
        TERMINATED;

    }

    public static interface ProxyStateChangeListener {
        public void stateChanged(ConnectionState var1);
    }
}

