/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugproxy.classic;

import com.oracle.javacard.jcdebugproxy.ClassDebugUtils;
import com.sun.javacard.debugproxy.Log;
import com.sun.javacard.debugproxy.PacketEncodingUtils;
import com.sun.javacard.debugproxy.classic.ClassicPacketHandler;
import com.sun.javacard.debugproxy.classic.ClassicProxyProtocol;
import com.sun.javacard.debugproxy.classic.HandlerState;
import com.sun.javacard.debugproxy.classic.InvalidRequestException;
import com.sun.javacard.debugproxy.classic.ReferenceTypeConverters;
import com.sun.javacard.debugproxy.classic.VMPacketHandler;
import com.sun.javacard.debugproxy.classic.VmState;
import com.sun.javacard.debugproxy.classic.handlers.ChainPacketHandler;
import com.sun.javacard.debugproxy.classic.handlers.ClassicPacketHandlerImpl;
import com.sun.javacard.debugproxy.classic.handlers.FixedDataHandler;
import com.sun.javacard.debugproxy.classic.handlers.UnsupportedOperationHandler;
import com.sun.javacard.debugproxy.classparser.ClassDebugInfo;
import com.sun.javacard.debugproxy.classparser.FieldDebugInfo;
import com.sun.javacard.debugproxy.classparser.MethodDebugInfo;
import com.sun.javacard.debugproxy.classparser.VMClassPool;
import com.sun.javacard.debugproxy.comm.EncodingUtils;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class ObjectReferenceConverters {
    public static final byte Header_Simple_Object = 32;
    public static final byte Header_ArrayType_Boolean = 96;
    public static final byte Header_ArrayType_Byte = -128;
    public static final byte Header_ArrayType_Short = -96;
    public static final byte Header_ArrayType_Int = -64;
    public static final byte Header_ArrayType_Reference = -32;
    public static final int MAX_GET_VALUES_PER_REQUEST = 50;

    private static int extractClassId(long longFieldID) {
        return (int)(longFieldID >> 32 & 0xFFFFFFFFFFFFFFFFL);
    }

    static byte getReturnTypeTag(MethodDebugInfo method) {
        String signature = method.getSignatureRaw();
        int index = signature.indexOf(41) + 1;
        if (index == -1 || index > signature.length()) {
            Log.LOG(3, "Incorrect method signature: " + signature);
            return 86;
        }
        return ReferenceTypeConverters.getTypeTag(signature.substring(index));
    }

    static void writeTaggedValue(DataInputStream from, DataOutputStream to, byte typeTag, short errorCode) throws IOException {
        to.writeByte(typeTag);
        switch (typeTag) {
            case 66: 
            case 90: {
                to.writeByte(from.readByte());
                break;
            }
            case 83: {
                to.writeShort(from.readShort());
                break;
            }
            case 73: 
            case 76: 
            case 91: 
            case 115: {
                to.writeInt(from.readInt());
                break;
            }
            default: {
                Log.LOG(3, "Unknown type: " + typeTag);
                throw new InvalidRequestException(errorCode);
            }
        }
    }

    static void writeTaggedValue(int value, DataOutputStream to, byte typeTag, short errorCode) throws IOException {
        to.writeByte(typeTag);
        switch (typeTag) {
            case 66: 
            case 90: {
                to.writeByte((byte)value);
                break;
            }
            case 83: {
                to.writeShort((short)value);
                break;
            }
            case 73: 
            case 76: 
            case 91: {
                to.writeInt(value);
                break;
            }
            default: {
                Log.LOG(3, "Unknown type: " + typeTag);
                throw new InvalidRequestException(errorCode);
            }
        }
    }

    private static ClassDebugInfo getReferenceType(VmState state, ClassicProxyProtocol proxy, int objectID) throws Exception {
        byte[] data = new byte[]{(byte)VMPacketHandler.CommandCode.GET_OBJECT_CLASS.getTag(), 2, (byte)(objectID >> 8), (byte)objectID};
        DataInputStream answer = proxy.sendToVmSync(data);
        byte typeTag = answer.readByte();
        if (typeTag == 32) {
            short packageID = (short)answer.read();
            int location = answer.readShort() & 0xFFFF;
            ClassDebugInfo classRef = state.classes().getClassByVMData(packageID, location);
            if (classRef != null) {
                return state.classes().getClassByID(classRef.getClassID());
            }
        }
        throw new InvalidRequestException(20);
    }

    static void writeArgumentList(DataInputStream fromIde, DataOutputStream toVm, int numArguments) throws IOException {
        for (int i = 0; i < numArguments; ++i) {
            byte typeTag = (byte)fromIde.read();
            ObjectReferenceConverters.writeTaggedValue(fromIde, toVm, typeTag, (short)20);
        }
    }

    static FieldDebugInfo copyFieldHeader(VMClassPool classes, DataInputStream in, DataOutputStream out) throws IOException {
        long fieldID = in.readLong();
        FieldDebugInfo fieldDebugInfo = classes.findFieldInfoByIndex(fieldID);
        if (fieldDebugInfo == null) {
            throw new InvalidRequestException(25);
        }
        int classID = ObjectReferenceConverters.extractClassId(fieldID);
        ClassDebugInfo cl = classes.getClassByID(classID);
        if (cl == null) {
            throw new InvalidRequestException(25);
        }
        out.writeByte((byte)cl.getPackageID());
        out.writeShort((short)cl.getLocation());
        return fieldDebugInfo;
    }

    static void registerObjectReferenceConverters(ClassicProxyProtocol proxy) {
        proxy.addConverter(9, 1, new ClassicPacketHandlerImpl(VMPacketHandler.CommandCode.GET_OBJECT_CLASS){

            @Override
            public ClassicPacketHandler.DeliveryType handleRequest(HandlerState handlerState, DataOutputStream toVm) throws Exception {
                int objectID = handlerState.in.readInt();
                Log.LOG(3, "ObjectReference:GetReferenceType (handleRequest objectID: " + objectID + ")");
                if (objectID == -32 || objectID == -31 || (objectID & Integer.MIN_VALUE) != 0) {
                    int classID = this.proxy.state().pool.getSystemClass().getClassID();
                    handlerState.args.put("systemClassID", classID);
                    return ClassicPacketHandler.DeliveryType.NONE;
                }
                toVm.writeShort((short)objectID);
                return ClassicPacketHandler.DeliveryType.NORMAL;
            }

            @Override
            public void processResponseData(HandlerState hState, DataInputStream fromVm, int length) throws Exception {
                Log.LOG(3, "ObjectReference:GetReferenceType (processResponseData)");
                Integer systemClassID = (Integer)hState.args.get("systemClassID");
                if (systemClassID != null) {
                    hState.out.writeByte(1);
                    hState.out.writeInt(systemClassID);
                    return;
                }
                byte typeTag = fromVm.readByte();
                if (typeTag == 32) {
                    hState.out.writeByte(1);
                    short packageID = fromVm.readByte();
                    short location = fromVm.readShort();
                    ClassDebugInfo classRef = this.proxy.state().classes().getClassByVMData(packageID, location);
                    if (classRef == null) {
                        classRef = this.proxy.state().classes().createStubOnVMData(packageID, location);
                    }
                    hState.out.writeInt(classRef.getClassID());
                } else {
                    hState.out.writeByte(3);
                    String signature = null;
                    switch (typeTag) {
                        case 96: {
                            signature = "[Z";
                            break;
                        }
                        case -128: {
                            signature = "[B";
                            break;
                        }
                        case -96: {
                            signature = "[S";
                            break;
                        }
                        case -64: {
                            signature = "[I";
                            break;
                        }
                        case -32: {
                            short compClassPackageID = fromVm.readByte();
                            short compClassLocation = fromVm.readShort();
                            ClassDebugInfo classRef = this.proxy.state().classes().getClassByVMData(compClassPackageID, compClassLocation);
                            if (classRef == null) {
                                throw new InvalidRequestException(20);
                            }
                            String compClassSignature = classRef.getClassSignature();
                            signature = "[" + compClassSignature;
                            break;
                        }
                        default: {
                            Log.LOG(3, "Unknown array type: " + typeTag);
                            throw new InvalidRequestException(20);
                        }
                    }
                    int classID = this.proxy.state().classes().getClassBySignature(signature).getClassID();
                    hState.out.writeInt(classID);
                }
            }
        });
        proxy.addConverter(9, 2, new ChainPacketHandler(VMPacketHandler.CommandCode.GET_INSTANCE_FIELD, 50){

            @Override
            protected int startChain(HandlerState state) throws Exception {
                state.args.put("objectID", state.in.readInt());
                int numFields = state.in.readInt();
                state.out.writeInt(numFields);
                return numFields;
            }

            @Override
            protected void handleChunk(boolean isHead, HandlerState state, DataOutputStream toVm, int chunkSize) throws Exception {
                int objectID = 2.getInt(state.args, "objectID");
                toVm.writeShort((short)objectID);
                Log.LOGN(3, "objectID: " + objectID);
                toVm.writeByte((byte)chunkSize);
                for (int field = 0; field < chunkSize; ++field) {
                    FieldDebugInfo fieldDebugInfo = ObjectReferenceConverters.copyFieldHeader(this.proxy.state().classes(), state.in, toVm);
                    Log.LOGN(3, "field type: " + fieldDebugInfo.getType());
                    toVm.writeByte(ReferenceTypeConverters.getTypeTag(fieldDebugInfo.getType()));
                    int token = fieldDebugInfo.getContents();
                    toVm.writeByte((byte)token);
                    Log.LOGN(3, "token: " + token);
                }
            }

            @Override
            protected void handleResponseChunk(boolean isHead, HandlerState state, int chunkSize, DataInputStream in, int length) throws Exception {
                in.readByte();
                EncodingUtils.copy(in, state.out, length - 1);
            }
        });
        proxy.addConverter(9, 3, new ChainPacketHandler(VMPacketHandler.CommandCode.SET_INSTANCE_FIELD, 50){

            @Override
            protected int startChain(HandlerState state) throws Exception {
                state.args.put("objectID", state.in.readInt());
                int numFields = state.in.readInt();
                state.out.writeInt(numFields);
                return numFields;
            }

            @Override
            protected void handleChunk(boolean isHead, HandlerState state, DataOutputStream toVm, int chunkSize) throws Exception {
                int objectID = 3.getInt(state.args, "objectID");
                toVm.writeShort((short)objectID);
                toVm.writeByte((byte)chunkSize);
                for (int field = 0; field < chunkSize; ++field) {
                    FieldDebugInfo fieldDebugInfo = ObjectReferenceConverters.copyFieldHeader(this.proxy.state().classes(), state.in, toVm);
                    String fieldType = fieldDebugInfo.getType();
                    byte typeTag = ReferenceTypeConverters.getTypeTag(fieldType);
                    int token = fieldDebugInfo.getContents();
                    toVm.writeByte((byte)token);
                    Log.LOGN(3, "token: " + token);
                    ObjectReferenceConverters.writeTaggedValue(state.in, toVm, typeTag, (short)25);
                }
            }
        });
        proxy.addConverter(9, 5, new UnsupportedOperationHandler(99));
        proxy.addConverter(9, 6, new ClassicPacketHandlerImpl(VMPacketHandler.CommandCode.INVOKE_METHOD){

            @Override
            public ClassicPacketHandler.DeliveryType handleRequest(HandlerState handlerState, DataOutputStream toVm) throws Exception {
                int methodAddr;
                MethodDebugInfo method;
                Log.LOGN(3, "ObjectReference: InvokeMethod");
                int objectID = handlerState.in.readInt();
                handlerState.in.readInt();
                int classID = handlerState.in.readInt();
                VMClassPool pool = this.proxy.state().classes();
                if (pool.isSystem(pool.getClassByID(classID))) {
                    handlerState.args.put("fakeresponse", classID);
                    return ClassicPacketHandler.DeliveryType.NONE;
                }
                int methodID = handlerState.in.readInt();
                ClassDebugInfo instanceClass = ObjectReferenceConverters.getReferenceType(this.proxy.state(), this.proxy, objectID);
                if (ClassDebugUtils.isFake_toString(instanceClass, method = pool.findMethodInfoByIndex(methodID), pool)) {
                    handlerState.args.put("fakeresponse", instanceClass.getClassID());
                    return ClassicPacketHandler.DeliveryType.NONE;
                }
                Log.LOGN(3, "ObjectReference: InvokeMethod " + instanceClass.getClassName() + "." + method.getName());
                toVm.writeByte(ObjectReferenceConverters.getReturnTypeTag(method));
                int numArguments = handlerState.in.readInt();
                toVm.writeByte((byte)(numArguments + 1));
                toVm.writeByte(76);
                toVm.writeInt(objectID);
                ObjectReferenceConverters.writeArgumentList(handlerState.in, toVm, numArguments);
                int options = handlerState.in.readInt();
                if ((options & 2) == 0) {
                    method = PacketEncodingUtils.resolveMethod(this.proxy.state().classes(), methodID, instanceClass);
                }
                if ((methodAddr = method.getMethodOffset()) == 0) {
                    throw new InvalidRequestException(23);
                }
                toVm.writeByte((byte)method.getParent().getPackageID());
                toVm.writeShort((short)methodAddr);
                return ClassicPacketHandler.DeliveryType.NORMAL;
            }

            @Override
            public void processResponseData(HandlerState state, DataInputStream fromVm, int length) throws Exception {
                Object arg = state.args.remove("fakeresponse");
                if (arg != null) {
                    byte[] returnValue_exception = new byte[]{115, 0, 0, 0, 0, 76, 0, 0, 0, 0};
                    int id = (Integer)arg;
                    returnValue_exception[1] = (byte)(id >>> 24 & 0xFF);
                    returnValue_exception[2] = (byte)(id >>> 16 & 0xFF);
                    returnValue_exception[3] = (byte)(id >>> 8 & 0xFF);
                    returnValue_exception[4] = (byte)(id & 0xFF);
                    Log.LOG(3, "use fake String " + Arrays.toString(returnValue_exception));
                    EncodingUtils.copy(new ByteArrayInputStream(returnValue_exception), state.out, returnValue_exception.length);
                } else {
                    EncodingUtils.copy(fromVm, state.out, length);
                }
            }
        });
        proxy.addConverter(9, 7, new FixedDataHandler(new Object[0]));
        proxy.addConverter(9, 8, new FixedDataHandler(new Object[0]));
        proxy.addConverter(9, 9, new ClassicPacketHandlerImpl(VMPacketHandler.CommandCode.IS_COLLECTED){

            @Override
            public ClassicPacketHandler.DeliveryType handleRequest(HandlerState handlerState, DataOutputStream toVm) throws Exception {
                Log.LOGN(3, "ObjectReference: IsCollected");
                int objectID = handlerState.in.readInt();
                toVm.writeShort((short)objectID);
                return ClassicPacketHandler.DeliveryType.NORMAL;
            }

            @Override
            public void processResponseData(HandlerState state, DataInputStream fromVm, int length) throws Exception {
                EncodingUtils.copy(fromVm, state.out, length);
            }
        });
    }
}

